"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaDestination = void 0;
const iam = require("../../aws-iam"); // Automatically re-written from '@aws-cdk/aws-iam'
const s3 = require("../../aws-s3"); // Automatically re-written from '@aws-cdk/aws-s3'
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
/**
 * (experimental) Use a Lambda function as a bucket notification destination.
 *
 * @experimental
 */
class LambdaDestination {
    /**
     * @experimental
     */
    constructor(fn) {
        this.fn = fn;
    }
    /**
     * (experimental) Registers this resource to receive notifications for the specified bucket.
     *
     * This method will only be called once for each destination/bucket
     * pair and the result will be cached, so there is no need to implement
     * idempotency in each destination.
     *
     * @experimental
     */
    bind(_scope, bucket) {
        const permissionId = `AllowBucketNotificationsTo${core_1.Names.nodeUniqueId(this.fn.permissionsNode)}`;
        if (!core_1.Construct.isConstruct(bucket)) {
            throw new Error(`LambdaDestination for function ${core_1.Names.nodeUniqueId(this.fn.permissionsNode)} can only be configured on a
        bucket construct (Bucket ${bucket.bucketName})`);
        }
        if (bucket.node.tryFindChild(permissionId) === undefined) {
            this.fn.addPermission(permissionId, {
                sourceAccount: core_1.Stack.of(bucket).account,
                principal: new iam.ServicePrincipal('s3.amazonaws.com'),
                sourceArn: bucket.bucketArn,
                // Placing the permissions node in the same scope as the s3 bucket.
                // Otherwise, there is a circular dependency when the s3 bucket
                // and lambda functions declared in different stacks.
                scope: bucket,
            });
        }
        // if we have a permission resource for this relationship, add it as a dependency
        // to the bucket notifications resource, so it will be created first.
        const permission = bucket.node.tryFindChild(permissionId);
        return {
            type: s3.BucketNotificationDestinationType.LAMBDA,
            arn: this.fn.functionArn,
            dependencies: permission ? [permission] : undefined,
        };
    }
}
exports.LambdaDestination = LambdaDestination;
//# sourceMappingURL=data:application/json;base64,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