import * as iam from "../../aws-iam";
import * as s3 from "../../aws-s3";
import * as s3_assets from "../../aws-s3-assets";
import * as cdk from "../../core";
/**
 * @experimental
 */
export interface SourceConfig {
    /**
     * (experimental) The source bucket to deploy from.
     *
     * @experimental
     */
    readonly bucket: s3.IBucket;
    /**
     * (experimental) An S3 object key in the source bucket that points to a zip file.
     *
     * @experimental
     */
    readonly zipObjectKey: string;
}
/**
 * (experimental) Bind context for ISources.
 *
 * @experimental
 */
export interface DeploymentSourceContext {
    /**
     * (experimental) The role for the handler.
     *
     * @experimental
     */
    readonly handlerRole: iam.IRole;
}
/**
 * (experimental) Represents a source for bucket deployments.
 *
 * @experimental
 */
export interface ISource {
    /**
     * (experimental) Binds the source to a bucket deployment.
     *
     * @param scope The construct tree context.
     * @experimental
     */
    bind(scope: cdk.Construct, context?: DeploymentSourceContext): SourceConfig;
}
/**
 * (experimental) Specifies bucket deployment source.
 *
 * Usage:
 *
 *      Source.bucket(bucket, key)
 *      Source.asset('/local/path/to/directory')
 *      Source.asset('/local/path/to/a/file.zip')
 *
 * @experimental
 */
export declare class Source {
    /**
     * (experimental) Uses a .zip file stored in an S3 bucket as the source for the destination bucket contents.
     *
     * @param bucket The S3 Bucket.
     * @param zipObjectKey The S3 object key of the zip file with contents.
     * @experimental
     */
    static bucket(bucket: s3.IBucket, zipObjectKey: string): ISource;
    /**
     * (experimental) Uses a local asset as the deployment source.
     *
     * @param path The path to a local .zip file or a directory.
     * @experimental
     */
    static asset(path: string, options?: s3_assets.AssetOptions): ISource;
    private constructor();
}
