"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InterfaceVpcEndpointTarget = void 0;
const cdk = require("../../core"); // Automatically re-written from '@aws-cdk/core'
/**
 * (experimental) Set an InterfaceVpcEndpoint as a target for an ARecord.
 *
 * @experimental
 */
class InterfaceVpcEndpointTarget {
    /**
     * @experimental
     */
    constructor(vpcEndpoint) {
        this.vpcEndpoint = vpcEndpoint;
        this.cfnVpcEndpoint = this.vpcEndpoint.node.findChild('Resource');
    }
    /**
     * (experimental) Return hosted zone ID and DNS name, usable for Route53 alias targets.
     *
     * @experimental
     */
    bind(_record) {
        return {
            dnsName: cdk.Fn.select(1, cdk.Fn.split(':', cdk.Fn.select(0, this.cfnVpcEndpoint.attrDnsEntries))),
            hostedZoneId: cdk.Fn.select(0, cdk.Fn.split(':', cdk.Fn.select(0, this.cfnVpcEndpoint.attrDnsEntries))),
        };
    }
}
exports.InterfaceVpcEndpointTarget = InterfaceVpcEndpointTarget;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZXJmYWNlLXZwYy1lbmRwb2ludC10YXJnZXQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJpbnRlcmZhY2UtdnBjLWVuZHBvaW50LXRhcmdldC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFFQSxrQ0FBa0MsQ0FBQyxnREFBZ0Q7Ozs7OztBQUluRixNQUFhLDBCQUEwQjs7OztJQUVuQyxZQUE2QixXQUFzQztRQUF0QyxnQkFBVyxHQUFYLFdBQVcsQ0FBMkI7UUFDL0QsSUFBSSxDQUFDLGNBQWMsR0FBRyxJQUFJLENBQUMsV0FBVyxDQUFDLElBQUksQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUF1QixDQUFDO0lBQzVGLENBQUM7Ozs7OztJQUNNLElBQUksQ0FBQyxPQUEyQjtRQUNuQyxPQUFPO1lBQ0gsT0FBTyxFQUFFLEdBQUcsQ0FBQyxFQUFFLENBQUMsTUFBTSxDQUFDLENBQUMsRUFBRSxHQUFHLENBQUMsRUFBRSxDQUFDLEtBQUssQ0FBQyxHQUFHLEVBQUUsR0FBRyxDQUFDLEVBQUUsQ0FBQyxNQUFNLENBQUMsQ0FBQyxFQUFFLElBQUksQ0FBQyxjQUFjLENBQUMsY0FBYyxDQUFDLENBQUMsQ0FBQztZQUNsRyxZQUFZLEVBQUUsR0FBRyxDQUFDLEVBQUUsQ0FBQyxNQUFNLENBQUMsQ0FBQyxFQUFFLEdBQUcsQ0FBQyxFQUFFLENBQUMsS0FBSyxDQUFDLEdBQUcsRUFBRSxHQUFHLENBQUMsRUFBRSxDQUFDLE1BQU0sQ0FBQyxDQUFDLEVBQUUsSUFBSSxDQUFDLGNBQWMsQ0FBQyxjQUFjLENBQUMsQ0FBQyxDQUFDO1NBQzFHLENBQUM7SUFDTixDQUFDO0NBQ0o7QUFYRCxnRUFXQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGVjMiBmcm9tIFwiLi4vLi4vYXdzLWVjMlwiOyAvLyBBdXRvbWF0aWNhbGx5IHJlLXdyaXR0ZW4gZnJvbSAnQGF3cy1jZGsvYXdzLWVjMidcbmltcG9ydCAqIGFzIHJvdXRlNTMgZnJvbSBcIi4uLy4uL2F3cy1yb3V0ZTUzXCI7IC8vIEF1dG9tYXRpY2FsbHkgcmUtd3JpdHRlbiBmcm9tICdAYXdzLWNkay9hd3Mtcm91dGU1MydcbmltcG9ydCAqIGFzIGNkayBmcm9tIFwiLi4vLi4vY29yZVwiOyAvLyBBdXRvbWF0aWNhbGx5IHJlLXdyaXR0ZW4gZnJvbSAnQGF3cy1jZGsvY29yZSdcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgY2xhc3MgSW50ZXJmYWNlVnBjRW5kcG9pbnRUYXJnZXQgaW1wbGVtZW50cyByb3V0ZTUzLklBbGlhc1JlY29yZFRhcmdldCB7XG4gICAgcHJpdmF0ZSByZWFkb25seSBjZm5WcGNFbmRwb2ludDogZWMyLkNmblZQQ0VuZHBvaW50O1xuICAgIGNvbnN0cnVjdG9yKHByaXZhdGUgcmVhZG9ubHkgdnBjRW5kcG9pbnQ6IGVjMi5JSW50ZXJmYWNlVnBjRW5kcG9pbnQpIHtcbiAgICAgICAgdGhpcy5jZm5WcGNFbmRwb2ludCA9IHRoaXMudnBjRW5kcG9pbnQubm9kZS5maW5kQ2hpbGQoJ1Jlc291cmNlJykgYXMgZWMyLkNmblZQQ0VuZHBvaW50O1xuICAgIH1cbiAgICBwdWJsaWMgYmluZChfcmVjb3JkOiByb3V0ZTUzLklSZWNvcmRTZXQpOiByb3V0ZTUzLkFsaWFzUmVjb3JkVGFyZ2V0Q29uZmlnIHtcbiAgICAgICAgcmV0dXJuIHtcbiAgICAgICAgICAgIGRuc05hbWU6IGNkay5Gbi5zZWxlY3QoMSwgY2RrLkZuLnNwbGl0KCc6JywgY2RrLkZuLnNlbGVjdCgwLCB0aGlzLmNmblZwY0VuZHBvaW50LmF0dHJEbnNFbnRyaWVzKSkpLFxuICAgICAgICAgICAgaG9zdGVkWm9uZUlkOiBjZGsuRm4uc2VsZWN0KDAsIGNkay5Gbi5zcGxpdCgnOicsIGNkay5Gbi5zZWxlY3QoMCwgdGhpcy5jZm5WcGNFbmRwb2ludC5hdHRyRG5zRW50cmllcykpKSxcbiAgICAgICAgfTtcbiAgICB9XG59XG4iXX0=