"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudFrontTarget = void 0;
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
/**
 * (experimental) Use a CloudFront Distribution as an alias record target.
 *
 * @experimental
 */
class CloudFrontTarget {
    /**
     * @experimental
     */
    constructor(distribution) {
        this.distribution = distribution;
    }
    /**
     * (experimental) Get the hosted zone id for the current scope.
     *
     * @param scope - scope in which this resource is defined.
     * @experimental
     */
    static getHostedZoneId(scope) {
        var _a;
        const mappingName = 'AWSCloudFrontPartitionHostedZoneIdMap';
        const scopeStack = core_1.Stack.of(scope);
        let mapping = (_a = scopeStack.node.tryFindChild(mappingName)) !== null && _a !== void 0 ? _a : new core_1.CfnMapping(scopeStack, mappingName, {
            mapping: {
                ['aws']: {
                    zoneId: 'Z2FDTNDATAQYW2',
                },
                ['aws-cn']: {
                    zoneId: 'Z3RFFRIM2A3IF5',
                },
            },
        });
        return mapping.findInMap(core_1.Aws.PARTITION, 'zoneId');
    }
    /**
     * (experimental) Return hosted zone ID and DNS name, usable for Route53 alias targets.
     *
     * @experimental
     */
    bind(_record) {
        return {
            hostedZoneId: CloudFrontTarget.getHostedZoneId(this.distribution),
            dnsName: this.distribution.domainName,
        };
    }
}
exports.CloudFrontTarget = CloudFrontTarget;
/**
 * (experimental) The hosted zone Id if using an alias record in Route53.
 *
 * This value never changes.
 *
 * @experimental
 */
CloudFrontTarget.CLOUDFRONT_ZONE_ID = 'Z2FDTNDATAQYW2';
//# sourceMappingURL=data:application/json;base64,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