import * as ec2 from "../../aws-ec2";
import * as iam from "../../aws-iam";
import * as secretsmanager from "../../aws-secretsmanager";
import * as cdk from "../../core";
import { Construct } from 'constructs';
import { IDatabaseCluster } from './cluster-ref';
import { IDatabaseInstance } from './instance';
/**
 * (experimental) SessionPinningFilter.
 *
 * @see https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-proxy.html#rds-proxy-pinning
 * @experimental
 */
export declare class SessionPinningFilter {
    /**
     * Filter name
     */
    readonly filterName: string;
    /**
     * (experimental) You can opt out of session pinning for the following kinds of application statements:.
     *
     * - Setting session variables and configuration settings.
     *
     * @experimental
     */
    static readonly EXCLUDE_VARIABLE_SETS: SessionPinningFilter;
    /**
     * (experimental) custom filter.
     *
     * @experimental
     */
    static of(filterName: string): SessionPinningFilter;
    private constructor();
}
/**
 * (experimental) Proxy target: Instance or Cluster.
 *
 * A target group is a collection of databases that the proxy can connect to.
 * Currently, you can specify only one RDS DB instance or Aurora DB cluster.
 *
 * @experimental
 */
export declare class ProxyTarget {
    private readonly dbInstance;
    private readonly dbCluster;
    /**
     * (experimental) From instance.
     *
     * @param instance RDS database instance.
     * @experimental
     */
    static fromInstance(instance: IDatabaseInstance): ProxyTarget;
    /**
     * (experimental) From cluster.
     *
     * @param cluster RDS database cluster.
     * @experimental
     */
    static fromCluster(cluster: IDatabaseCluster): ProxyTarget;
    private constructor();
    /**
     * (experimental) Bind this target to the specified database proxy.
     *
     * @experimental
     */
    bind(_: DatabaseProxy): ProxyTargetConfig;
}
/**
 * (experimental) The result of binding a `ProxyTarget` to a `DatabaseProxy`.
 *
 * @experimental
 */
export interface ProxyTargetConfig {
    /**
     * (experimental) The engine family of the database instance or cluster this proxy connects with.
     *
     * @experimental
     */
    readonly engineFamily: string;
    /**
     * (experimental) The database instances to which this proxy connects.
     *
     * Either this or `dbClusters` will be set and the other `undefined`.
     *
     * @default - `undefined` if `dbClusters` is set.
     * @experimental
     */
    readonly dbInstances?: IDatabaseInstance[];
    /**
     * (experimental) The database clusters to which this proxy connects.
     *
     * Either this or `dbInstances` will be set and the other `undefined`.
     *
     * @default - `undefined` if `dbInstances` is set.
     * @experimental
     */
    readonly dbClusters?: IDatabaseCluster[];
}
/**
 * (experimental) Options for a new DatabaseProxy.
 *
 * @experimental
 */
export interface DatabaseProxyOptions {
    /**
     * (experimental) The identifier for the proxy.
     *
     * This name must be unique for all proxies owned by your AWS account in the specified AWS Region.
     * An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens;
     * it can't end with a hyphen or contain two consecutive hyphens.
     *
     * @default - Generated by CloudFormation (recommended)
     * @experimental
     */
    readonly dbProxyName?: string;
    /**
     * (experimental) The duration for a proxy to wait for a connection to become available in the connection pool.
     *
     * Only applies when the proxy has opened its maximum number of connections and all connections are busy with client
     * sessions.
     *
     * Value must be between 1 second and 1 hour, or `Duration.seconds(0)` to represent unlimited.
     *
     * @default cdk.Duration.seconds(120)
     * @experimental
     */
    readonly borrowTimeout?: cdk.Duration;
    /**
     * (experimental) One or more SQL statements for the proxy to run when opening each new database connection.
     *
     * Typically used with SET statements to make sure that each connection has identical settings such as time zone
     * and character set.
     * For multiple statements, use semicolons as the separator.
     * You can also include multiple variables in a single SET statement, such as SET x=1, y=2.
     *
     * not currently supported for PostgreSQL.
     *
     * @default - no initialization query
     * @experimental
     */
    readonly initQuery?: string;
    /**
     * (experimental) The maximum size of the connection pool for each target in a target group.
     *
     * For Aurora MySQL, it is expressed as a percentage of the max_connections setting for the RDS DB instance or Aurora DB
     * cluster used by the target group.
     *
     * 1-100
     *
     * @default 100
     * @experimental
     */
    readonly maxConnectionsPercent?: number;
    /**
     * (experimental) Controls how actively the proxy closes idle database connections in the connection pool.
     *
     * A high value enables the proxy to leave a high percentage of idle connections open.
     * A low value causes the proxy to close idle client connections and return the underlying database connections
     * to the connection pool.
     * For Aurora MySQL, it is expressed as a percentage of the max_connections setting for the RDS DB instance
     * or Aurora DB cluster used by the target group.
     *
     * between 0 and MaxConnectionsPercent
     *
     * @default 50
     * @experimental
     */
    readonly maxIdleConnectionsPercent?: number;
    /**
     * (experimental) Each item in the list represents a class of SQL operations that normally cause all later statements in a session using a proxy to be pinned to the same underlying database connection.
     *
     * Including an item in the list exempts that class of SQL operations from the pinning behavior.
     *
     * @default - no session pinning filters
     * @experimental
     */
    readonly sessionPinningFilters?: SessionPinningFilter[];
    /**
     * (experimental) Whether the proxy includes detailed information about SQL statements in its logs.
     *
     * This information helps you to debug issues involving SQL behavior or the performance and scalability of the proxy connections.
     * The debug information includes the text of SQL statements that you submit through the proxy.
     * Thus, only enable this setting when needed for debugging, and only when you have security measures in place to safeguard any sensitive
     * information that appears in the logs.
     *
     * @default false
     * @experimental
     */
    readonly debugLogging?: boolean;
    /**
     * (experimental) Whether to require or disallow AWS Identity and Access Management (IAM) authentication for connections to the proxy.
     *
     * @default false
     * @experimental
     */
    readonly iamAuth?: boolean;
    /**
     * (experimental) The number of seconds that a connection to the proxy can be inactive before the proxy disconnects it.
     *
     * You can set this value higher or lower than the connection timeout limit for the associated database.
     *
     * @default cdk.Duration.minutes(30)
     * @experimental
     */
    readonly idleClientTimeout?: cdk.Duration;
    /**
     * (experimental) A Boolean parameter that specifies whether Transport Layer Security (TLS) encryption is required for connections to the proxy.
     *
     * By enabling this setting, you can enforce encrypted TLS connections to the proxy.
     *
     * @default true
     * @experimental
     */
    readonly requireTLS?: boolean;
    /**
     * (experimental) IAM role that the proxy uses to access secrets in AWS Secrets Manager.
     *
     * @default - A role will automatically be created
     * @experimental
     */
    readonly role?: iam.IRole;
    /**
     * (experimental) The secret that the proxy uses to authenticate to the RDS DB instance or Aurora DB cluster.
     *
     * These secrets are stored within Amazon Secrets Manager.
     * One or more secrets are required.
     *
     * @experimental
     */
    readonly secrets: secretsmanager.ISecret[];
    /**
     * (experimental) One or more VPC security groups to associate with the new proxy.
     *
     * @default - No security groups
     * @experimental
     */
    readonly securityGroups?: ec2.ISecurityGroup[];
    /**
     * (experimental) The subnets used by the proxy.
     *
     * @default - the VPC default strategy if not specified.
     * @experimental
     */
    readonly vpcSubnets?: ec2.SubnetSelection;
    /**
     * (experimental) The VPC to associate with the new proxy.
     *
     * @experimental
     */
    readonly vpc: ec2.IVpc;
}
/**
 * (experimental) Construction properties for a DatabaseProxy.
 *
 * @experimental
 */
export interface DatabaseProxyProps extends DatabaseProxyOptions {
    /**
     * (experimental) DB proxy target: Instance or Cluster.
     *
     * @experimental
     */
    readonly proxyTarget: ProxyTarget;
}
/**
 * (experimental) Properties that describe an existing DB Proxy.
 *
 * @experimental
 */
export interface DatabaseProxyAttributes {
    /**
     * (experimental) DB Proxy Name.
     *
     * @experimental
     */
    readonly dbProxyName: string;
    /**
     * (experimental) DB Proxy ARN.
     *
     * @experimental
     */
    readonly dbProxyArn: string;
    /**
     * (experimental) Endpoint.
     *
     * @experimental
     */
    readonly endpoint: string;
    /**
     * (experimental) The security groups of the instance.
     *
     * @experimental
     */
    readonly securityGroups: ec2.ISecurityGroup[];
}
/**
 * (experimental) DB Proxy.
 *
 * @experimental
 */
export interface IDatabaseProxy extends cdk.IResource {
    /**
     * (experimental) DB Proxy Name.
     *
     * @experimental
     * @attribute true
     */
    readonly dbProxyName: string;
    /**
     * (experimental) DB Proxy ARN.
     *
     * @experimental
     * @attribute true
     */
    readonly dbProxyArn: string;
    /**
     * (experimental) Endpoint.
     *
     * @experimental
     * @attribute true
     */
    readonly endpoint: string;
}
/**
 * (experimental) RDS Database Proxy.
 *
 * @experimental
 * @resource AWS::RDS::DBProxy
 */
export declare class DatabaseProxy extends cdk.Resource implements IDatabaseProxy, ec2.IConnectable, secretsmanager.ISecretAttachmentTarget {
    /**
     * (experimental) Import an existing database proxy.
     *
     * @experimental
     */
    static fromDatabaseProxyAttributes(scope: Construct, id: string, attrs: DatabaseProxyAttributes): IDatabaseProxy;
    /**
     * (experimental) DB Proxy Name.
     *
     * @experimental
     * @attribute true
     */
    readonly dbProxyName: string;
    /**
     * (experimental) DB Proxy ARN.
     *
     * @experimental
     * @attribute true
     */
    readonly dbProxyArn: string;
    /**
     * (experimental) Endpoint.
     *
     * @experimental
     * @attribute true
     */
    readonly endpoint: string;
    /**
     * (experimental) Access to network connections.
     *
     * @experimental
     */
    readonly connections: ec2.Connections;
    private readonly resource;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: DatabaseProxyProps);
    /**
     * (experimental) Renders the secret attachment target specifications.
     *
     * @experimental
     */
    asSecretAttachmentTarget(): secretsmanager.SecretAttachmentTargetProps;
}
