import * as ec2 from "../../aws-ec2";
import * as kms from "../../aws-kms";
import * as secretsmanager from "../../aws-secretsmanager";
import { Duration, SecretValue } from "../../core";
import { IParameterGroup } from './parameter-group';
/**
 * (experimental) Instance properties for database instances.
 *
 * @experimental
 */
export interface InstanceProps {
    /**
     * (experimental) What type of instance to start for the replicas.
     *
     * @default - t3.medium (or, more precisely, db.t3.medium)
     * @experimental
     */
    readonly instanceType?: ec2.InstanceType;
    /**
     * (experimental) What subnets to run the RDS instances in.
     *
     * Must be at least 2 subnets in two different AZs.
     *
     * @experimental
     */
    readonly vpc: ec2.IVpc;
    /**
     * (experimental) Where to place the instances within the VPC.
     *
     * @default - the Vpc default strategy if not specified.
     * @experimental
     */
    readonly vpcSubnets?: ec2.SubnetSelection;
    /**
     * (experimental) Security group.
     *
     * @default a new security group is created.
     * @experimental
     */
    readonly securityGroups?: ec2.ISecurityGroup[];
    /**
     * (experimental) The DB parameter group to associate with the instance.
     *
     * @default no parameter group
     * @experimental
     */
    readonly parameterGroup?: IParameterGroup;
    /**
     * (experimental) Whether to enable Performance Insights for the DB instance.
     *
     * @default - false, unless ``performanceInsightRentention`` or ``performanceInsightEncryptionKey`` is set.
     * @experimental
     */
    readonly enablePerformanceInsights?: boolean;
    /**
     * (experimental) The amount of time, in days, to retain Performance Insights data.
     *
     * @default 7
     * @experimental
     */
    readonly performanceInsightRetention?: PerformanceInsightRetention;
    /**
     * (experimental) The AWS KMS key for encryption of Performance Insights data.
     *
     * @default - default master key
     * @experimental
     */
    readonly performanceInsightEncryptionKey?: kms.IKey;
    /**
     * (experimental) Whether to enable automatic upgrade of minor version for the DB instance.
     *
     * @default - true
     * @experimental
     */
    readonly autoMinorVersionUpgrade?: boolean;
    /**
     * (experimental) Whether to allow upgrade of major version for the DB instance.
     *
     * @default - false
     * @experimental
     */
    readonly allowMajorVersionUpgrade?: boolean;
    /**
     * (experimental) Whether to remove automated backups immediately after the DB instance is deleted for the DB instance.
     *
     * @default - true
     * @experimental
     */
    readonly deleteAutomatedBackups?: boolean;
}
/**
 * (experimental) Backup configuration for RDS databases.
 *
 * @default - The retention period for automated backups is 1 day.
 * The preferred backup window will be a 30-minute window selected at random
 * from an 8-hour block of time for each AWS Region.
 * @see https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithAutomatedBackups.html#USER_WorkingWithAutomatedBackups.BackupWindow
 * @experimental
 */
export interface BackupProps {
    /**
     * (experimental) How many days to retain the backup.
     *
     * @experimental
     */
    readonly retention: Duration;
    /**
     * (experimental) A daily time range in 24-hours UTC format in which backups preferably execute.
     *
     * Must be at least 30 minutes long.
     *
     * Example: '01:00-02:00'
     *
     * @default - a 30-minute window selected at random from an 8-hour block of
     * time for each AWS Region. To see the time blocks available, see
     * https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithAutomatedBackups.html#USER_WorkingWithAutomatedBackups.BackupWindow
     * @experimental
     */
    readonly preferredWindow?: string;
}
/**
 * (experimental) Options for creating a Login from a username.
 *
 * @experimental
 */
export interface CredentialsFromUsernameOptions {
    /**
     * (experimental) Password.
     *
     * Do not put passwords in your CDK code directly.
     *
     * @default - a Secrets Manager generated password
     * @experimental
     */
    readonly password?: SecretValue;
    /**
     * (experimental) KMS encryption key to encrypt the generated secret.
     *
     * @default - default master key
     * @experimental
     */
    readonly encryptionKey?: kms.IKey;
    /**
     * (experimental) The characters to exclude from the generated password.
     *
     * Has no effect if {@link password} has been provided.
     *
     * @default - the DatabaseSecret default exclude character set (" %+~`#$&*()|[]{}:;<>?!'/
     * @experimental
     * @ \"\\")
     */
    readonly excludeCharacters?: string;
}
/**
 * (experimental) Username and password combination.
 *
 * @experimental
 */
export declare abstract class Credentials {
    /**
     * (experimental) Creates Credentials for the given username, and optional password and key.
     *
     * If no password is provided, one will be generated and stored in SecretsManager.
     *
     * @experimental
     */
    static fromUsername(username: string, options?: CredentialsFromUsernameOptions): Credentials;
    /**
     * (experimental) Creates Credentials from an existing SecretsManager ``Secret`` (or ``DatabaseSecret``).
     *
     * The Secret must be a JSON string with a ``username`` and ``password`` field:
     * ```
     * {
     *    ...
     *    "username": <required: username>,
     *    "password": <required: password>,
     * }
     * ```
     *
     * @experimental
     */
    static fromSecret(secret: secretsmanager.ISecret): Credentials;
    /**
     * (experimental) Username.
     *
     * @experimental
     */
    abstract readonly username: string;
    /**
     * (experimental) Password.
     *
     * Do not put passwords in your CDK code directly.
     *
     * @default - a Secrets Manager generated password
     * @experimental
     */
    abstract readonly password?: SecretValue;
    /**
     * (experimental) KMS encryption key to encrypt the generated secret.
     *
     * @default - default master key
     * @experimental
     */
    abstract readonly encryptionKey?: kms.IKey;
    /**
     * (experimental) Secret used to instantiate this Login.
     *
     * @default - none
     * @experimental
     */
    abstract readonly secret?: secretsmanager.ISecret;
    /**
     * (experimental) The characters to exclude from the generated password.
     *
     * Only used if {@link password} has not been set.
     *
     * @default - the DatabaseSecret default exclude character set (" %+~`#$&*()|[]{}:;<>?!'/
     * @experimental
     * @ \"\\")
     */
    abstract readonly excludeCharacters?: string;
}
/**
 * (experimental) Options used in the {@link SnapshotCredentials.fromGeneratedPassword} method.
 *
 * @experimental
 */
export interface SnapshotCredentialsFromGeneratedPasswordOptions {
    /**
     * (experimental) KMS encryption key to encrypt the generated secret.
     *
     * @default - default master key
     * @experimental
     */
    readonly encryptionKey?: kms.IKey;
    /**
     * (experimental) The characters to exclude from the generated password.
     *
     * @default - the DatabaseSecret default exclude character set (" %+~`#$&*()|[]{}:;<>?!'/
     * @experimental
     * @ \"\\")
     */
    readonly excludeCharacters?: string;
}
/**
 * (experimental) Credentials to update the password for a ``DatabaseInstanceFromSnapshot``.
 *
 * @experimental
 */
export declare abstract class SnapshotCredentials {
    /**
     * (experimental) Generate a new password for the snapshot, using the existing username and an optional encryption key.
     *
     * Note - The username must match the existing master username of the snapshot.
     *
     * @experimental
     */
    static fromGeneratedPassword(username: string, options?: SnapshotCredentialsFromGeneratedPasswordOptions): SnapshotCredentials;
    /**
     * (experimental) Update the snapshot login with an existing password.
     *
     * @experimental
     */
    static fromPassword(password: SecretValue): SnapshotCredentials;
    /**
     * (experimental) Update the snapshot login with an existing password from a Secret.
     *
     * The Secret must be a JSON string with a ``password`` field:
     * ```
     * {
     *    ...
     *    "password": <required: password>,
     * }
     * ```
     *
     * @experimental
     */
    static fromSecret(secret: secretsmanager.Secret): SnapshotCredentials;
    /**
     * (experimental) The master user name.
     *
     * Must be the **current** master user name of the snapshot.
     * It is not possible to change the master user name of a RDS instance.
     *
     * @default - the existing username from the snapshot
     * @experimental
     */
    abstract readonly username?: string;
    /**
     * (experimental) Whether a new password should be generated.
     *
     * @experimental
     */
    abstract readonly generatePassword: boolean;
    /**
     * (experimental) The master user password.
     *
     * Do not put passwords in your CDK code directly.
     *
     * @default - the existing password from the snapshot
     * @experimental
     */
    abstract readonly password?: SecretValue;
    /**
     * (experimental) KMS encryption key to encrypt the generated secret.
     *
     * @default - default master key
     * @experimental
     */
    abstract readonly encryptionKey?: kms.IKey;
    /**
     * (experimental) Secret used to instantiate this Login.
     *
     * @default - none
     * @experimental
     */
    abstract readonly secret?: secretsmanager.Secret;
    /**
     * (experimental) The characters to exclude from the generated password.
     *
     * Only used if {@link generatePassword} if true.
     *
     * @default - the DatabaseSecret default exclude character set (" %+~`#$&*()|[]{}:;<>?!'/
     * @experimental
     * @ \"\\")
     */
    abstract readonly excludeCharacters?: string;
}
/**
 * Properties common to single-user and multi-user rotation options.
 */
interface CommonRotationUserOptions {
    /**
     * (experimental) Specifies the number of days after the previous rotation before Secrets Manager triggers the next automatic rotation.
     *
     * @default - 30 days
     * @experimental
     */
    readonly automaticallyAfter?: Duration;
    /**
     * (experimental) Specifies characters to not include in generated passwords.
     *
     * @default " %+~`#$&*()|[]{}:;<>?!'/
     * @experimental
     * @ \"\\"
     */
    readonly excludeCharacters?: string;
}
/**
 * (experimental) Options to add the multi user rotation.
 *
 * @experimental
 */
export interface RotationSingleUserOptions extends CommonRotationUserOptions {
}
/**
 * (experimental) Options to add the multi user rotation.
 *
 * @experimental
 */
export interface RotationMultiUserOptions extends CommonRotationUserOptions {
    /**
     * (experimental) The secret to rotate.
     *
     * It must be a JSON string with the following format:
     * ```
     * {
     *    "engine": <required: database engine>,
     *    "host": <required: instance host name>,
     *    "username": <required: username>,
     *    "password": <required: password>,
     *    "dbname": <optional: database name>,
     *    "port": <optional: if not specified, default port will be used>,
     *    "masterarn": <required: the arn of the master secret which will be used to create users/change passwords>
     * }
     * ```
     *
     * @experimental
     */
    readonly secret: secretsmanager.ISecret;
}
/**
 * (experimental) The retention period for Performance Insight.
 *
 * @experimental
 */
export declare enum PerformanceInsightRetention {
    /**
     * (experimental) Default retention period of 7 days.
     *
     * @experimental
     */
    DEFAULT = 7,
    /**
     * (experimental) Long term retention period of 2 years.
     *
     * @experimental
     */
    LONG_TERM = 731
}
export {};
