import * as ec2 from "../../aws-ec2";
import { IResource, Resource } from "../../core";
import { Construct } from 'constructs';
import { IInstanceEngine } from './instance-engine';
/**
 * (experimental) An option group.
 *
 * @experimental
 */
export interface IOptionGroup extends IResource {
    /**
     * (experimental) The name of the option group.
     *
     * @experimental
     * @attribute true
     */
    readonly optionGroupName: string;
    /**
     * (experimental) Adds a configuration to this OptionGroup.
     *
     * This method is a no-op for an imported OptionGroup.
     *
     * @returns true if the OptionConfiguration was successfully added.
     * @experimental
     */
    addConfiguration(configuration: OptionConfiguration): boolean;
}
/**
 * (experimental) Configuration properties for an option.
 *
 * @experimental
 */
export interface OptionConfiguration {
    /**
     * (experimental) The name of the option.
     *
     * @experimental
     */
    readonly name: string;
    /**
     * (experimental) The settings for the option.
     *
     * @default - no settings
     * @experimental
     */
    readonly settings?: {
        [name: string]: string;
    };
    /**
     * (experimental) The version for the option.
     *
     * @default - no version
     * @experimental
     */
    readonly version?: string;
    /**
     * (experimental) The port number that this option uses.
     *
     * If `port` is specified then `vpc`
     * must also be specified.
     *
     * @default - no port
     * @experimental
     */
    readonly port?: number;
    /**
     * (experimental) The VPC where a security group should be created for this option.
     *
     * If `vpc`
     * is specified then `port` must also be specified.
     *
     * @default - no VPC
     * @experimental
     */
    readonly vpc?: ec2.IVpc;
    /**
     * (experimental) Optional list of security groups to use for this option, if `vpc` is specified.
     *
     * If no groups are provided, a default one will be created.
     *
     * @default - a default group will be created if `port` or `vpc` are specified.
     * @experimental
     */
    readonly securityGroups?: ec2.ISecurityGroup[];
}
/**
 * (experimental) Construction properties for an OptionGroup.
 *
 * @experimental
 */
export interface OptionGroupProps {
    /**
     * (experimental) The database engine that this option group is associated with.
     *
     * @experimental
     */
    readonly engine: IInstanceEngine;
    /**
     * (experimental) A description of the option group.
     *
     * @default a CDK generated description
     * @experimental
     */
    readonly description?: string;
    /**
     * (experimental) The configurations for this option group.
     *
     * @experimental
     */
    readonly configurations: OptionConfiguration[];
}
/**
 * (experimental) An option group.
 *
 * @experimental
 */
export declare class OptionGroup extends Resource implements IOptionGroup {
    /**
     * (experimental) Import an existing option group.
     *
     * @experimental
     */
    static fromOptionGroupName(scope: Construct, id: string, optionGroupName: string): IOptionGroup;
    /**
     * (experimental) The name of the option group.
     *
     * @experimental
     */
    readonly optionGroupName: string;
    /**
     * (experimental) The connections object for the options.
     *
     * @experimental
     */
    readonly optionConnections: {
        [key: string]: ec2.Connections;
    };
    private readonly configurations;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: OptionGroupProps);
    /**
     * (experimental) Adds a configuration to this OptionGroup.
     *
     * This method is a no-op for an imported OptionGroup.
     *
     * @experimental
     */
    addConfiguration(configuration: OptionConfiguration): boolean;
    /**
     * Renders the option configurations specifications.
     */
    private renderConfigurations;
}
