import * as cdk from "../../core";
import * as cfn_parse from "../../core/lib/cfn-parse";
/**
 * Properties for defining a `AWS::MSK::Cluster`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html
 * @external
 */
export interface CfnClusterProps {
    /**
     * `AWS::MSK::Cluster.BrokerNodeGroupInfo`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html#cfn-msk-cluster-brokernodegroupinfo
     * @external
     */
    readonly brokerNodeGroupInfo: CfnCluster.BrokerNodeGroupInfoProperty | cdk.IResolvable;
    /**
     * `AWS::MSK::Cluster.ClusterName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html#cfn-msk-cluster-clustername
     * @external
     */
    readonly clusterName: string;
    /**
     * `AWS::MSK::Cluster.KafkaVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html#cfn-msk-cluster-kafkaversion
     * @external
     */
    readonly kafkaVersion: string;
    /**
     * `AWS::MSK::Cluster.NumberOfBrokerNodes`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html#cfn-msk-cluster-numberofbrokernodes
     * @external
     */
    readonly numberOfBrokerNodes: number;
    /**
     * `AWS::MSK::Cluster.ClientAuthentication`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html#cfn-msk-cluster-clientauthentication
     * @external
     */
    readonly clientAuthentication?: CfnCluster.ClientAuthenticationProperty | cdk.IResolvable;
    /**
     * `AWS::MSK::Cluster.ConfigurationInfo`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html#cfn-msk-cluster-configurationinfo
     * @external
     */
    readonly configurationInfo?: CfnCluster.ConfigurationInfoProperty | cdk.IResolvable;
    /**
     * `AWS::MSK::Cluster.EncryptionInfo`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html#cfn-msk-cluster-encryptioninfo
     * @external
     */
    readonly encryptionInfo?: CfnCluster.EncryptionInfoProperty | cdk.IResolvable;
    /**
     * `AWS::MSK::Cluster.EnhancedMonitoring`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html#cfn-msk-cluster-enhancedmonitoring
     * @external
     */
    readonly enhancedMonitoring?: string;
    /**
     * `AWS::MSK::Cluster.LoggingInfo`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html#cfn-msk-cluster-logginginfo
     * @external
     */
    readonly loggingInfo?: CfnCluster.LoggingInfoProperty | cdk.IResolvable;
    /**
     * `AWS::MSK::Cluster.OpenMonitoring`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html#cfn-msk-cluster-openmonitoring
     * @external
     */
    readonly openMonitoring?: CfnCluster.OpenMonitoringProperty | cdk.IResolvable;
    /**
     * `AWS::MSK::Cluster.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html#cfn-msk-cluster-tags
     * @external
     */
    readonly tags?: any;
}
/**
 * A CloudFormation `AWS::MSK::Cluster`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html
 * @external
 * @cloudformationResource AWS::MSK::Cluster
 */
export declare class CfnCluster extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::MSK::Cluster";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnCluster;
    /**
     * `AWS::MSK::Cluster.BrokerNodeGroupInfo`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html#cfn-msk-cluster-brokernodegroupinfo
     * @external
     */
    brokerNodeGroupInfo: CfnCluster.BrokerNodeGroupInfoProperty | cdk.IResolvable;
    /**
     * `AWS::MSK::Cluster.ClusterName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html#cfn-msk-cluster-clustername
     * @external
     */
    clusterName: string;
    /**
     * `AWS::MSK::Cluster.KafkaVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html#cfn-msk-cluster-kafkaversion
     * @external
     */
    kafkaVersion: string;
    /**
     * `AWS::MSK::Cluster.NumberOfBrokerNodes`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html#cfn-msk-cluster-numberofbrokernodes
     * @external
     */
    numberOfBrokerNodes: number;
    /**
     * `AWS::MSK::Cluster.ClientAuthentication`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html#cfn-msk-cluster-clientauthentication
     * @external
     */
    clientAuthentication: CfnCluster.ClientAuthenticationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::MSK::Cluster.ConfigurationInfo`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html#cfn-msk-cluster-configurationinfo
     * @external
     */
    configurationInfo: CfnCluster.ConfigurationInfoProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::MSK::Cluster.EncryptionInfo`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html#cfn-msk-cluster-encryptioninfo
     * @external
     */
    encryptionInfo: CfnCluster.EncryptionInfoProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::MSK::Cluster.EnhancedMonitoring`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html#cfn-msk-cluster-enhancedmonitoring
     * @external
     */
    enhancedMonitoring: string | undefined;
    /**
     * `AWS::MSK::Cluster.LoggingInfo`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html#cfn-msk-cluster-logginginfo
     * @external
     */
    loggingInfo: CfnCluster.LoggingInfoProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::MSK::Cluster.OpenMonitoring`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html#cfn-msk-cluster-openmonitoring
     * @external
     */
    openMonitoring: CfnCluster.OpenMonitoringProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::MSK::Cluster.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html#cfn-msk-cluster-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::MSK::Cluster`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnClusterProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::MSK::Cluster`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html
 * @external
 * @cloudformationResource AWS::MSK::Cluster
 */
export declare namespace CfnCluster {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-brokerlogs.html
     * @external
     */
    interface BrokerLogsProperty {
        /**
         * `CfnCluster.BrokerLogsProperty.CloudWatchLogs`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-brokerlogs.html#cfn-msk-cluster-brokerlogs-cloudwatchlogs
         * @external
         */
        readonly cloudWatchLogs?: CfnCluster.CloudWatchLogsProperty | cdk.IResolvable;
        /**
         * `CfnCluster.BrokerLogsProperty.Firehose`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-brokerlogs.html#cfn-msk-cluster-brokerlogs-firehose
         * @external
         */
        readonly firehose?: CfnCluster.FirehoseProperty | cdk.IResolvable;
        /**
         * `CfnCluster.BrokerLogsProperty.S3`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-brokerlogs.html#cfn-msk-cluster-brokerlogs-s3
         * @external
         */
        readonly s3?: CfnCluster.S3Property | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MSK::Cluster`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html
 * @external
 * @cloudformationResource AWS::MSK::Cluster
 */
export declare namespace CfnCluster {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-brokernodegroupinfo.html
     * @external
     */
    interface BrokerNodeGroupInfoProperty {
        /**
         * `CfnCluster.BrokerNodeGroupInfoProperty.BrokerAZDistribution`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-brokernodegroupinfo.html#cfn-msk-cluster-brokernodegroupinfo-brokerazdistribution
         * @external
         */
        readonly brokerAzDistribution?: string;
        /**
         * `CfnCluster.BrokerNodeGroupInfoProperty.ClientSubnets`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-brokernodegroupinfo.html#cfn-msk-cluster-brokernodegroupinfo-clientsubnets
         * @external
         */
        readonly clientSubnets: string[];
        /**
         * `CfnCluster.BrokerNodeGroupInfoProperty.InstanceType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-brokernodegroupinfo.html#cfn-msk-cluster-brokernodegroupinfo-instancetype
         * @external
         */
        readonly instanceType: string;
        /**
         * `CfnCluster.BrokerNodeGroupInfoProperty.SecurityGroups`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-brokernodegroupinfo.html#cfn-msk-cluster-brokernodegroupinfo-securitygroups
         * @external
         */
        readonly securityGroups?: string[];
        /**
         * `CfnCluster.BrokerNodeGroupInfoProperty.StorageInfo`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-brokernodegroupinfo.html#cfn-msk-cluster-brokernodegroupinfo-storageinfo
         * @external
         */
        readonly storageInfo?: CfnCluster.StorageInfoProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MSK::Cluster`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html
 * @external
 * @cloudformationResource AWS::MSK::Cluster
 */
export declare namespace CfnCluster {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-clientauthentication.html
     * @external
     */
    interface ClientAuthenticationProperty {
        /**
         * `CfnCluster.ClientAuthenticationProperty.Sasl`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-clientauthentication.html#cfn-msk-cluster-clientauthentication-sasl
         * @external
         */
        readonly sasl?: CfnCluster.SaslProperty | cdk.IResolvable;
        /**
         * `CfnCluster.ClientAuthenticationProperty.Tls`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-clientauthentication.html#cfn-msk-cluster-clientauthentication-tls
         * @external
         */
        readonly tls?: CfnCluster.TlsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MSK::Cluster`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html
 * @external
 * @cloudformationResource AWS::MSK::Cluster
 */
export declare namespace CfnCluster {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-cloudwatchlogs.html
     * @external
     */
    interface CloudWatchLogsProperty {
        /**
         * `CfnCluster.CloudWatchLogsProperty.Enabled`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-cloudwatchlogs.html#cfn-msk-cluster-cloudwatchlogs-enabled
         * @external
         */
        readonly enabled: boolean | cdk.IResolvable;
        /**
         * `CfnCluster.CloudWatchLogsProperty.LogGroup`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-cloudwatchlogs.html#cfn-msk-cluster-cloudwatchlogs-loggroup
         * @external
         */
        readonly logGroup?: string;
    }
}
/**
 * A CloudFormation `AWS::MSK::Cluster`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html
 * @external
 * @cloudformationResource AWS::MSK::Cluster
 */
export declare namespace CfnCluster {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-configurationinfo.html
     * @external
     */
    interface ConfigurationInfoProperty {
        /**
         * `CfnCluster.ConfigurationInfoProperty.Arn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-configurationinfo.html#cfn-msk-cluster-configurationinfo-arn
         * @external
         */
        readonly arn: string;
        /**
         * `CfnCluster.ConfigurationInfoProperty.Revision`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-configurationinfo.html#cfn-msk-cluster-configurationinfo-revision
         * @external
         */
        readonly revision: number;
    }
}
/**
 * A CloudFormation `AWS::MSK::Cluster`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html
 * @external
 * @cloudformationResource AWS::MSK::Cluster
 */
export declare namespace CfnCluster {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-ebsstorageinfo.html
     * @external
     */
    interface EBSStorageInfoProperty {
        /**
         * `CfnCluster.EBSStorageInfoProperty.VolumeSize`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-ebsstorageinfo.html#cfn-msk-cluster-ebsstorageinfo-volumesize
         * @external
         */
        readonly volumeSize?: number;
    }
}
/**
 * A CloudFormation `AWS::MSK::Cluster`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html
 * @external
 * @cloudformationResource AWS::MSK::Cluster
 */
export declare namespace CfnCluster {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-encryptionatrest.html
     * @external
     */
    interface EncryptionAtRestProperty {
        /**
         * `CfnCluster.EncryptionAtRestProperty.DataVolumeKMSKeyId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-encryptionatrest.html#cfn-msk-cluster-encryptionatrest-datavolumekmskeyid
         * @external
         */
        readonly dataVolumeKmsKeyId: string;
    }
}
/**
 * A CloudFormation `AWS::MSK::Cluster`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html
 * @external
 * @cloudformationResource AWS::MSK::Cluster
 */
export declare namespace CfnCluster {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-encryptionintransit.html
     * @external
     */
    interface EncryptionInTransitProperty {
        /**
         * `CfnCluster.EncryptionInTransitProperty.ClientBroker`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-encryptionintransit.html#cfn-msk-cluster-encryptionintransit-clientbroker
         * @external
         */
        readonly clientBroker?: string;
        /**
         * `CfnCluster.EncryptionInTransitProperty.InCluster`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-encryptionintransit.html#cfn-msk-cluster-encryptionintransit-incluster
         * @external
         */
        readonly inCluster?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MSK::Cluster`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html
 * @external
 * @cloudformationResource AWS::MSK::Cluster
 */
export declare namespace CfnCluster {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-encryptioninfo.html
     * @external
     */
    interface EncryptionInfoProperty {
        /**
         * `CfnCluster.EncryptionInfoProperty.EncryptionAtRest`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-encryptioninfo.html#cfn-msk-cluster-encryptioninfo-encryptionatrest
         * @external
         */
        readonly encryptionAtRest?: CfnCluster.EncryptionAtRestProperty | cdk.IResolvable;
        /**
         * `CfnCluster.EncryptionInfoProperty.EncryptionInTransit`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-encryptioninfo.html#cfn-msk-cluster-encryptioninfo-encryptionintransit
         * @external
         */
        readonly encryptionInTransit?: CfnCluster.EncryptionInTransitProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MSK::Cluster`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html
 * @external
 * @cloudformationResource AWS::MSK::Cluster
 */
export declare namespace CfnCluster {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-firehose.html
     * @external
     */
    interface FirehoseProperty {
        /**
         * `CfnCluster.FirehoseProperty.DeliveryStream`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-firehose.html#cfn-msk-cluster-firehose-deliverystream
         * @external
         */
        readonly deliveryStream?: string;
        /**
         * `CfnCluster.FirehoseProperty.Enabled`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-firehose.html#cfn-msk-cluster-firehose-enabled
         * @external
         */
        readonly enabled: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MSK::Cluster`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html
 * @external
 * @cloudformationResource AWS::MSK::Cluster
 */
export declare namespace CfnCluster {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-jmxexporter.html
     * @external
     */
    interface JmxExporterProperty {
        /**
         * `CfnCluster.JmxExporterProperty.EnabledInBroker`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-jmxexporter.html#cfn-msk-cluster-jmxexporter-enabledinbroker
         * @external
         */
        readonly enabledInBroker: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MSK::Cluster`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html
 * @external
 * @cloudformationResource AWS::MSK::Cluster
 */
export declare namespace CfnCluster {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-logginginfo.html
     * @external
     */
    interface LoggingInfoProperty {
        /**
         * `CfnCluster.LoggingInfoProperty.BrokerLogs`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-logginginfo.html#cfn-msk-cluster-logginginfo-brokerlogs
         * @external
         */
        readonly brokerLogs: CfnCluster.BrokerLogsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MSK::Cluster`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html
 * @external
 * @cloudformationResource AWS::MSK::Cluster
 */
export declare namespace CfnCluster {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-nodeexporter.html
     * @external
     */
    interface NodeExporterProperty {
        /**
         * `CfnCluster.NodeExporterProperty.EnabledInBroker`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-nodeexporter.html#cfn-msk-cluster-nodeexporter-enabledinbroker
         * @external
         */
        readonly enabledInBroker: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MSK::Cluster`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html
 * @external
 * @cloudformationResource AWS::MSK::Cluster
 */
export declare namespace CfnCluster {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-openmonitoring.html
     * @external
     */
    interface OpenMonitoringProperty {
        /**
         * `CfnCluster.OpenMonitoringProperty.Prometheus`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-openmonitoring.html#cfn-msk-cluster-openmonitoring-prometheus
         * @external
         */
        readonly prometheus: CfnCluster.PrometheusProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MSK::Cluster`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html
 * @external
 * @cloudformationResource AWS::MSK::Cluster
 */
export declare namespace CfnCluster {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-prometheus.html
     * @external
     */
    interface PrometheusProperty {
        /**
         * `CfnCluster.PrometheusProperty.JmxExporter`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-prometheus.html#cfn-msk-cluster-prometheus-jmxexporter
         * @external
         */
        readonly jmxExporter?: CfnCluster.JmxExporterProperty | cdk.IResolvable;
        /**
         * `CfnCluster.PrometheusProperty.NodeExporter`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-prometheus.html#cfn-msk-cluster-prometheus-nodeexporter
         * @external
         */
        readonly nodeExporter?: CfnCluster.NodeExporterProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MSK::Cluster`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html
 * @external
 * @cloudformationResource AWS::MSK::Cluster
 */
export declare namespace CfnCluster {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-s3.html
     * @external
     */
    interface S3Property {
        /**
         * `CfnCluster.S3Property.Bucket`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-s3.html#cfn-msk-cluster-s3-bucket
         * @external
         */
        readonly bucket?: string;
        /**
         * `CfnCluster.S3Property.Enabled`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-s3.html#cfn-msk-cluster-s3-enabled
         * @external
         */
        readonly enabled: boolean | cdk.IResolvable;
        /**
         * `CfnCluster.S3Property.Prefix`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-s3.html#cfn-msk-cluster-s3-prefix
         * @external
         */
        readonly prefix?: string;
    }
}
/**
 * A CloudFormation `AWS::MSK::Cluster`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html
 * @external
 * @cloudformationResource AWS::MSK::Cluster
 */
export declare namespace CfnCluster {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-sasl.html
     * @external
     */
    interface SaslProperty {
        /**
         * `CfnCluster.SaslProperty.Scram`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-sasl.html#cfn-msk-cluster-sasl-scram
         * @external
         */
        readonly scram: CfnCluster.ScramProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MSK::Cluster`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html
 * @external
 * @cloudformationResource AWS::MSK::Cluster
 */
export declare namespace CfnCluster {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-scram.html
     * @external
     */
    interface ScramProperty {
        /**
         * `CfnCluster.ScramProperty.Enabled`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-scram.html#cfn-msk-cluster-scram-enabled
         * @external
         */
        readonly enabled: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MSK::Cluster`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html
 * @external
 * @cloudformationResource AWS::MSK::Cluster
 */
export declare namespace CfnCluster {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-storageinfo.html
     * @external
     */
    interface StorageInfoProperty {
        /**
         * `CfnCluster.StorageInfoProperty.EBSStorageInfo`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-storageinfo.html#cfn-msk-cluster-storageinfo-ebsstorageinfo
         * @external
         */
        readonly ebsStorageInfo?: CfnCluster.EBSStorageInfoProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MSK::Cluster`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html
 * @external
 * @cloudformationResource AWS::MSK::Cluster
 */
export declare namespace CfnCluster {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-tls.html
     * @external
     */
    interface TlsProperty {
        /**
         * `CfnCluster.TlsProperty.CertificateAuthorityArnList`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-tls.html#cfn-msk-cluster-tls-certificateauthorityarnlist
         * @external
         */
        readonly certificateAuthorityArnList?: string[];
    }
}
