import * as cdk from "../../core";
import * as cfn_parse from "../../core/lib/cfn-parse";
/**
 * Properties for defining a `AWS::MediaStore::Container`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediastore-container.html
 * @external
 */
export interface CfnContainerProps {
    /**
     * `AWS::MediaStore::Container.ContainerName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediastore-container.html#cfn-mediastore-container-containername
     * @external
     */
    readonly containerName: string;
    /**
     * `AWS::MediaStore::Container.AccessLoggingEnabled`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediastore-container.html#cfn-mediastore-container-accessloggingenabled
     * @external
     */
    readonly accessLoggingEnabled?: boolean | cdk.IResolvable;
    /**
     * `AWS::MediaStore::Container.CorsPolicy`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediastore-container.html#cfn-mediastore-container-corspolicy
     * @external
     */
    readonly corsPolicy?: Array<CfnContainer.CorsRuleProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::MediaStore::Container.LifecyclePolicy`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediastore-container.html#cfn-mediastore-container-lifecyclepolicy
     * @external
     */
    readonly lifecyclePolicy?: string;
    /**
     * `AWS::MediaStore::Container.MetricPolicy`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediastore-container.html#cfn-mediastore-container-metricpolicy
     * @external
     */
    readonly metricPolicy?: CfnContainer.MetricPolicyProperty | cdk.IResolvable;
    /**
     * `AWS::MediaStore::Container.Policy`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediastore-container.html#cfn-mediastore-container-policy
     * @external
     */
    readonly policy?: string;
    /**
     * `AWS::MediaStore::Container.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediastore-container.html#cfn-mediastore-container-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::MediaStore::Container`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediastore-container.html
 * @external
 * @cloudformationResource AWS::MediaStore::Container
 */
export declare class CfnContainer extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::MediaStore::Container";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnContainer;
    /**
     * @external
     * @cloudformationAttribute Endpoint
     */
    readonly attrEndpoint: string;
    /**
     * `AWS::MediaStore::Container.ContainerName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediastore-container.html#cfn-mediastore-container-containername
     * @external
     */
    containerName: string;
    /**
     * `AWS::MediaStore::Container.AccessLoggingEnabled`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediastore-container.html#cfn-mediastore-container-accessloggingenabled
     * @external
     */
    accessLoggingEnabled: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::MediaStore::Container.CorsPolicy`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediastore-container.html#cfn-mediastore-container-corspolicy
     * @external
     */
    corsPolicy: Array<CfnContainer.CorsRuleProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::MediaStore::Container.LifecyclePolicy`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediastore-container.html#cfn-mediastore-container-lifecyclepolicy
     * @external
     */
    lifecyclePolicy: string | undefined;
    /**
     * `AWS::MediaStore::Container.MetricPolicy`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediastore-container.html#cfn-mediastore-container-metricpolicy
     * @external
     */
    metricPolicy: CfnContainer.MetricPolicyProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::MediaStore::Container.Policy`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediastore-container.html#cfn-mediastore-container-policy
     * @external
     */
    policy: string | undefined;
    /**
     * `AWS::MediaStore::Container.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediastore-container.html#cfn-mediastore-container-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::MediaStore::Container`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnContainerProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::MediaStore::Container`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediastore-container.html
 * @external
 * @cloudformationResource AWS::MediaStore::Container
 */
export declare namespace CfnContainer {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediastore-container-corsrule.html
     * @external
     */
    interface CorsRuleProperty {
        /**
         * `CfnContainer.CorsRuleProperty.AllowedHeaders`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediastore-container-corsrule.html#cfn-mediastore-container-corsrule-allowedheaders
         * @external
         */
        readonly allowedHeaders?: string[];
        /**
         * `CfnContainer.CorsRuleProperty.AllowedMethods`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediastore-container-corsrule.html#cfn-mediastore-container-corsrule-allowedmethods
         * @external
         */
        readonly allowedMethods?: string[];
        /**
         * `CfnContainer.CorsRuleProperty.AllowedOrigins`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediastore-container-corsrule.html#cfn-mediastore-container-corsrule-allowedorigins
         * @external
         */
        readonly allowedOrigins?: string[];
        /**
         * `CfnContainer.CorsRuleProperty.ExposeHeaders`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediastore-container-corsrule.html#cfn-mediastore-container-corsrule-exposeheaders
         * @external
         */
        readonly exposeHeaders?: string[];
        /**
         * `CfnContainer.CorsRuleProperty.MaxAgeSeconds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediastore-container-corsrule.html#cfn-mediastore-container-corsrule-maxageseconds
         * @external
         */
        readonly maxAgeSeconds?: number;
    }
}
/**
 * A CloudFormation `AWS::MediaStore::Container`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediastore-container.html
 * @external
 * @cloudformationResource AWS::MediaStore::Container
 */
export declare namespace CfnContainer {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediastore-container-metricpolicy.html
     * @external
     */
    interface MetricPolicyProperty {
        /**
         * `CfnContainer.MetricPolicyProperty.ContainerLevelMetrics`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediastore-container-metricpolicy.html#cfn-mediastore-container-metricpolicy-containerlevelmetrics
         * @external
         */
        readonly containerLevelMetrics: string;
        /**
         * `CfnContainer.MetricPolicyProperty.MetricPolicyRules`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediastore-container-metricpolicy.html#cfn-mediastore-container-metricpolicy-metricpolicyrules
         * @external
         */
        readonly metricPolicyRules?: Array<CfnContainer.MetricPolicyRuleProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaStore::Container`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediastore-container.html
 * @external
 * @cloudformationResource AWS::MediaStore::Container
 */
export declare namespace CfnContainer {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediastore-container-metricpolicyrule.html
     * @external
     */
    interface MetricPolicyRuleProperty {
        /**
         * `CfnContainer.MetricPolicyRuleProperty.ObjectGroup`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediastore-container-metricpolicyrule.html#cfn-mediastore-container-metricpolicyrule-objectgroup
         * @external
         */
        readonly objectGroup: string;
        /**
         * `CfnContainer.MetricPolicyRuleProperty.ObjectGroupName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediastore-container-metricpolicyrule.html#cfn-mediastore-container-metricpolicyrule-objectgroupname
         * @external
         */
        readonly objectGroupName: string;
    }
}
