import * as iam from "../../aws-iam";
import { Resource } from "../../core";
import { Construct } from 'constructs';
import { ILogGroup, SubscriptionFilterOptions } from './log-group';
import { Construct as CoreConstruct } from "../../core";
/**
 * (experimental) Interface for classes that can be the destination of a log Subscription.
 *
 * @experimental
 */
export interface ILogSubscriptionDestination {
    /**
     * (experimental) Return the properties required to send subscription events to this destination.
     *
     * If necessary, the destination can use the properties of the SubscriptionFilter
     * object itself to configure its permissions to allow the subscription to write
     * to it.
     *
     * The destination may reconfigure its own permissions in response to this
     * function call.
     *
     * @experimental
     */
    bind(scope: CoreConstruct, sourceLogGroup: ILogGroup): LogSubscriptionDestinationConfig;
}
/**
 * (experimental) Properties returned by a Subscription destination.
 *
 * @experimental
 */
export interface LogSubscriptionDestinationConfig {
    /**
     * (experimental) The ARN of the subscription's destination.
     *
     * @experimental
     */
    readonly arn: string;
    /**
     * (experimental) The role to assume to write log events to the destination.
     *
     * @default No role assumed
     * @experimental
     */
    readonly role?: iam.IRole;
}
/**
 * (experimental) Properties for a SubscriptionFilter.
 *
 * @experimental
 */
export interface SubscriptionFilterProps extends SubscriptionFilterOptions {
    /**
     * (experimental) The log group to create the subscription on.
     *
     * @experimental
     */
    readonly logGroup: ILogGroup;
}
/**
 * (experimental) A new Subscription on a CloudWatch log group.
 *
 * @experimental
 */
export declare class SubscriptionFilter extends Resource {
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: SubscriptionFilterProps);
}
