import * as lambda from "../../aws-lambda";
import * as logs from "../../aws-logs";
import { Construct } from "../../core";
/**
 * (experimental) Use a Lamda Function as the destination for a log subscription.
 *
 * @experimental
 */
export declare class LambdaDestination implements logs.ILogSubscriptionDestination {
    private readonly fn;
    /**
     * @experimental
     */
    constructor(fn: lambda.IFunction);
    /**
     * (experimental) Return the properties required to send subscription events to this destination.
     *
     * If necessary, the destination can use the properties of the SubscriptionFilter
     * object itself to configure its permissions to allow the subscription to write
     * to it.
     *
     * The destination may reconfigure its own permissions in response to this
     * function call.
     *
     * @experimental
     */
    bind(scope: Construct, logGroup: logs.ILogGroup): logs.LogSubscriptionDestinationConfig;
}
