import * as cloudwatch from "../../aws-cloudwatch";
declare module "./function-base" {
    /**
     * @experimental
     */
    interface IFunction {
        /**
         * (experimental) Return the given named metric for this Lambda Return the given named metric for this Function.
         *
         * @experimental
         */
        metric(metricName: string, props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * (experimental) Metric for the number of throttled invocations of this Lambda How often this Lambda is throttled.
         *
         * Sum over 5 minutes
         *
         * @default sum over 5 minutes
         * @experimental
         */
        metricThrottles(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * (experimental) Metric for the number of invocations of this Lambda How often this Lambda is invoked.
         *
         * Sum over 5 minutes
         *
         * @default sum over 5 minutes
         * @experimental
         */
        metricInvocations(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * (experimental) How many invocations of this Lambda fail.
         *
         * Sum over 5 minutes
         *
         * @experimental
         */
        metricErrors(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * (experimental) Metric for the Duration of this Lambda How long execution of this Lambda takes.
         *
         * Average over 5 minutes
         *
         * @default average over 5 minutes
         * @experimental
         */
        metricDuration(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    }
    /**
     * @experimental
     */
    interface FunctionBase {
        /**
         * (experimental) Return the given named metric for this Function.
         *
         * @experimental
         */
        metric(metricName: string, props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * (experimental) How often this Lambda is throttled.
         *
         * Sum over 5 minutes
         *
         * @experimental
         */
        metricThrottles(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * (experimental) How often this Lambda is invoked.
         *
         * Sum over 5 minutes
         *
         * @experimental
         */
        metricInvocations(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * (experimental) How many invocations of this Lambda fail.
         *
         * Sum over 5 minutes
         *
         * @experimental
         */
        metricErrors(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * (experimental) How long execution of this Lambda takes.
         *
         * Average over 5 minutes
         *
         * @experimental
         */
        metricDuration(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    }
}
