"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FileSystem = void 0;
const iam = require("../../aws-iam"); // Automatically re-written from '@aws-cdk/aws-iam'
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
/**
 * (experimental) Represents the filesystem for the Lambda function.
 *
 * @experimental
 */
class FileSystem {
    /**
     * @param config the FileSystem configurations for the Lambda function.
     * @experimental
     */
    constructor(config) {
        this.config = config;
    }
    /**
     * (experimental) mount the filesystem from Amazon EFS.
     *
     * @param ap the Amazon EFS access point.
     * @param mountPath the target path in the lambda runtime environment.
     * @experimental
     */
    static fromEfsAccessPoint(ap, mountPath) {
        return new FileSystem({
            localMountPath: mountPath,
            arn: ap.accessPointArn,
            dependency: [ap.fileSystem.mountTargetsAvailable],
            connections: ap.fileSystem.connections,
            policies: [
                new iam.PolicyStatement({
                    actions: ['elasticfilesystem:ClientMount'],
                    resources: ['*'],
                    conditions: {
                        StringEquals: {
                            'elasticfilesystem:AccessPointArn': ap.accessPointArn,
                        },
                    },
                }),
                new iam.PolicyStatement({
                    actions: ['elasticfilesystem:ClientWrite'],
                    resources: [core_1.Stack.of(ap).formatArn({
                            service: 'elasticfilesystem',
                            resource: 'file-system',
                            resourceName: ap.fileSystem.fileSystemId,
                        })],
                }),
            ],
        });
    }
}
exports.FileSystem = FileSystem;
//# sourceMappingURL=data:application/json;base64,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