import { Duration, Resource } from "../../core";
import { Construct } from 'constructs';
import { IDestination } from './destination';
import { IFunction } from './function-base';
/**
 * (experimental) Options to add an EventInvokeConfig to a function.
 *
 * @experimental
 */
export interface EventInvokeConfigOptions {
    /**
     * (experimental) The destination for failed invocations.
     *
     * @default - no destination
     * @experimental
     */
    readonly onFailure?: IDestination;
    /**
     * (experimental) The destination for successful invocations.
     *
     * @default - no destination
     * @experimental
     */
    readonly onSuccess?: IDestination;
    /**
     * (experimental) The maximum age of a request that Lambda sends to a function for processing.
     *
     * Minimum: 60 seconds
     * Maximum: 6 hours
     *
     * @default Duration.hours(6)
     * @experimental
     */
    readonly maxEventAge?: Duration;
    /**
     * (experimental) The maximum number of times to retry when the function returns an error.
     *
     * Minimum: 0
     * Maximum: 2
     *
     * @default 2
     * @experimental
     */
    readonly retryAttempts?: number;
}
/**
 * (experimental) Properties for an EventInvokeConfig.
 *
 * @experimental
 */
export interface EventInvokeConfigProps extends EventInvokeConfigOptions {
    /**
     * (experimental) The Lambda function.
     *
     * @experimental
     */
    readonly function: IFunction;
    /**
     * (experimental) The qualifier.
     *
     * @default - latest version
     * @experimental
     */
    readonly qualifier?: string;
}
/**
 * (experimental) Configure options for asynchronous invocation on a version or an alias.
 *
 * By default, Lambda retries an asynchronous invocation twice if the function
 * returns an error. It retains events in a queue for up to six hours. When an
 * event fails all processing attempts or stays in the asynchronous invocation
 * queue for too long, Lambda discards it.
 *
 * @experimental
 */
export declare class EventInvokeConfig extends Resource {
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: EventInvokeConfigProps);
}
