import * as cloudwatch from "../../aws-cloudwatch";
import * as iam from "../../aws-iam";
import { Construct } from 'constructs';
import { EventInvokeConfigOptions } from './event-invoke-config';
import { IFunction, QualifiedFunctionBase } from './function-base';
import { IVersion } from './lambda-version';
import { AutoScalingOptions, IScalableFunctionAttribute } from './scalable-attribute-api';
/**
 * @experimental
 */
export interface IAlias extends IFunction {
    /**
     * (experimental) Name of this alias.
     *
     * @experimental
     * @attribute true
     */
    readonly aliasName: string;
    /**
     * (experimental) The underlying Lambda function version.
     *
     * @experimental
     */
    readonly version: IVersion;
}
/**
 * (experimental) Options for `lambda.Alias`.
 *
 * @experimental
 */
export interface AliasOptions extends EventInvokeConfigOptions {
    /**
     * (experimental) Description for the alias.
     *
     * @default No description
     * @experimental
     */
    readonly description?: string;
    /**
     * (experimental) Additional versions with individual weights this alias points to.
     *
     * Individual additional version weights specified here should add up to
     * (less than) one. All remaining weight is routed to the default
     * version.
     *
     * For example, the config is
     *
     *     version: "1"
     *     additionalVersions: [{ version: "2", weight: 0.05 }]
     *
     * Then 5% of traffic will be routed to function version 2, while
     * the remaining 95% of traffic will be routed to function version 1.
     *
     * @default No additional versions
     * @experimental
     */
    readonly additionalVersions?: VersionWeight[];
    /**
     * (experimental) Specifies a provisioned concurrency configuration for a function's alias.
     *
     * @default No provisioned concurrency
     * @experimental
     */
    readonly provisionedConcurrentExecutions?: number;
}
/**
 * (experimental) Properties for a new Lambda alias.
 *
 * @experimental
 */
export interface AliasProps extends AliasOptions {
    /**
     * (experimental) Name of this alias.
     *
     * @experimental
     */
    readonly aliasName: string;
    /**
     * (experimental) Function version this alias refers to.
     *
     * Use lambda.addVersion() to obtain a new lambda version to refer to.
     *
     * @experimental
     */
    readonly version: IVersion;
}
/**
 * @experimental
 */
export interface AliasAttributes {
    /**
     * @experimental
     */
    readonly aliasName: string;
    /**
     * @experimental
     */
    readonly aliasVersion: IVersion;
}
/**
 * (experimental) A new alias to a particular version of a Lambda function.
 *
 * @experimental
 */
export declare class Alias extends QualifiedFunctionBase implements IAlias {
    /**
     * @experimental
     */
    static fromAliasAttributes(scope: Construct, id: string, attrs: AliasAttributes): IAlias;
    /**
     * (experimental) Name of this alias.
     *
     * @experimental
     * @attribute true
     */
    readonly aliasName: string;
    /**
     * (experimental) ARN of this alias.
     *
     * Used to be able to use Alias in place of a regular Lambda. Lambda accepts
     * ARNs everywhere it accepts function names.
     *
     * @experimental
     */
    readonly functionName: string;
    /**
     * @experimental
     */
    readonly lambda: IFunction;
    /**
     * (experimental) The underlying Lambda function version.
     *
     * @experimental
     */
    readonly version: IVersion;
    /**
     * (experimental) ARN of this alias.
     *
     * Used to be able to use Alias in place of a regular Lambda. Lambda accepts
     * ARNs everywhere it accepts function names.
     *
     * @experimental
     */
    readonly functionArn: string;
    /**
     * (experimental) The qualifier of the version or alias of this function.
     *
     * A qualifier is the identifier that's appended to a version or alias ARN.
     *
     * @experimental
     */
    protected readonly qualifier: string;
    /**
     * (experimental) Whether the addPermission() call adds any permissions.
     *
     * True for new Lambdas, false for version $LATEST and imported Lambdas
     * from different accounts.
     *
     * @experimental
     */
    protected readonly canCreatePermissions: boolean;
    private scalableAlias?;
    private readonly scalingRole;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: AliasProps);
    /**
     * (experimental) The principal this Lambda Function is running as.
     *
     * @experimental
     */
    get grantPrincipal(): iam.IPrincipal;
    /**
     * (experimental) The IAM role associated with this function.
     *
     * Undefined if the function was imported without a role.
     *
     * @experimental
     */
    get role(): iam.IRole | undefined;
    /**
     * (experimental) Return the given named metric for this Function.
     *
     * @experimental
     */
    metric(metricName: string, props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) Configure provisioned concurrency autoscaling on a function alias.
     *
     * Returns a scalable attribute that can call
     * `scaleOnUtilization()` and `scaleOnSchedule()`.
     *
     * @param options Autoscaling options.
     * @experimental
     */
    addAutoScaling(options: AutoScalingOptions): IScalableFunctionAttribute;
    /**
     * Calculate the routingConfig parameter from the input props
     */
    private determineRoutingConfig;
    /**
     * Validate that the additional version weights make sense
     *
     * We validate that they are positive and add up to something <= 1.
     */
    private validateAdditionalWeights;
    /**
     * Validate that the provisionedConcurrentExecutions makes sense
     *
     * Member must have value greater than or equal to 1
     */
    private determineProvisionedConcurrency;
}
/**
 * (experimental) A version/weight pair for routing traffic to Lambda functions.
 *
 * @experimental
 */
export interface VersionWeight {
    /**
     * (experimental) The version to route traffic to.
     *
     * @experimental
     */
    readonly version: IVersion;
    /**
     * (experimental) How much weight to assign to this version (0..1).
     *
     * @experimental
     */
    readonly weight: number;
}
