"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PythonLayerVersion = void 0;
const path = require("path");
const lambda = require("../../aws-lambda"); // Automatically re-written from '@aws-cdk/aws-lambda'
const bundling_1 = require("./bundling");
/**
 * (experimental) A lambda layer version.
 *
 * @experimental
 */
class PythonLayerVersion extends lambda.LayerVersion {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _a, _b;
        const compatibleRuntimes = (_a = props.compatibleRuntimes) !== null && _a !== void 0 ? _a : [lambda.Runtime.PYTHON_3_7];
        // Ensure that all compatible runtimes are python
        for (const runtime of compatibleRuntimes) {
            if (runtime && runtime.family !== lambda.RuntimeFamily.PYTHON) {
                throw new Error('Only `PYTHON` runtimes are supported.');
            }
        }
        // Entry and defaults
        const entry = path.resolve(props.entry);
        // Pick the first compatibleRuntime to use for bundling or PYTHON_3_7
        const runtime = (_b = compatibleRuntimes[0]) !== null && _b !== void 0 ? _b : lambda.Runtime.PYTHON_3_7;
        super(scope, id, {
            ...props,
            compatibleRuntimes,
            code: bundling_1.bundle({
                entry,
                runtime,
                outputPathSuffix: 'python',
            }),
        });
    }
}
exports.PythonLayerVersion = PythonLayerVersion;
//# sourceMappingURL=data:application/json;base64,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