import * as lambda from "../../aws-lambda";
import { Duration } from "../../core";
/**
 * (experimental) The set of properties for event sources that follow the streaming model, such as, Dynamo and Kinesis.
 *
 * @experimental
 */
export interface StreamEventSourceProps {
    /**
     * (experimental) The largest number of records that AWS Lambda will retrieve from your event source at the time of invoking your function.
     *
     * Your function receives an
     * event with all the retrieved records.
     *
     * Valid Range:
     * * Minimum value of 1
     * * Maximum value of:
     *    * 1000 for {@link DynamoEventSource}
     *    * 10000 for {@link KinesisEventSource}
     *
     * @default 100
     * @experimental
     */
    readonly batchSize?: number;
    /**
     * (experimental) If the function returns an error, split the batch in two and retry.
     *
     * @default false
     * @experimental
     */
    readonly bisectBatchOnError?: boolean;
    /**
     * (experimental) An Amazon SQS queue or Amazon SNS topic destination for discarded records.
     *
     * @default discarded records are ignored
     * @experimental
     */
    readonly onFailure?: lambda.IEventSourceDlq;
    /**
     * (experimental) The maximum age of a record that Lambda sends to a function for processing.
     *
     * Valid Range:
     * * Minimum value of 60 seconds
     * * Maximum value of 7 days
     *
     * @default Duration.days(7)
     * @experimental
     */
    readonly maxRecordAge?: Duration;
    /**
     * (experimental) Maximum number of retry attempts Valid Range: * Minimum value of 0 * Maximum value of 10000.
     *
     * @default 10000
     * @experimental
     */
    readonly retryAttempts?: number;
    /**
     * (experimental) The number of batches to process from each shard concurrently.
     *
     * Valid Range:
     * * Minimum value of 1
     * * Maximum value of 10
     *
     * @default 1
     * @experimental
     */
    readonly parallelizationFactor?: number;
    /**
     * (experimental) Where to begin consuming the stream.
     *
     * @experimental
     */
    readonly startingPosition: lambda.StartingPosition;
    /**
     * (experimental) The maximum amount of time to gather records before invoking the function.
     *
     * Maximum of Duration.minutes(5)
     *
     * @default Duration.seconds(0)
     * @experimental
     */
    readonly maxBatchingWindow?: Duration;
    /**
     * (experimental) If the stream event source mapping should be enabled.
     *
     * @default true
     * @experimental
     */
    readonly enabled?: boolean;
}
/**
 * (experimental) Use an stream as an event source for AWS Lambda.
 *
 * @experimental
 */
export declare abstract class StreamEventSource implements lambda.IEventSource {
    protected readonly props: StreamEventSourceProps;
    /**
     * @experimental
     */
    protected constructor(props: StreamEventSourceProps);
    /**
     * (experimental) Called by `lambda.addEventSource` to allow the event source to bind to this function.
     *
     * @experimental
     */
    abstract bind(_target: lambda.IFunction): void;
    /**
     * @experimental
     */
    protected enrichMappingOptions(options: lambda.EventSourceMappingOptions): lambda.EventSourceMappingOptions;
}
