"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SnsEventSource = void 0;
const subs = require("../../aws-sns-subscriptions"); // Automatically re-written from '@aws-cdk/aws-sns-subscriptions'
/**
 * (experimental) Use an Amazon SNS topic as an event source for AWS Lambda.
 *
 * @experimental
 */
class SnsEventSource {
    /**
     * @experimental
     */
    constructor(topic, props) {
        this.topic = topic;
        this.props = props;
    }
    /**
     * (experimental) Called by `lambda.addEventSource` to allow the event source to bind to this function.
     *
     * @experimental
     */
    bind(target) {
        this.topic.addSubscription(new subs.LambdaSubscription(target, this.props));
    }
}
exports.SnsEventSource = SnsEventSource;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic25zLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsic25zLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUVBLG9EQUFvRCxDQUFDLGlFQUFpRTs7Ozs7O0FBU3RILE1BQWEsY0FBYzs7OztJQUV2QixZQUFxQixLQUFpQixFQUFFLEtBQTJCO1FBQTlDLFVBQUssR0FBTCxLQUFLLENBQVk7UUFDbEMsSUFBSSxDQUFDLEtBQUssR0FBRyxLQUFLLENBQUM7SUFDdkIsQ0FBQzs7Ozs7O0lBQ00sSUFBSSxDQUFDLE1BQXdCO1FBQ2hDLElBQUksQ0FBQyxLQUFLLENBQUMsZUFBZSxDQUFDLElBQUksSUFBSSxDQUFDLGtCQUFrQixDQUFDLE1BQU0sRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQztJQUNoRixDQUFDO0NBQ0o7QUFSRCx3Q0FRQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGxhbWJkYSBmcm9tIFwiLi4vLi4vYXdzLWxhbWJkYVwiOyAvLyBBdXRvbWF0aWNhbGx5IHJlLXdyaXR0ZW4gZnJvbSAnQGF3cy1jZGsvYXdzLWxhbWJkYSdcbmltcG9ydCAqIGFzIHNucyBmcm9tIFwiLi4vLi4vYXdzLXNuc1wiOyAvLyBBdXRvbWF0aWNhbGx5IHJlLXdyaXR0ZW4gZnJvbSAnQGF3cy1jZGsvYXdzLXNucydcbmltcG9ydCAqIGFzIHN1YnMgZnJvbSBcIi4uLy4uL2F3cy1zbnMtc3Vic2NyaXB0aW9uc1wiOyAvLyBBdXRvbWF0aWNhbGx5IHJlLXdyaXR0ZW4gZnJvbSAnQGF3cy1jZGsvYXdzLXNucy1zdWJzY3JpcHRpb25zJ1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBpbnRlcmZhY2UgU25zRXZlbnRTb3VyY2VQcm9wcyBleHRlbmRzIHN1YnMuTGFtYmRhU3Vic2NyaXB0aW9uUHJvcHMge1xufVxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgY2xhc3MgU25zRXZlbnRTb3VyY2UgaW1wbGVtZW50cyBsYW1iZGEuSUV2ZW50U291cmNlIHtcbiAgICBwcml2YXRlIHJlYWRvbmx5IHByb3BzPzogU25zRXZlbnRTb3VyY2VQcm9wcztcbiAgICBjb25zdHJ1Y3RvcihyZWFkb25seSB0b3BpYzogc25zLklUb3BpYywgcHJvcHM/OiBTbnNFdmVudFNvdXJjZVByb3BzKSB7XG4gICAgICAgIHRoaXMucHJvcHMgPSBwcm9wcztcbiAgICB9XG4gICAgcHVibGljIGJpbmQodGFyZ2V0OiBsYW1iZGEuSUZ1bmN0aW9uKSB7XG4gICAgICAgIHRoaXMudG9waWMuYWRkU3Vic2NyaXB0aW9uKG5ldyBzdWJzLkxhbWJkYVN1YnNjcmlwdGlvbih0YXJnZXQsIHRoaXMucHJvcHMpKTtcbiAgICB9XG59XG4iXX0=