"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.KinesisEventSource = void 0;
const cdk = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const stream_1 = require("./stream");
/**
 * (experimental) Use an Amazon Kinesis stream as an event source for AWS Lambda.
 *
 * @experimental
 */
class KinesisEventSource extends stream_1.StreamEventSource {
    /**
     * @experimental
     */
    constructor(stream, props) {
        super(props);
        this.stream = stream;
        this._eventSourceMappingId = undefined;
        this.props.batchSize !== undefined && cdk.withResolved(this.props.batchSize, batchSize => {
            if (batchSize < 1 || batchSize > 10000) {
                throw new Error(`Maximum batch size must be between 1 and 10000 inclusive (given ${this.props.batchSize})`);
            }
        });
    }
    /**
     * (experimental) Called by `lambda.addEventSource` to allow the event source to bind to this function.
     *
     * @experimental
     */
    bind(target) {
        const eventSourceMapping = target.addEventSourceMapping(`KinesisEventSource:${cdk.Names.nodeUniqueId(this.stream.node)}`, this.enrichMappingOptions({ eventSourceArn: this.stream.streamArn }));
        this._eventSourceMappingId = eventSourceMapping.eventSourceMappingId;
        this.stream.grantRead(target);
        // The `grantRead` API provides all the permissions recommended by the Kinesis team for reading a stream.
        // `DescribeStream` permissions are not required to read a stream as it's covered by the `DescribeStreamSummary`
        // and `SubscribeToShard` APIs.
        // The Lambda::EventSourceMapping resource validates against the `DescribeStream` permission. So we add it explicitly.
        // FIXME This permission can be removed when the event source mapping resource drops it from validation.
        this.stream.grant(target, 'kinesis:DescribeStream');
    }
    /**
     * (experimental) The identifier for this EventSourceMapping.
     *
     * @experimental
     */
    get eventSourceMappingId() {
        if (!this._eventSourceMappingId) {
            throw new Error('KinesisEventSource is not yet bound to an event source mapping');
        }
        return this._eventSourceMappingId;
    }
}
exports.KinesisEventSource = KinesisEventSource;
//# sourceMappingURL=data:application/json;base64,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