import * as kinesis from "../../aws-kinesis";
import * as lambda from "../../aws-lambda";
import { StreamEventSource, StreamEventSourceProps } from './stream';
/**
 * @experimental
 */
export interface KinesisEventSourceProps extends StreamEventSourceProps {
}
/**
 * (experimental) Use an Amazon Kinesis stream as an event source for AWS Lambda.
 *
 * @experimental
 */
export declare class KinesisEventSource extends StreamEventSource {
    readonly stream: kinesis.IStream;
    private _eventSourceMappingId?;
    /**
     * @experimental
     */
    constructor(stream: kinesis.IStream, props: KinesisEventSourceProps);
    /**
     * (experimental) Called by `lambda.addEventSource` to allow the event source to bind to this function.
     *
     * @experimental
     */
    bind(target: lambda.IFunction): void;
    /**
     * (experimental) The identifier for this EventSourceMapping.
     *
     * @experimental
     */
    get eventSourceMappingId(): string;
}
