"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaDestination = void 0;
const events = require("../../aws-events"); // Automatically re-written from '@aws-cdk/aws-events'
const targets = require("../../aws-events-targets"); // Automatically re-written from '@aws-cdk/aws-events-targets'
const event_bridge_1 = require("./event-bridge");
/**
 * (experimental) Use a Lambda function as a Lambda destination.
 *
 * @experimental
 */
class LambdaDestination {
    /**
     * @experimental
     */
    constructor(fn, options = {}) {
        this.fn = fn;
        this.options = options;
    }
    /**
     * (experimental) Returns a destination configuration.
     *
     * @experimental
     */
    bind(scope, fn, options) {
        // Normal Lambda destination (full invocation record)
        if (!this.options.responseOnly) {
            // deduplicated automatically
            this.fn.grantInvoke(fn);
            return {
                destination: this.fn.functionArn,
            };
        }
        // Otherwise add rule to extract the response payload and use EventBridge
        // as destination
        if (!options) { // `options` added to bind() as optionnal to avoid breaking change
            throw new Error('Options must be defined when using `responseOnly`.');
        }
        // Match invocation result of the source function (`fn`) and use it
        // to trigger the destination function (`this.fn`).
        new events.Rule(scope, options.type, {
            eventPattern: {
                detailType: [`Lambda Function Invocation Result - ${options.type}`],
                resources: [`${fn.functionArn}:$LATEST`],
                source: ['lambda'],
            },
            targets: [
                new targets.LambdaFunction(this.fn, {
                    event: events.RuleTargetInput.fromEventPath('$.detail.responsePayload'),
                }),
            ],
        });
        const destination = new event_bridge_1.EventBridgeDestination(); // Use default event bus here
        return destination.bind(scope, fn);
    }
}
exports.LambdaDestination = LambdaDestination;
//# sourceMappingURL=data:application/json;base64,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