import * as cdk from "../../core";
import * as cfn_parse from "../../core/lib/cfn-parse";
/**
 * Properties for defining a `AWS::KinesisAnalytics::Application`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-application.html
 * @external
 */
export interface CfnApplicationProps {
    /**
     * `AWS::KinesisAnalytics::Application.Inputs`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-application.html#cfn-kinesisanalytics-application-inputs
     * @external
     */
    readonly inputs: Array<CfnApplication.InputProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::KinesisAnalytics::Application.ApplicationCode`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-application.html#cfn-kinesisanalytics-application-applicationcode
     * @external
     */
    readonly applicationCode?: string;
    /**
     * `AWS::KinesisAnalytics::Application.ApplicationDescription`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-application.html#cfn-kinesisanalytics-application-applicationdescription
     * @external
     */
    readonly applicationDescription?: string;
    /**
     * `AWS::KinesisAnalytics::Application.ApplicationName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-application.html#cfn-kinesisanalytics-application-applicationname
     * @external
     */
    readonly applicationName?: string;
}
/**
 * A CloudFormation `AWS::KinesisAnalytics::Application`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-application.html
 * @external
 * @cloudformationResource AWS::KinesisAnalytics::Application
 */
export declare class CfnApplication extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::KinesisAnalytics::Application";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnApplication;
    /**
     * `AWS::KinesisAnalytics::Application.Inputs`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-application.html#cfn-kinesisanalytics-application-inputs
     * @external
     */
    inputs: Array<CfnApplication.InputProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::KinesisAnalytics::Application.ApplicationCode`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-application.html#cfn-kinesisanalytics-application-applicationcode
     * @external
     */
    applicationCode: string | undefined;
    /**
     * `AWS::KinesisAnalytics::Application.ApplicationDescription`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-application.html#cfn-kinesisanalytics-application-applicationdescription
     * @external
     */
    applicationDescription: string | undefined;
    /**
     * `AWS::KinesisAnalytics::Application.ApplicationName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-application.html#cfn-kinesisanalytics-application-applicationname
     * @external
     */
    applicationName: string | undefined;
    /**
     * Create a new `AWS::KinesisAnalytics::Application`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnApplicationProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::KinesisAnalytics::Application`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-application.html
 * @external
 * @cloudformationResource AWS::KinesisAnalytics::Application
 */
export declare namespace CfnApplication {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-csvmappingparameters.html
     * @external
     */
    interface CSVMappingParametersProperty {
        /**
         * `CfnApplication.CSVMappingParametersProperty.RecordColumnDelimiter`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-csvmappingparameters.html#cfn-kinesisanalytics-application-csvmappingparameters-recordcolumndelimiter
         * @external
         */
        readonly recordColumnDelimiter: string;
        /**
         * `CfnApplication.CSVMappingParametersProperty.RecordRowDelimiter`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-csvmappingparameters.html#cfn-kinesisanalytics-application-csvmappingparameters-recordrowdelimiter
         * @external
         */
        readonly recordRowDelimiter: string;
    }
}
/**
 * A CloudFormation `AWS::KinesisAnalytics::Application`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-application.html
 * @external
 * @cloudformationResource AWS::KinesisAnalytics::Application
 */
export declare namespace CfnApplication {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-input.html
     * @external
     */
    interface InputProperty {
        /**
         * `CfnApplication.InputProperty.InputParallelism`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-input.html#cfn-kinesisanalytics-application-input-inputparallelism
         * @external
         */
        readonly inputParallelism?: CfnApplication.InputParallelismProperty | cdk.IResolvable;
        /**
         * `CfnApplication.InputProperty.InputProcessingConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-input.html#cfn-kinesisanalytics-application-input-inputprocessingconfiguration
         * @external
         */
        readonly inputProcessingConfiguration?: CfnApplication.InputProcessingConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnApplication.InputProperty.InputSchema`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-input.html#cfn-kinesisanalytics-application-input-inputschema
         * @external
         */
        readonly inputSchema: CfnApplication.InputSchemaProperty | cdk.IResolvable;
        /**
         * `CfnApplication.InputProperty.KinesisFirehoseInput`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-input.html#cfn-kinesisanalytics-application-input-kinesisfirehoseinput
         * @external
         */
        readonly kinesisFirehoseInput?: CfnApplication.KinesisFirehoseInputProperty | cdk.IResolvable;
        /**
         * `CfnApplication.InputProperty.KinesisStreamsInput`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-input.html#cfn-kinesisanalytics-application-input-kinesisstreamsinput
         * @external
         */
        readonly kinesisStreamsInput?: CfnApplication.KinesisStreamsInputProperty | cdk.IResolvable;
        /**
         * `CfnApplication.InputProperty.NamePrefix`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-input.html#cfn-kinesisanalytics-application-input-nameprefix
         * @external
         */
        readonly namePrefix: string;
    }
}
/**
 * A CloudFormation `AWS::KinesisAnalytics::Application`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-application.html
 * @external
 * @cloudformationResource AWS::KinesisAnalytics::Application
 */
export declare namespace CfnApplication {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputlambdaprocessor.html
     * @external
     */
    interface InputLambdaProcessorProperty {
        /**
         * `CfnApplication.InputLambdaProcessorProperty.ResourceARN`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputlambdaprocessor.html#cfn-kinesisanalytics-application-inputlambdaprocessor-resourcearn
         * @external
         */
        readonly resourceArn: string;
        /**
         * `CfnApplication.InputLambdaProcessorProperty.RoleARN`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputlambdaprocessor.html#cfn-kinesisanalytics-application-inputlambdaprocessor-rolearn
         * @external
         */
        readonly roleArn: string;
    }
}
/**
 * A CloudFormation `AWS::KinesisAnalytics::Application`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-application.html
 * @external
 * @cloudformationResource AWS::KinesisAnalytics::Application
 */
export declare namespace CfnApplication {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputparallelism.html
     * @external
     */
    interface InputParallelismProperty {
        /**
         * `CfnApplication.InputParallelismProperty.Count`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputparallelism.html#cfn-kinesisanalytics-application-inputparallelism-count
         * @external
         */
        readonly count?: number;
    }
}
/**
 * A CloudFormation `AWS::KinesisAnalytics::Application`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-application.html
 * @external
 * @cloudformationResource AWS::KinesisAnalytics::Application
 */
export declare namespace CfnApplication {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputprocessingconfiguration.html
     * @external
     */
    interface InputProcessingConfigurationProperty {
        /**
         * `CfnApplication.InputProcessingConfigurationProperty.InputLambdaProcessor`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputprocessingconfiguration.html#cfn-kinesisanalytics-application-inputprocessingconfiguration-inputlambdaprocessor
         * @external
         */
        readonly inputLambdaProcessor?: CfnApplication.InputLambdaProcessorProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::KinesisAnalytics::Application`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-application.html
 * @external
 * @cloudformationResource AWS::KinesisAnalytics::Application
 */
export declare namespace CfnApplication {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputschema.html
     * @external
     */
    interface InputSchemaProperty {
        /**
         * `CfnApplication.InputSchemaProperty.RecordColumns`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputschema.html#cfn-kinesisanalytics-application-inputschema-recordcolumns
         * @external
         */
        readonly recordColumns: Array<CfnApplication.RecordColumnProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnApplication.InputSchemaProperty.RecordEncoding`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputschema.html#cfn-kinesisanalytics-application-inputschema-recordencoding
         * @external
         */
        readonly recordEncoding?: string;
        /**
         * `CfnApplication.InputSchemaProperty.RecordFormat`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputschema.html#cfn-kinesisanalytics-application-inputschema-recordformat
         * @external
         */
        readonly recordFormat: CfnApplication.RecordFormatProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::KinesisAnalytics::Application`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-application.html
 * @external
 * @cloudformationResource AWS::KinesisAnalytics::Application
 */
export declare namespace CfnApplication {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-jsonmappingparameters.html
     * @external
     */
    interface JSONMappingParametersProperty {
        /**
         * `CfnApplication.JSONMappingParametersProperty.RecordRowPath`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-jsonmappingparameters.html#cfn-kinesisanalytics-application-jsonmappingparameters-recordrowpath
         * @external
         */
        readonly recordRowPath: string;
    }
}
/**
 * A CloudFormation `AWS::KinesisAnalytics::Application`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-application.html
 * @external
 * @cloudformationResource AWS::KinesisAnalytics::Application
 */
export declare namespace CfnApplication {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-kinesisfirehoseinput.html
     * @external
     */
    interface KinesisFirehoseInputProperty {
        /**
         * `CfnApplication.KinesisFirehoseInputProperty.ResourceARN`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-kinesisfirehoseinput.html#cfn-kinesisanalytics-application-kinesisfirehoseinput-resourcearn
         * @external
         */
        readonly resourceArn: string;
        /**
         * `CfnApplication.KinesisFirehoseInputProperty.RoleARN`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-kinesisfirehoseinput.html#cfn-kinesisanalytics-application-kinesisfirehoseinput-rolearn
         * @external
         */
        readonly roleArn: string;
    }
}
/**
 * A CloudFormation `AWS::KinesisAnalytics::Application`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-application.html
 * @external
 * @cloudformationResource AWS::KinesisAnalytics::Application
 */
export declare namespace CfnApplication {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-kinesisstreamsinput.html
     * @external
     */
    interface KinesisStreamsInputProperty {
        /**
         * `CfnApplication.KinesisStreamsInputProperty.ResourceARN`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-kinesisstreamsinput.html#cfn-kinesisanalytics-application-kinesisstreamsinput-resourcearn
         * @external
         */
        readonly resourceArn: string;
        /**
         * `CfnApplication.KinesisStreamsInputProperty.RoleARN`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-kinesisstreamsinput.html#cfn-kinesisanalytics-application-kinesisstreamsinput-rolearn
         * @external
         */
        readonly roleArn: string;
    }
}
/**
 * A CloudFormation `AWS::KinesisAnalytics::Application`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-application.html
 * @external
 * @cloudformationResource AWS::KinesisAnalytics::Application
 */
export declare namespace CfnApplication {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-mappingparameters.html
     * @external
     */
    interface MappingParametersProperty {
        /**
         * `CfnApplication.MappingParametersProperty.CSVMappingParameters`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-mappingparameters.html#cfn-kinesisanalytics-application-mappingparameters-csvmappingparameters
         * @external
         */
        readonly csvMappingParameters?: CfnApplication.CSVMappingParametersProperty | cdk.IResolvable;
        /**
         * `CfnApplication.MappingParametersProperty.JSONMappingParameters`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-mappingparameters.html#cfn-kinesisanalytics-application-mappingparameters-jsonmappingparameters
         * @external
         */
        readonly jsonMappingParameters?: CfnApplication.JSONMappingParametersProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::KinesisAnalytics::Application`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-application.html
 * @external
 * @cloudformationResource AWS::KinesisAnalytics::Application
 */
export declare namespace CfnApplication {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-recordcolumn.html
     * @external
     */
    interface RecordColumnProperty {
        /**
         * `CfnApplication.RecordColumnProperty.Mapping`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-recordcolumn.html#cfn-kinesisanalytics-application-recordcolumn-mapping
         * @external
         */
        readonly mapping?: string;
        /**
         * `CfnApplication.RecordColumnProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-recordcolumn.html#cfn-kinesisanalytics-application-recordcolumn-name
         * @external
         */
        readonly name: string;
        /**
         * `CfnApplication.RecordColumnProperty.SqlType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-recordcolumn.html#cfn-kinesisanalytics-application-recordcolumn-sqltype
         * @external
         */
        readonly sqlType: string;
    }
}
/**
 * A CloudFormation `AWS::KinesisAnalytics::Application`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-application.html
 * @external
 * @cloudformationResource AWS::KinesisAnalytics::Application
 */
export declare namespace CfnApplication {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-recordformat.html
     * @external
     */
    interface RecordFormatProperty {
        /**
         * `CfnApplication.RecordFormatProperty.MappingParameters`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-recordformat.html#cfn-kinesisanalytics-application-recordformat-mappingparameters
         * @external
         */
        readonly mappingParameters?: CfnApplication.MappingParametersProperty | cdk.IResolvable;
        /**
         * `CfnApplication.RecordFormatProperty.RecordFormatType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-recordformat.html#cfn-kinesisanalytics-application-recordformat-recordformattype
         * @external
         */
        readonly recordFormatType: string;
    }
}
/**
 * Properties for defining a `AWS::KinesisAnalytics::ApplicationOutput`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-applicationoutput.html
 * @external
 */
export interface CfnApplicationOutputProps {
    /**
     * `AWS::KinesisAnalytics::ApplicationOutput.ApplicationName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-applicationoutput.html#cfn-kinesisanalytics-applicationoutput-applicationname
     * @external
     */
    readonly applicationName: string;
    /**
     * `AWS::KinesisAnalytics::ApplicationOutput.Output`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-applicationoutput.html#cfn-kinesisanalytics-applicationoutput-output
     * @external
     */
    readonly output: CfnApplicationOutput.OutputProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::KinesisAnalytics::ApplicationOutput`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-applicationoutput.html
 * @external
 * @cloudformationResource AWS::KinesisAnalytics::ApplicationOutput
 */
export declare class CfnApplicationOutput extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::KinesisAnalytics::ApplicationOutput";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnApplicationOutput;
    /**
     * `AWS::KinesisAnalytics::ApplicationOutput.ApplicationName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-applicationoutput.html#cfn-kinesisanalytics-applicationoutput-applicationname
     * @external
     */
    applicationName: string;
    /**
     * `AWS::KinesisAnalytics::ApplicationOutput.Output`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-applicationoutput.html#cfn-kinesisanalytics-applicationoutput-output
     * @external
     */
    output: CfnApplicationOutput.OutputProperty | cdk.IResolvable;
    /**
     * Create a new `AWS::KinesisAnalytics::ApplicationOutput`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnApplicationOutputProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::KinesisAnalytics::ApplicationOutput`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-applicationoutput.html
 * @external
 * @cloudformationResource AWS::KinesisAnalytics::ApplicationOutput
 */
export declare namespace CfnApplicationOutput {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationoutput-destinationschema.html
     * @external
     */
    interface DestinationSchemaProperty {
        /**
         * `CfnApplicationOutput.DestinationSchemaProperty.RecordFormatType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationoutput-destinationschema.html#cfn-kinesisanalytics-applicationoutput-destinationschema-recordformattype
         * @external
         */
        readonly recordFormatType?: string;
    }
}
/**
 * A CloudFormation `AWS::KinesisAnalytics::ApplicationOutput`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-applicationoutput.html
 * @external
 * @cloudformationResource AWS::KinesisAnalytics::ApplicationOutput
 */
export declare namespace CfnApplicationOutput {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationoutput-kinesisfirehoseoutput.html
     * @external
     */
    interface KinesisFirehoseOutputProperty {
        /**
         * `CfnApplicationOutput.KinesisFirehoseOutputProperty.ResourceARN`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationoutput-kinesisfirehoseoutput.html#cfn-kinesisanalytics-applicationoutput-kinesisfirehoseoutput-resourcearn
         * @external
         */
        readonly resourceArn: string;
        /**
         * `CfnApplicationOutput.KinesisFirehoseOutputProperty.RoleARN`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationoutput-kinesisfirehoseoutput.html#cfn-kinesisanalytics-applicationoutput-kinesisfirehoseoutput-rolearn
         * @external
         */
        readonly roleArn: string;
    }
}
/**
 * A CloudFormation `AWS::KinesisAnalytics::ApplicationOutput`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-applicationoutput.html
 * @external
 * @cloudformationResource AWS::KinesisAnalytics::ApplicationOutput
 */
export declare namespace CfnApplicationOutput {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationoutput-kinesisstreamsoutput.html
     * @external
     */
    interface KinesisStreamsOutputProperty {
        /**
         * `CfnApplicationOutput.KinesisStreamsOutputProperty.ResourceARN`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationoutput-kinesisstreamsoutput.html#cfn-kinesisanalytics-applicationoutput-kinesisstreamsoutput-resourcearn
         * @external
         */
        readonly resourceArn: string;
        /**
         * `CfnApplicationOutput.KinesisStreamsOutputProperty.RoleARN`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationoutput-kinesisstreamsoutput.html#cfn-kinesisanalytics-applicationoutput-kinesisstreamsoutput-rolearn
         * @external
         */
        readonly roleArn: string;
    }
}
/**
 * A CloudFormation `AWS::KinesisAnalytics::ApplicationOutput`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-applicationoutput.html
 * @external
 * @cloudformationResource AWS::KinesisAnalytics::ApplicationOutput
 */
export declare namespace CfnApplicationOutput {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationoutput-lambdaoutput.html
     * @external
     */
    interface LambdaOutputProperty {
        /**
         * `CfnApplicationOutput.LambdaOutputProperty.ResourceARN`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationoutput-lambdaoutput.html#cfn-kinesisanalytics-applicationoutput-lambdaoutput-resourcearn
         * @external
         */
        readonly resourceArn: string;
        /**
         * `CfnApplicationOutput.LambdaOutputProperty.RoleARN`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationoutput-lambdaoutput.html#cfn-kinesisanalytics-applicationoutput-lambdaoutput-rolearn
         * @external
         */
        readonly roleArn: string;
    }
}
/**
 * A CloudFormation `AWS::KinesisAnalytics::ApplicationOutput`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-applicationoutput.html
 * @external
 * @cloudformationResource AWS::KinesisAnalytics::ApplicationOutput
 */
export declare namespace CfnApplicationOutput {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationoutput-output.html
     * @external
     */
    interface OutputProperty {
        /**
         * `CfnApplicationOutput.OutputProperty.DestinationSchema`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationoutput-output.html#cfn-kinesisanalytics-applicationoutput-output-destinationschema
         * @external
         */
        readonly destinationSchema: CfnApplicationOutput.DestinationSchemaProperty | cdk.IResolvable;
        /**
         * `CfnApplicationOutput.OutputProperty.KinesisFirehoseOutput`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationoutput-output.html#cfn-kinesisanalytics-applicationoutput-output-kinesisfirehoseoutput
         * @external
         */
        readonly kinesisFirehoseOutput?: CfnApplicationOutput.KinesisFirehoseOutputProperty | cdk.IResolvable;
        /**
         * `CfnApplicationOutput.OutputProperty.KinesisStreamsOutput`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationoutput-output.html#cfn-kinesisanalytics-applicationoutput-output-kinesisstreamsoutput
         * @external
         */
        readonly kinesisStreamsOutput?: CfnApplicationOutput.KinesisStreamsOutputProperty | cdk.IResolvable;
        /**
         * `CfnApplicationOutput.OutputProperty.LambdaOutput`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationoutput-output.html#cfn-kinesisanalytics-applicationoutput-output-lambdaoutput
         * @external
         */
        readonly lambdaOutput?: CfnApplicationOutput.LambdaOutputProperty | cdk.IResolvable;
        /**
         * `CfnApplicationOutput.OutputProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationoutput-output.html#cfn-kinesisanalytics-applicationoutput-output-name
         * @external
         */
        readonly name?: string;
    }
}
/**
 * Properties for defining a `AWS::KinesisAnalytics::ApplicationReferenceDataSource`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-applicationreferencedatasource.html
 * @external
 */
export interface CfnApplicationReferenceDataSourceProps {
    /**
     * `AWS::KinesisAnalytics::ApplicationReferenceDataSource.ApplicationName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-applicationreferencedatasource.html#cfn-kinesisanalytics-applicationreferencedatasource-applicationname
     * @external
     */
    readonly applicationName: string;
    /**
     * `AWS::KinesisAnalytics::ApplicationReferenceDataSource.ReferenceDataSource`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-applicationreferencedatasource.html#cfn-kinesisanalytics-applicationreferencedatasource-referencedatasource
     * @external
     */
    readonly referenceDataSource: CfnApplicationReferenceDataSource.ReferenceDataSourceProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::KinesisAnalytics::ApplicationReferenceDataSource`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-applicationreferencedatasource.html
 * @external
 * @cloudformationResource AWS::KinesisAnalytics::ApplicationReferenceDataSource
 */
export declare class CfnApplicationReferenceDataSource extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::KinesisAnalytics::ApplicationReferenceDataSource";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnApplicationReferenceDataSource;
    /**
     * `AWS::KinesisAnalytics::ApplicationReferenceDataSource.ApplicationName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-applicationreferencedatasource.html#cfn-kinesisanalytics-applicationreferencedatasource-applicationname
     * @external
     */
    applicationName: string;
    /**
     * `AWS::KinesisAnalytics::ApplicationReferenceDataSource.ReferenceDataSource`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-applicationreferencedatasource.html#cfn-kinesisanalytics-applicationreferencedatasource-referencedatasource
     * @external
     */
    referenceDataSource: CfnApplicationReferenceDataSource.ReferenceDataSourceProperty | cdk.IResolvable;
    /**
     * Create a new `AWS::KinesisAnalytics::ApplicationReferenceDataSource`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnApplicationReferenceDataSourceProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::KinesisAnalytics::ApplicationReferenceDataSource`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-applicationreferencedatasource.html
 * @external
 * @cloudformationResource AWS::KinesisAnalytics::ApplicationReferenceDataSource
 */
export declare namespace CfnApplicationReferenceDataSource {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-csvmappingparameters.html
     * @external
     */
    interface CSVMappingParametersProperty {
        /**
         * `CfnApplicationReferenceDataSource.CSVMappingParametersProperty.RecordColumnDelimiter`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-csvmappingparameters.html#cfn-kinesisanalytics-applicationreferencedatasource-csvmappingparameters-recordcolumndelimiter
         * @external
         */
        readonly recordColumnDelimiter: string;
        /**
         * `CfnApplicationReferenceDataSource.CSVMappingParametersProperty.RecordRowDelimiter`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-csvmappingparameters.html#cfn-kinesisanalytics-applicationreferencedatasource-csvmappingparameters-recordrowdelimiter
         * @external
         */
        readonly recordRowDelimiter: string;
    }
}
/**
 * A CloudFormation `AWS::KinesisAnalytics::ApplicationReferenceDataSource`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-applicationreferencedatasource.html
 * @external
 * @cloudformationResource AWS::KinesisAnalytics::ApplicationReferenceDataSource
 */
export declare namespace CfnApplicationReferenceDataSource {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-jsonmappingparameters.html
     * @external
     */
    interface JSONMappingParametersProperty {
        /**
         * `CfnApplicationReferenceDataSource.JSONMappingParametersProperty.RecordRowPath`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-jsonmappingparameters.html#cfn-kinesisanalytics-applicationreferencedatasource-jsonmappingparameters-recordrowpath
         * @external
         */
        readonly recordRowPath: string;
    }
}
/**
 * A CloudFormation `AWS::KinesisAnalytics::ApplicationReferenceDataSource`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-applicationreferencedatasource.html
 * @external
 * @cloudformationResource AWS::KinesisAnalytics::ApplicationReferenceDataSource
 */
export declare namespace CfnApplicationReferenceDataSource {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-mappingparameters.html
     * @external
     */
    interface MappingParametersProperty {
        /**
         * `CfnApplicationReferenceDataSource.MappingParametersProperty.CSVMappingParameters`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-mappingparameters.html#cfn-kinesisanalytics-applicationreferencedatasource-mappingparameters-csvmappingparameters
         * @external
         */
        readonly csvMappingParameters?: CfnApplicationReferenceDataSource.CSVMappingParametersProperty | cdk.IResolvable;
        /**
         * `CfnApplicationReferenceDataSource.MappingParametersProperty.JSONMappingParameters`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-mappingparameters.html#cfn-kinesisanalytics-applicationreferencedatasource-mappingparameters-jsonmappingparameters
         * @external
         */
        readonly jsonMappingParameters?: CfnApplicationReferenceDataSource.JSONMappingParametersProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::KinesisAnalytics::ApplicationReferenceDataSource`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-applicationreferencedatasource.html
 * @external
 * @cloudformationResource AWS::KinesisAnalytics::ApplicationReferenceDataSource
 */
export declare namespace CfnApplicationReferenceDataSource {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-recordcolumn.html
     * @external
     */
    interface RecordColumnProperty {
        /**
         * `CfnApplicationReferenceDataSource.RecordColumnProperty.Mapping`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-recordcolumn.html#cfn-kinesisanalytics-applicationreferencedatasource-recordcolumn-mapping
         * @external
         */
        readonly mapping?: string;
        /**
         * `CfnApplicationReferenceDataSource.RecordColumnProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-recordcolumn.html#cfn-kinesisanalytics-applicationreferencedatasource-recordcolumn-name
         * @external
         */
        readonly name: string;
        /**
         * `CfnApplicationReferenceDataSource.RecordColumnProperty.SqlType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-recordcolumn.html#cfn-kinesisanalytics-applicationreferencedatasource-recordcolumn-sqltype
         * @external
         */
        readonly sqlType: string;
    }
}
/**
 * A CloudFormation `AWS::KinesisAnalytics::ApplicationReferenceDataSource`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-applicationreferencedatasource.html
 * @external
 * @cloudformationResource AWS::KinesisAnalytics::ApplicationReferenceDataSource
 */
export declare namespace CfnApplicationReferenceDataSource {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-recordformat.html
     * @external
     */
    interface RecordFormatProperty {
        /**
         * `CfnApplicationReferenceDataSource.RecordFormatProperty.MappingParameters`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-recordformat.html#cfn-kinesisanalytics-applicationreferencedatasource-recordformat-mappingparameters
         * @external
         */
        readonly mappingParameters?: CfnApplicationReferenceDataSource.MappingParametersProperty | cdk.IResolvable;
        /**
         * `CfnApplicationReferenceDataSource.RecordFormatProperty.RecordFormatType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-recordformat.html#cfn-kinesisanalytics-applicationreferencedatasource-recordformat-recordformattype
         * @external
         */
        readonly recordFormatType: string;
    }
}
/**
 * A CloudFormation `AWS::KinesisAnalytics::ApplicationReferenceDataSource`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-applicationreferencedatasource.html
 * @external
 * @cloudformationResource AWS::KinesisAnalytics::ApplicationReferenceDataSource
 */
export declare namespace CfnApplicationReferenceDataSource {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-referencedatasource.html
     * @external
     */
    interface ReferenceDataSourceProperty {
        /**
         * `CfnApplicationReferenceDataSource.ReferenceDataSourceProperty.ReferenceSchema`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-referencedatasource.html#cfn-kinesisanalytics-applicationreferencedatasource-referencedatasource-referenceschema
         * @external
         */
        readonly referenceSchema: CfnApplicationReferenceDataSource.ReferenceSchemaProperty | cdk.IResolvable;
        /**
         * `CfnApplicationReferenceDataSource.ReferenceDataSourceProperty.S3ReferenceDataSource`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-referencedatasource.html#cfn-kinesisanalytics-applicationreferencedatasource-referencedatasource-s3referencedatasource
         * @external
         */
        readonly s3ReferenceDataSource?: CfnApplicationReferenceDataSource.S3ReferenceDataSourceProperty | cdk.IResolvable;
        /**
         * `CfnApplicationReferenceDataSource.ReferenceDataSourceProperty.TableName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-referencedatasource.html#cfn-kinesisanalytics-applicationreferencedatasource-referencedatasource-tablename
         * @external
         */
        readonly tableName?: string;
    }
}
/**
 * A CloudFormation `AWS::KinesisAnalytics::ApplicationReferenceDataSource`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-applicationreferencedatasource.html
 * @external
 * @cloudformationResource AWS::KinesisAnalytics::ApplicationReferenceDataSource
 */
export declare namespace CfnApplicationReferenceDataSource {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-referenceschema.html
     * @external
     */
    interface ReferenceSchemaProperty {
        /**
         * `CfnApplicationReferenceDataSource.ReferenceSchemaProperty.RecordColumns`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-referenceschema.html#cfn-kinesisanalytics-applicationreferencedatasource-referenceschema-recordcolumns
         * @external
         */
        readonly recordColumns: Array<CfnApplicationReferenceDataSource.RecordColumnProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnApplicationReferenceDataSource.ReferenceSchemaProperty.RecordEncoding`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-referenceschema.html#cfn-kinesisanalytics-applicationreferencedatasource-referenceschema-recordencoding
         * @external
         */
        readonly recordEncoding?: string;
        /**
         * `CfnApplicationReferenceDataSource.ReferenceSchemaProperty.RecordFormat`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-referenceschema.html#cfn-kinesisanalytics-applicationreferencedatasource-referenceschema-recordformat
         * @external
         */
        readonly recordFormat: CfnApplicationReferenceDataSource.RecordFormatProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::KinesisAnalytics::ApplicationReferenceDataSource`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-applicationreferencedatasource.html
 * @external
 * @cloudformationResource AWS::KinesisAnalytics::ApplicationReferenceDataSource
 */
export declare namespace CfnApplicationReferenceDataSource {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-s3referencedatasource.html
     * @external
     */
    interface S3ReferenceDataSourceProperty {
        /**
         * `CfnApplicationReferenceDataSource.S3ReferenceDataSourceProperty.BucketARN`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-s3referencedatasource.html#cfn-kinesisanalytics-applicationreferencedatasource-s3referencedatasource-bucketarn
         * @external
         */
        readonly bucketArn: string;
        /**
         * `CfnApplicationReferenceDataSource.S3ReferenceDataSourceProperty.FileKey`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-s3referencedatasource.html#cfn-kinesisanalytics-applicationreferencedatasource-s3referencedatasource-filekey
         * @external
         */
        readonly fileKey: string;
        /**
         * `CfnApplicationReferenceDataSource.S3ReferenceDataSourceProperty.ReferenceRoleARN`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-s3referencedatasource.html#cfn-kinesisanalytics-applicationreferencedatasource-s3referencedatasource-referencerolearn
         * @external
         */
        readonly referenceRoleArn: string;
    }
}
