import { IConstruct } from 'constructs';
import { PolicyStatement } from './policy-statement';
import { AddToPrincipalPolicyResult, IPrincipal, PrincipalPolicyFragment } from './principals';
/**
 * (experimental) Properties for an UnknownPrincipal.
 *
 * @experimental
 */
export interface UnknownPrincipalProps {
    /**
     * (experimental) The resource the role proxy is for.
     *
     * @experimental
     */
    readonly resource: IConstruct;
}
/**
 * (experimental) A principal for use in resources that need to have a role but it's unknown.
 *
 * Some resources have roles associated with them which they assume, such as
 * Lambda Functions, CodeBuild projects, StepFunctions machines, etc.
 *
 * When those resources are imported, their actual roles are not always
 * imported with them. When that happens, we use an instance of this class
 * instead, which will add user warnings when statements are attempted to be
 * added to it.
 *
 * @experimental
 */
export declare class UnknownPrincipal implements IPrincipal {
    /**
     * (experimental) When this Principal is used in an AssumeRole policy, the action to use.
     *
     * @experimental
     */
    readonly assumeRoleAction: string;
    /**
     * (experimental) The principal to grant permissions to.
     *
     * @experimental
     */
    readonly grantPrincipal: IPrincipal;
    private readonly resource;
    /**
     * @experimental
     */
    constructor(props: UnknownPrincipalProps);
    /**
     * (experimental) Return the policy fragment that identifies this principal in a Policy.
     *
     * @experimental
     */
    get policyFragment(): PrincipalPolicyFragment;
    /**
     * (experimental) Add to the policy of this principal.
     *
     * @experimental
     */
    addToPrincipalPolicy(statement: PolicyStatement): AddToPrincipalPolicyResult;
    /**
     * (experimental) Add to the policy of this principal.
     *
     * @experimental
     */
    addToPolicy(statement: PolicyStatement): boolean;
}
