import { Resource } from "../../core";
import { Construct } from 'constructs';
import { IGroup } from './group';
import { PolicyDocument } from './policy-document';
import { PolicyStatement } from './policy-statement';
import { IRole } from './role';
import { IUser } from './user';
/**
 * (experimental) A managed policy.
 *
 * @experimental
 */
export interface IManagedPolicy {
    /**
     * (experimental) The ARN of the managed policy.
     *
     * @experimental
     * @attribute true
     */
    readonly managedPolicyArn: string;
}
/**
 * (experimental) Properties for defining an IAM managed policy.
 *
 * @experimental
 */
export interface ManagedPolicyProps {
    /**
     * (experimental) The name of the managed policy.
     *
     * If you specify multiple policies for an entity,
     * specify unique names. For example, if you specify a list of policies for
     * an IAM role, each policy must have a unique name.
     *
     * @default - A name is automatically generated.
     * @experimental
     */
    readonly managedPolicyName?: string;
    /**
     * (experimental) A description of the managed policy.
     *
     * Typically used to store information about the
     * permissions defined in the policy. For example, "Grants access to production DynamoDB tables."
     * The policy description is immutable. After a value is assigned, it cannot be changed.
     *
     * @default - empty
     * @experimental
     */
    readonly description?: string;
    /**
     * (experimental) The path for the policy.
     *
     * This parameter allows (through its regex pattern) a string of characters
     * consisting of either a forward slash (/) by itself or a string that must begin and end with forward slashes.
     * In addition, it can contain any ASCII character from the ! (\u0021) through the DEL character (\u007F),
     * including most punctuation characters, digits, and upper and lowercased letters.
     *
     * For more information about paths, see IAM Identifiers in the IAM User Guide.
     *
     * @default - "/"
     * @experimental
     */
    readonly path?: string;
    /**
     * (experimental) Users to attach this policy to.
     *
     * You can also use `attachToUser(user)` to attach this policy to a user.
     *
     * @default - No users.
     * @experimental
     */
    readonly users?: IUser[];
    /**
     * (experimental) Roles to attach this policy to.
     *
     * You can also use `attachToRole(role)` to attach this policy to a role.
     *
     * @default - No roles.
     * @experimental
     */
    readonly roles?: IRole[];
    /**
     * (experimental) Groups to attach this policy to.
     *
     * You can also use `attachToGroup(group)` to attach this policy to a group.
     *
     * @default - No groups.
     * @experimental
     */
    readonly groups?: IGroup[];
    /**
     * (experimental) Initial set of permissions to add to this policy document.
     *
     * You can also use `addPermission(statement)` to add permissions later.
     *
     * @default - No statements.
     * @experimental
     */
    readonly statements?: PolicyStatement[];
    /**
     * (experimental) Initial PolicyDocument to use for this ManagedPolicy.
     *
     * If omited, any
     * `PolicyStatement` provided in the `statements` property will be applied
     * against the empty default `PolicyDocument`.
     *
     * @default - An empty policy.
     * @experimental
     */
    readonly document?: PolicyDocument;
}
/**
 * (experimental) Managed policy.
 *
 * @experimental
 */
export declare class ManagedPolicy extends Resource implements IManagedPolicy {
    /**
     * (experimental) Import a customer managed policy from the managedPolicyName.
     *
     * For this managed policy, you only need to know the name to be able to use it.
     *
     * @experimental
     */
    static fromManagedPolicyName(scope: Construct, id: string, managedPolicyName: string): IManagedPolicy;
    /**
     * (experimental) Import an external managed policy by ARN.
     *
     * For this managed policy, you only need to know the ARN to be able to use it.
     * This can be useful if you got the ARN from a CloudFormation Export.
     *
     * If the imported Managed Policy ARN is a Token (such as a
     * `CfnParameter.valueAsString` or a `Fn.importValue()`) *and* the referenced
     * managed policy has a `path` (like `arn:...:policy/AdminPolicy/AdminAllow`), the
     * `managedPolicyName` property will not resolve to the correct value. Instead it
     * will resolve to the first path component. We unfortunately cannot express
     * the correct calculation of the full path name as a CloudFormation
     * expression. In this scenario the Managed Policy ARN should be supplied without the
     * `path` in order to resolve the correct managed policy resource.
     *
     * @param scope construct scope.
     * @param id construct id.
     * @param managedPolicyArn the ARN of the managed policy to import.
     * @experimental
     */
    static fromManagedPolicyArn(scope: Construct, id: string, managedPolicyArn: string): IManagedPolicy;
    /**
     * (experimental) Import a managed policy from one of the policies that AWS manages.
     *
     * For this managed policy, you only need to know the name to be able to use it.
     *
     * Some managed policy names start with "service-role/", some start with
     * "job-function/", and some don't start with anything. Do include the
     * prefix when constructing this object.
     *
     * @experimental
     */
    static fromAwsManagedPolicyName(managedPolicyName: string): IManagedPolicy;
    /**
     * (experimental) Returns the ARN of this managed policy.
     *
     * @experimental
     * @attribute true
     */
    readonly managedPolicyArn: string;
    /**
     * (experimental) The policy document.
     *
     * @experimental
     */
    readonly document: PolicyDocument;
    /**
     * (experimental) The name of this policy.
     *
     * @experimental
     * @attribute true
     */
    readonly managedPolicyName: string;
    /**
     * (experimental) The description of this policy.
     *
     * @experimental
     * @attribute true
     */
    readonly description: string;
    /**
     * (experimental) The path of this policy.
     *
     * @experimental
     * @attribute true
     */
    readonly path: string;
    private readonly roles;
    private readonly users;
    private readonly groups;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: ManagedPolicyProps);
    /**
     * (experimental) Adds a statement to the policy document.
     *
     * @experimental
     */
    addStatements(...statement: PolicyStatement[]): void;
    /**
     * (experimental) Attaches this policy to a user.
     *
     * @experimental
     */
    attachToUser(user: IUser): void;
    /**
     * (experimental) Attaches this policy to a role.
     *
     * @experimental
     */
    attachToRole(role: IRole): void;
    /**
     * (experimental) Attaches this policy to a group.
     *
     * @experimental
     */
    attachToGroup(group: IGroup): void;
    /**
     * (experimental) Validate the current construct.
     *
     * This method can be implemented by derived constructs in order to perform
     * validation logic. It is called on all constructs before synthesis.
     *
     * @experimental
     */
    protected validate(): string[];
}
