import * as cdk from "../../core";
import { Construct } from 'constructs';
import { Grant } from './grant';
import { IManagedPolicy } from './managed-policy';
import { Policy } from './policy';
import { PolicyStatement } from './policy-statement';
import { AddToPrincipalPolicyResult, IPrincipal, PrincipalPolicyFragment } from './principals';
import { IRole, RoleProps } from './role';
/**
 * (experimental) Properties for defining a LazyRole.
 *
 * @experimental
 */
export interface LazyRoleProps extends RoleProps {
}
/**
 * (experimental) An IAM role that only gets attached to the construct tree once it gets used, not before.
 *
 * This construct can be used to simplify logic in other constructs
 * which need to create a role but only if certain configurations occur
 * (such as when AutoScaling is configured). The role can be configured in one
 * place, but if it never gets used it doesn't get instantiated and will
 * not be synthesized or deployed.
 *
 * @experimental
 * @resource AWS::IAM::Role
 */
export declare class LazyRole extends cdk.Resource implements IRole {
    private readonly props;
    /**
     * (experimental) The principal to grant permissions to.
     *
     * @experimental
     */
    readonly grantPrincipal: IPrincipal;
    /**
     * (experimental) The AWS account ID of this principal.
     *
     * Can be undefined when the account is not known
     * (for example, for service principals).
     * Can be a Token - in that case,
     * it's assumed to be AWS::AccountId.
     *
     * @experimental
     */
    readonly principalAccount: string | undefined;
    /**
     * (experimental) When this Principal is used in an AssumeRole policy, the action to use.
     *
     * @experimental
     */
    readonly assumeRoleAction: string;
    private role?;
    private readonly statements;
    private readonly policies;
    private readonly managedPolicies;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: LazyRoleProps);
    /**
     * (experimental) Adds a permission to the role's default policy document.
     *
     * If there is no default policy attached to this role, it will be created.
     *
     * @param statement The permission statement to add to the policy document.
     * @experimental
     */
    addToPrincipalPolicy(statement: PolicyStatement): AddToPrincipalPolicyResult;
    /**
     * (experimental) Add to the policy of this principal.
     *
     * @experimental
     */
    addToPolicy(statement: PolicyStatement): boolean;
    /**
     * (experimental) Attaches a policy to this role.
     *
     * @param policy The policy to attach.
     * @experimental
     */
    attachInlinePolicy(policy: Policy): void;
    /**
     * (experimental) Attaches a managed policy to this role.
     *
     * @param policy The managed policy to attach.
     * @experimental
     */
    addManagedPolicy(policy: IManagedPolicy): void;
    /**
     * (experimental) Returns the ARN of this role.
     *
     * @experimental
     */
    get roleArn(): string;
    /**
     * (experimental) Returns the stable and unique string identifying the role (i.e. AIDAJQABLZS4A3QDU576Q).
     *
     * @experimental
     * @attribute true
     */
    get roleId(): string;
    /**
     * (experimental) Returns the name of this role.
     *
     * @experimental
     */
    get roleName(): string;
    /**
     * (experimental) Return the policy fragment that identifies this principal in a Policy.
     *
     * @experimental
     */
    get policyFragment(): PrincipalPolicyFragment;
    /**
     * (experimental) Grant the actions defined in actions to the identity Principal on this resource.
     *
     * @experimental
     */
    grant(identity: IPrincipal, ...actions: string[]): Grant;
    /**
     * (experimental) Grant permissions to the given principal to pass this role.
     *
     * @experimental
     */
    grantPassRole(identity: IPrincipal): Grant;
    private instantiate;
}
