"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Schema = void 0;
/**
 * @see https://docs.aws.amazon.com/athena/latest/ug/data-types.html
 * @experimental
 */
class Schema {
    /**
     * (experimental) Creates a decimal type.
     *
     * TODO: Bounds
     *
     * @param precision the total number of digits.
     * @param scale the number of digits in fractional part, the default is 0.
     * @experimental
     */
    static decimal(precision, scale) {
        return {
            isPrimitive: true,
            inputString: scale !== undefined ? `decimal(${precision},${scale})` : `decimal(${precision})`,
        };
    }
    /**
     * (experimental) Fixed length character data, with a specified length between 1 and 255.
     *
     * @param length length between 1 and 255.
     * @experimental
     */
    static char(length) {
        if (length <= 0 || length > 255) {
            throw new Error(`char length must be (inclusively) between 1 and 255, but was ${length}`);
        }
        if (length % 1 !== 0) {
            throw new Error(`char length must be a positive integer, was ${length}`);
        }
        return {
            isPrimitive: true,
            inputString: `char(${length})`,
        };
    }
    /**
     * (experimental) Variable length character data, with a specified length between 1 and 65535.
     *
     * @param length length between 1 and 65535.
     * @experimental
     */
    static varchar(length) {
        if (length <= 0 || length > 65535) {
            throw new Error(`varchar length must be (inclusively) between 1 and 65535, but was ${length}`);
        }
        if (length % 1 !== 0) {
            throw new Error(`varchar length must be a positive integer, was ${length}`);
        }
        return {
            isPrimitive: true,
            inputString: `varchar(${length})`,
        };
    }
    /**
     * (experimental) Creates an array of some other type.
     *
     * @param itemType type contained by the array.
     * @experimental
     */
    static array(itemType) {
        return {
            isPrimitive: false,
            inputString: `array<${itemType.inputString}>`,
        };
    }
    /**
     * (experimental) Creates a map of some primitive key type to some value type.
     *
     * @param keyType type of key, must be a primitive.
     * @param valueType type fo the value indexed by the key.
     * @experimental
     */
    static map(keyType, valueType) {
        if (!keyType.isPrimitive) {
            throw new Error(`the key type of a 'map' must be a primitive, but was ${keyType.inputString}`);
        }
        return {
            isPrimitive: false,
            inputString: `map<${keyType.inputString},${valueType.inputString}>`,
        };
    }
    /**
     * (experimental) Creates a nested structure containing individually named and typed columns.
     *
     * @param columns the columns of the structure.
     * @experimental
     */
    static struct(columns) {
        return {
            isPrimitive: false,
            inputString: `struct<${columns.map(column => {
                if (column.comment === undefined) {
                    return `${column.name}:${column.type.inputString}`;
                }
                else {
                    return `${column.name}:${column.type.inputString} COMMENT '${column.comment}'`;
                }
            }).join(',')}>`,
        };
    }
}
exports.Schema = Schema;
/**
 * @experimental
 */
Schema.BOOLEAN = {
    isPrimitive: true,
    inputString: 'boolean',
};
/**
 * @experimental
 */
Schema.BINARY = {
    isPrimitive: true,
    inputString: 'binary',
};
/**
 * (experimental) A 64-bit signed INTEGER in two’s complement format, with a minimum value of -2^63 and a maximum value of 2^63-1.
 *
 * @experimental
 */
Schema.BIG_INT = {
    isPrimitive: true,
    inputString: 'bigint',
};
/**
 * @experimental
 */
Schema.DOUBLE = {
    isPrimitive: true,
    inputString: 'double',
};
/**
 * @experimental
 */
Schema.FLOAT = {
    isPrimitive: true,
    inputString: 'float',
};
/**
 * (experimental) A 32-bit signed INTEGER in two’s complement format, with a minimum value of -2^31 and a maximum value of 2^31-1.
 *
 * @experimental
 */
Schema.INTEGER = {
    isPrimitive: true,
    inputString: 'int',
};
/**
 * (experimental) A 16-bit signed INTEGER in two’s complement format, with a minimum value of -2^15 and a maximum value of 2^15-1.
 *
 * @experimental
 */
Schema.SMALL_INT = {
    isPrimitive: true,
    inputString: 'smallint',
};
/**
 * (experimental) A 8-bit signed INTEGER in two’s complement format, with a minimum value of -2^7 and a maximum value of 2^7-1.
 *
 * @experimental
 */
Schema.TINY_INT = {
    isPrimitive: true,
    inputString: 'tinyint',
};
/**
 * (experimental) Date type.
 *
 * @experimental
 */
Schema.DATE = {
    isPrimitive: true,
    inputString: 'date',
};
/**
 * (experimental) Timestamp type (date and time).
 *
 * @experimental
 */
Schema.TIMESTAMP = {
    isPrimitive: true,
    inputString: 'timestamp',
};
/**
 * (experimental) Arbitrary-length string type.
 *
 * @experimental
 */
Schema.STRING = {
    isPrimitive: true,
    inputString: 'string',
};
//# sourceMappingURL=data:application/json;base64,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