import * as cdk from "../../core";
import * as cfn_parse from "../../core/lib/cfn-parse";
/**
 * Properties for defining a `AWS::Glue::Classifier`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-classifier.html
 * @external
 */
export interface CfnClassifierProps {
    /**
     * `AWS::Glue::Classifier.CsvClassifier`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-classifier.html#cfn-glue-classifier-csvclassifier
     * @external
     */
    readonly csvClassifier?: CfnClassifier.CsvClassifierProperty | cdk.IResolvable;
    /**
     * `AWS::Glue::Classifier.GrokClassifier`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-classifier.html#cfn-glue-classifier-grokclassifier
     * @external
     */
    readonly grokClassifier?: CfnClassifier.GrokClassifierProperty | cdk.IResolvable;
    /**
     * `AWS::Glue::Classifier.JsonClassifier`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-classifier.html#cfn-glue-classifier-jsonclassifier
     * @external
     */
    readonly jsonClassifier?: CfnClassifier.JsonClassifierProperty | cdk.IResolvable;
    /**
     * `AWS::Glue::Classifier.XMLClassifier`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-classifier.html#cfn-glue-classifier-xmlclassifier
     * @external
     */
    readonly xmlClassifier?: CfnClassifier.XMLClassifierProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Glue::Classifier`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-classifier.html
 * @external
 * @cloudformationResource AWS::Glue::Classifier
 */
export declare class CfnClassifier extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Glue::Classifier";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnClassifier;
    /**
     * `AWS::Glue::Classifier.CsvClassifier`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-classifier.html#cfn-glue-classifier-csvclassifier
     * @external
     */
    csvClassifier: CfnClassifier.CsvClassifierProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Glue::Classifier.GrokClassifier`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-classifier.html#cfn-glue-classifier-grokclassifier
     * @external
     */
    grokClassifier: CfnClassifier.GrokClassifierProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Glue::Classifier.JsonClassifier`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-classifier.html#cfn-glue-classifier-jsonclassifier
     * @external
     */
    jsonClassifier: CfnClassifier.JsonClassifierProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Glue::Classifier.XMLClassifier`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-classifier.html#cfn-glue-classifier-xmlclassifier
     * @external
     */
    xmlClassifier: CfnClassifier.XMLClassifierProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::Glue::Classifier`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnClassifierProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Glue::Classifier`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-classifier.html
 * @external
 * @cloudformationResource AWS::Glue::Classifier
 */
export declare namespace CfnClassifier {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-csvclassifier.html
     * @external
     */
    interface CsvClassifierProperty {
        /**
         * `CfnClassifier.CsvClassifierProperty.AllowSingleColumn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-csvclassifier.html#cfn-glue-classifier-csvclassifier-allowsinglecolumn
         * @external
         */
        readonly allowSingleColumn?: boolean | cdk.IResolvable;
        /**
         * `CfnClassifier.CsvClassifierProperty.ContainsHeader`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-csvclassifier.html#cfn-glue-classifier-csvclassifier-containsheader
         * @external
         */
        readonly containsHeader?: string;
        /**
         * `CfnClassifier.CsvClassifierProperty.Delimiter`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-csvclassifier.html#cfn-glue-classifier-csvclassifier-delimiter
         * @external
         */
        readonly delimiter?: string;
        /**
         * `CfnClassifier.CsvClassifierProperty.DisableValueTrimming`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-csvclassifier.html#cfn-glue-classifier-csvclassifier-disablevaluetrimming
         * @external
         */
        readonly disableValueTrimming?: boolean | cdk.IResolvable;
        /**
         * `CfnClassifier.CsvClassifierProperty.Header`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-csvclassifier.html#cfn-glue-classifier-csvclassifier-header
         * @external
         */
        readonly header?: string[];
        /**
         * `CfnClassifier.CsvClassifierProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-csvclassifier.html#cfn-glue-classifier-csvclassifier-name
         * @external
         */
        readonly name?: string;
        /**
         * `CfnClassifier.CsvClassifierProperty.QuoteSymbol`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-csvclassifier.html#cfn-glue-classifier-csvclassifier-quotesymbol
         * @external
         */
        readonly quoteSymbol?: string;
    }
}
/**
 * A CloudFormation `AWS::Glue::Classifier`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-classifier.html
 * @external
 * @cloudformationResource AWS::Glue::Classifier
 */
export declare namespace CfnClassifier {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-grokclassifier.html
     * @external
     */
    interface GrokClassifierProperty {
        /**
         * `CfnClassifier.GrokClassifierProperty.Classification`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-grokclassifier.html#cfn-glue-classifier-grokclassifier-classification
         * @external
         */
        readonly classification: string;
        /**
         * `CfnClassifier.GrokClassifierProperty.CustomPatterns`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-grokclassifier.html#cfn-glue-classifier-grokclassifier-custompatterns
         * @external
         */
        readonly customPatterns?: string;
        /**
         * `CfnClassifier.GrokClassifierProperty.GrokPattern`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-grokclassifier.html#cfn-glue-classifier-grokclassifier-grokpattern
         * @external
         */
        readonly grokPattern: string;
        /**
         * `CfnClassifier.GrokClassifierProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-grokclassifier.html#cfn-glue-classifier-grokclassifier-name
         * @external
         */
        readonly name?: string;
    }
}
/**
 * A CloudFormation `AWS::Glue::Classifier`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-classifier.html
 * @external
 * @cloudformationResource AWS::Glue::Classifier
 */
export declare namespace CfnClassifier {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-jsonclassifier.html
     * @external
     */
    interface JsonClassifierProperty {
        /**
         * `CfnClassifier.JsonClassifierProperty.JsonPath`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-jsonclassifier.html#cfn-glue-classifier-jsonclassifier-jsonpath
         * @external
         */
        readonly jsonPath: string;
        /**
         * `CfnClassifier.JsonClassifierProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-jsonclassifier.html#cfn-glue-classifier-jsonclassifier-name
         * @external
         */
        readonly name?: string;
    }
}
/**
 * A CloudFormation `AWS::Glue::Classifier`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-classifier.html
 * @external
 * @cloudformationResource AWS::Glue::Classifier
 */
export declare namespace CfnClassifier {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-xmlclassifier.html
     * @external
     */
    interface XMLClassifierProperty {
        /**
         * `CfnClassifier.XMLClassifierProperty.Classification`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-xmlclassifier.html#cfn-glue-classifier-xmlclassifier-classification
         * @external
         */
        readonly classification: string;
        /**
         * `CfnClassifier.XMLClassifierProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-xmlclassifier.html#cfn-glue-classifier-xmlclassifier-name
         * @external
         */
        readonly name?: string;
        /**
         * `CfnClassifier.XMLClassifierProperty.RowTag`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-classifier-xmlclassifier.html#cfn-glue-classifier-xmlclassifier-rowtag
         * @external
         */
        readonly rowTag: string;
    }
}
/**
 * Properties for defining a `AWS::Glue::Connection`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-connection.html
 * @external
 */
export interface CfnConnectionProps {
    /**
     * `AWS::Glue::Connection.CatalogId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-connection.html#cfn-glue-connection-catalogid
     * @external
     */
    readonly catalogId: string;
    /**
     * `AWS::Glue::Connection.ConnectionInput`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-connection.html#cfn-glue-connection-connectioninput
     * @external
     */
    readonly connectionInput: CfnConnection.ConnectionInputProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Glue::Connection`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-connection.html
 * @external
 * @cloudformationResource AWS::Glue::Connection
 */
export declare class CfnConnection extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Glue::Connection";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnConnection;
    /**
     * `AWS::Glue::Connection.CatalogId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-connection.html#cfn-glue-connection-catalogid
     * @external
     */
    catalogId: string;
    /**
     * `AWS::Glue::Connection.ConnectionInput`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-connection.html#cfn-glue-connection-connectioninput
     * @external
     */
    connectionInput: CfnConnection.ConnectionInputProperty | cdk.IResolvable;
    /**
     * Create a new `AWS::Glue::Connection`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnConnectionProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Glue::Connection`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-connection.html
 * @external
 * @cloudformationResource AWS::Glue::Connection
 */
export declare namespace CfnConnection {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-connectioninput.html
     * @external
     */
    interface ConnectionInputProperty {
        /**
         * `CfnConnection.ConnectionInputProperty.ConnectionProperties`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-connectioninput.html#cfn-glue-connection-connectioninput-connectionproperties
         * @external
         */
        readonly connectionProperties: any | cdk.IResolvable;
        /**
         * `CfnConnection.ConnectionInputProperty.ConnectionType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-connectioninput.html#cfn-glue-connection-connectioninput-connectiontype
         * @external
         */
        readonly connectionType: string;
        /**
         * `CfnConnection.ConnectionInputProperty.Description`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-connectioninput.html#cfn-glue-connection-connectioninput-description
         * @external
         */
        readonly description?: string;
        /**
         * `CfnConnection.ConnectionInputProperty.MatchCriteria`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-connectioninput.html#cfn-glue-connection-connectioninput-matchcriteria
         * @external
         */
        readonly matchCriteria?: string[];
        /**
         * `CfnConnection.ConnectionInputProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-connectioninput.html#cfn-glue-connection-connectioninput-name
         * @external
         */
        readonly name?: string;
        /**
         * `CfnConnection.ConnectionInputProperty.PhysicalConnectionRequirements`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-connectioninput.html#cfn-glue-connection-connectioninput-physicalconnectionrequirements
         * @external
         */
        readonly physicalConnectionRequirements?: CfnConnection.PhysicalConnectionRequirementsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Glue::Connection`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-connection.html
 * @external
 * @cloudformationResource AWS::Glue::Connection
 */
export declare namespace CfnConnection {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-physicalconnectionrequirements.html
     * @external
     */
    interface PhysicalConnectionRequirementsProperty {
        /**
         * `CfnConnection.PhysicalConnectionRequirementsProperty.AvailabilityZone`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-physicalconnectionrequirements.html#cfn-glue-connection-physicalconnectionrequirements-availabilityzone
         * @external
         */
        readonly availabilityZone?: string;
        /**
         * `CfnConnection.PhysicalConnectionRequirementsProperty.SecurityGroupIdList`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-physicalconnectionrequirements.html#cfn-glue-connection-physicalconnectionrequirements-securitygroupidlist
         * @external
         */
        readonly securityGroupIdList?: string[];
        /**
         * `CfnConnection.PhysicalConnectionRequirementsProperty.SubnetId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-connection-physicalconnectionrequirements.html#cfn-glue-connection-physicalconnectionrequirements-subnetid
         * @external
         */
        readonly subnetId?: string;
    }
}
/**
 * Properties for defining a `AWS::Glue::Crawler`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html
 * @external
 */
export interface CfnCrawlerProps {
    /**
     * `AWS::Glue::Crawler.Role`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-role
     * @external
     */
    readonly role: string;
    /**
     * `AWS::Glue::Crawler.Targets`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-targets
     * @external
     */
    readonly targets: CfnCrawler.TargetsProperty | cdk.IResolvable;
    /**
     * `AWS::Glue::Crawler.Classifiers`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-classifiers
     * @external
     */
    readonly classifiers?: string[];
    /**
     * `AWS::Glue::Crawler.Configuration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-configuration
     * @external
     */
    readonly configuration?: string;
    /**
     * `AWS::Glue::Crawler.CrawlerSecurityConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-crawlersecurityconfiguration
     * @external
     */
    readonly crawlerSecurityConfiguration?: string;
    /**
     * `AWS::Glue::Crawler.DatabaseName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-databasename
     * @external
     */
    readonly databaseName?: string;
    /**
     * `AWS::Glue::Crawler.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::Glue::Crawler.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-name
     * @external
     */
    readonly name?: string;
    /**
     * `AWS::Glue::Crawler.Schedule`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-schedule
     * @external
     */
    readonly schedule?: CfnCrawler.ScheduleProperty | cdk.IResolvable;
    /**
     * `AWS::Glue::Crawler.SchemaChangePolicy`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-schemachangepolicy
     * @external
     */
    readonly schemaChangePolicy?: CfnCrawler.SchemaChangePolicyProperty | cdk.IResolvable;
    /**
     * `AWS::Glue::Crawler.TablePrefix`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-tableprefix
     * @external
     */
    readonly tablePrefix?: string;
    /**
     * `AWS::Glue::Crawler.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-tags
     * @external
     */
    readonly tags?: any;
}
/**
 * A CloudFormation `AWS::Glue::Crawler`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html
 * @external
 * @cloudformationResource AWS::Glue::Crawler
 */
export declare class CfnCrawler extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Glue::Crawler";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnCrawler;
    /**
     * `AWS::Glue::Crawler.Role`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-role
     * @external
     */
    role: string;
    /**
     * `AWS::Glue::Crawler.Targets`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-targets
     * @external
     */
    targets: CfnCrawler.TargetsProperty | cdk.IResolvable;
    /**
     * `AWS::Glue::Crawler.Classifiers`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-classifiers
     * @external
     */
    classifiers: string[] | undefined;
    /**
     * `AWS::Glue::Crawler.Configuration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-configuration
     * @external
     */
    configuration: string | undefined;
    /**
     * `AWS::Glue::Crawler.CrawlerSecurityConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-crawlersecurityconfiguration
     * @external
     */
    crawlerSecurityConfiguration: string | undefined;
    /**
     * `AWS::Glue::Crawler.DatabaseName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-databasename
     * @external
     */
    databaseName: string | undefined;
    /**
     * `AWS::Glue::Crawler.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::Glue::Crawler.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-name
     * @external
     */
    name: string | undefined;
    /**
     * `AWS::Glue::Crawler.Schedule`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-schedule
     * @external
     */
    schedule: CfnCrawler.ScheduleProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Glue::Crawler.SchemaChangePolicy`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-schemachangepolicy
     * @external
     */
    schemaChangePolicy: CfnCrawler.SchemaChangePolicyProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Glue::Crawler.TablePrefix`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-tableprefix
     * @external
     */
    tablePrefix: string | undefined;
    /**
     * `AWS::Glue::Crawler.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html#cfn-glue-crawler-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::Glue::Crawler`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnCrawlerProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Glue::Crawler`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html
 * @external
 * @cloudformationResource AWS::Glue::Crawler
 */
export declare namespace CfnCrawler {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-catalogtarget.html
     * @external
     */
    interface CatalogTargetProperty {
        /**
         * `CfnCrawler.CatalogTargetProperty.DatabaseName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-catalogtarget.html#cfn-glue-crawler-catalogtarget-databasename
         * @external
         */
        readonly databaseName?: string;
        /**
         * `CfnCrawler.CatalogTargetProperty.Tables`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-catalogtarget.html#cfn-glue-crawler-catalogtarget-tables
         * @external
         */
        readonly tables?: string[];
    }
}
/**
 * A CloudFormation `AWS::Glue::Crawler`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html
 * @external
 * @cloudformationResource AWS::Glue::Crawler
 */
export declare namespace CfnCrawler {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-dynamodbtarget.html
     * @external
     */
    interface DynamoDBTargetProperty {
        /**
         * `CfnCrawler.DynamoDBTargetProperty.Path`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-dynamodbtarget.html#cfn-glue-crawler-dynamodbtarget-path
         * @external
         */
        readonly path?: string;
    }
}
/**
 * A CloudFormation `AWS::Glue::Crawler`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html
 * @external
 * @cloudformationResource AWS::Glue::Crawler
 */
export declare namespace CfnCrawler {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-jdbctarget.html
     * @external
     */
    interface JdbcTargetProperty {
        /**
         * `CfnCrawler.JdbcTargetProperty.ConnectionName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-jdbctarget.html#cfn-glue-crawler-jdbctarget-connectionname
         * @external
         */
        readonly connectionName?: string;
        /**
         * `CfnCrawler.JdbcTargetProperty.Exclusions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-jdbctarget.html#cfn-glue-crawler-jdbctarget-exclusions
         * @external
         */
        readonly exclusions?: string[];
        /**
         * `CfnCrawler.JdbcTargetProperty.Path`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-jdbctarget.html#cfn-glue-crawler-jdbctarget-path
         * @external
         */
        readonly path?: string;
    }
}
/**
 * A CloudFormation `AWS::Glue::Crawler`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html
 * @external
 * @cloudformationResource AWS::Glue::Crawler
 */
export declare namespace CfnCrawler {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-s3target.html
     * @external
     */
    interface S3TargetProperty {
        /**
         * `CfnCrawler.S3TargetProperty.Exclusions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-s3target.html#cfn-glue-crawler-s3target-exclusions
         * @external
         */
        readonly exclusions?: string[];
        /**
         * `CfnCrawler.S3TargetProperty.Path`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-s3target.html#cfn-glue-crawler-s3target-path
         * @external
         */
        readonly path?: string;
    }
}
/**
 * A CloudFormation `AWS::Glue::Crawler`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html
 * @external
 * @cloudformationResource AWS::Glue::Crawler
 */
export declare namespace CfnCrawler {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-schedule.html
     * @external
     */
    interface ScheduleProperty {
        /**
         * `CfnCrawler.ScheduleProperty.ScheduleExpression`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-schedule.html#cfn-glue-crawler-schedule-scheduleexpression
         * @external
         */
        readonly scheduleExpression?: string;
    }
}
/**
 * A CloudFormation `AWS::Glue::Crawler`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html
 * @external
 * @cloudformationResource AWS::Glue::Crawler
 */
export declare namespace CfnCrawler {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-schemachangepolicy.html
     * @external
     */
    interface SchemaChangePolicyProperty {
        /**
         * `CfnCrawler.SchemaChangePolicyProperty.DeleteBehavior`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-schemachangepolicy.html#cfn-glue-crawler-schemachangepolicy-deletebehavior
         * @external
         */
        readonly deleteBehavior?: string;
        /**
         * `CfnCrawler.SchemaChangePolicyProperty.UpdateBehavior`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-schemachangepolicy.html#cfn-glue-crawler-schemachangepolicy-updatebehavior
         * @external
         */
        readonly updateBehavior?: string;
    }
}
/**
 * A CloudFormation `AWS::Glue::Crawler`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-crawler.html
 * @external
 * @cloudformationResource AWS::Glue::Crawler
 */
export declare namespace CfnCrawler {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-targets.html
     * @external
     */
    interface TargetsProperty {
        /**
         * `CfnCrawler.TargetsProperty.CatalogTargets`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-targets.html#cfn-glue-crawler-targets-catalogtargets
         * @external
         */
        readonly catalogTargets?: Array<CfnCrawler.CatalogTargetProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnCrawler.TargetsProperty.DynamoDBTargets`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-targets.html#cfn-glue-crawler-targets-dynamodbtargets
         * @external
         */
        readonly dynamoDbTargets?: Array<CfnCrawler.DynamoDBTargetProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnCrawler.TargetsProperty.JdbcTargets`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-targets.html#cfn-glue-crawler-targets-jdbctargets
         * @external
         */
        readonly jdbcTargets?: Array<CfnCrawler.JdbcTargetProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnCrawler.TargetsProperty.S3Targets`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-crawler-targets.html#cfn-glue-crawler-targets-s3targets
         * @external
         */
        readonly s3Targets?: Array<CfnCrawler.S3TargetProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * Properties for defining a `AWS::Glue::DataCatalogEncryptionSettings`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-datacatalogencryptionsettings.html
 * @external
 */
export interface CfnDataCatalogEncryptionSettingsProps {
    /**
     * `AWS::Glue::DataCatalogEncryptionSettings.CatalogId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-datacatalogencryptionsettings.html#cfn-glue-datacatalogencryptionsettings-catalogid
     * @external
     */
    readonly catalogId: string;
    /**
     * `AWS::Glue::DataCatalogEncryptionSettings.DataCatalogEncryptionSettings`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-datacatalogencryptionsettings.html#cfn-glue-datacatalogencryptionsettings-datacatalogencryptionsettings
     * @external
     */
    readonly dataCatalogEncryptionSettings: CfnDataCatalogEncryptionSettings.DataCatalogEncryptionSettingsProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Glue::DataCatalogEncryptionSettings`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-datacatalogencryptionsettings.html
 * @external
 * @cloudformationResource AWS::Glue::DataCatalogEncryptionSettings
 */
export declare class CfnDataCatalogEncryptionSettings extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Glue::DataCatalogEncryptionSettings";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnDataCatalogEncryptionSettings;
    /**
     * `AWS::Glue::DataCatalogEncryptionSettings.CatalogId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-datacatalogencryptionsettings.html#cfn-glue-datacatalogencryptionsettings-catalogid
     * @external
     */
    catalogId: string;
    /**
     * `AWS::Glue::DataCatalogEncryptionSettings.DataCatalogEncryptionSettings`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-datacatalogencryptionsettings.html#cfn-glue-datacatalogencryptionsettings-datacatalogencryptionsettings
     * @external
     */
    dataCatalogEncryptionSettings: CfnDataCatalogEncryptionSettings.DataCatalogEncryptionSettingsProperty | cdk.IResolvable;
    /**
     * Create a new `AWS::Glue::DataCatalogEncryptionSettings`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDataCatalogEncryptionSettingsProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Glue::DataCatalogEncryptionSettings`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-datacatalogencryptionsettings.html
 * @external
 * @cloudformationResource AWS::Glue::DataCatalogEncryptionSettings
 */
export declare namespace CfnDataCatalogEncryptionSettings {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-datacatalogencryptionsettings-connectionpasswordencryption.html
     * @external
     */
    interface ConnectionPasswordEncryptionProperty {
        /**
         * `CfnDataCatalogEncryptionSettings.ConnectionPasswordEncryptionProperty.KmsKeyId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-datacatalogencryptionsettings-connectionpasswordencryption.html#cfn-glue-datacatalogencryptionsettings-connectionpasswordencryption-kmskeyid
         * @external
         */
        readonly kmsKeyId?: string;
        /**
         * `CfnDataCatalogEncryptionSettings.ConnectionPasswordEncryptionProperty.ReturnConnectionPasswordEncrypted`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-datacatalogencryptionsettings-connectionpasswordencryption.html#cfn-glue-datacatalogencryptionsettings-connectionpasswordencryption-returnconnectionpasswordencrypted
         * @external
         */
        readonly returnConnectionPasswordEncrypted?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Glue::DataCatalogEncryptionSettings`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-datacatalogencryptionsettings.html
 * @external
 * @cloudformationResource AWS::Glue::DataCatalogEncryptionSettings
 */
export declare namespace CfnDataCatalogEncryptionSettings {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-datacatalogencryptionsettings-datacatalogencryptionsettings.html
     * @external
     */
    interface DataCatalogEncryptionSettingsProperty {
        /**
         * `CfnDataCatalogEncryptionSettings.DataCatalogEncryptionSettingsProperty.ConnectionPasswordEncryption`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-datacatalogencryptionsettings-datacatalogencryptionsettings.html#cfn-glue-datacatalogencryptionsettings-datacatalogencryptionsettings-connectionpasswordencryption
         * @external
         */
        readonly connectionPasswordEncryption?: CfnDataCatalogEncryptionSettings.ConnectionPasswordEncryptionProperty | cdk.IResolvable;
        /**
         * `CfnDataCatalogEncryptionSettings.DataCatalogEncryptionSettingsProperty.EncryptionAtRest`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-datacatalogencryptionsettings-datacatalogencryptionsettings.html#cfn-glue-datacatalogencryptionsettings-datacatalogencryptionsettings-encryptionatrest
         * @external
         */
        readonly encryptionAtRest?: CfnDataCatalogEncryptionSettings.EncryptionAtRestProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Glue::DataCatalogEncryptionSettings`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-datacatalogencryptionsettings.html
 * @external
 * @cloudformationResource AWS::Glue::DataCatalogEncryptionSettings
 */
export declare namespace CfnDataCatalogEncryptionSettings {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-datacatalogencryptionsettings-encryptionatrest.html
     * @external
     */
    interface EncryptionAtRestProperty {
        /**
         * `CfnDataCatalogEncryptionSettings.EncryptionAtRestProperty.CatalogEncryptionMode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-datacatalogencryptionsettings-encryptionatrest.html#cfn-glue-datacatalogencryptionsettings-encryptionatrest-catalogencryptionmode
         * @external
         */
        readonly catalogEncryptionMode?: string;
        /**
         * `CfnDataCatalogEncryptionSettings.EncryptionAtRestProperty.SseAwsKmsKeyId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-datacatalogencryptionsettings-encryptionatrest.html#cfn-glue-datacatalogencryptionsettings-encryptionatrest-sseawskmskeyid
         * @external
         */
        readonly sseAwsKmsKeyId?: string;
    }
}
/**
 * Properties for defining a `AWS::Glue::Database`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-database.html
 * @external
 */
export interface CfnDatabaseProps {
    /**
     * `AWS::Glue::Database.CatalogId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-database.html#cfn-glue-database-catalogid
     * @external
     */
    readonly catalogId: string;
    /**
     * `AWS::Glue::Database.DatabaseInput`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-database.html#cfn-glue-database-databaseinput
     * @external
     */
    readonly databaseInput: CfnDatabase.DatabaseInputProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Glue::Database`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-database.html
 * @external
 * @cloudformationResource AWS::Glue::Database
 */
export declare class CfnDatabase extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Glue::Database";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnDatabase;
    /**
     * `AWS::Glue::Database.CatalogId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-database.html#cfn-glue-database-catalogid
     * @external
     */
    catalogId: string;
    /**
     * `AWS::Glue::Database.DatabaseInput`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-database.html#cfn-glue-database-databaseinput
     * @external
     */
    databaseInput: CfnDatabase.DatabaseInputProperty | cdk.IResolvable;
    /**
     * Create a new `AWS::Glue::Database`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDatabaseProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Glue::Database`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-database.html
 * @external
 * @cloudformationResource AWS::Glue::Database
 */
export declare namespace CfnDatabase {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-database-databaseinput.html
     * @external
     */
    interface DatabaseInputProperty {
        /**
         * `CfnDatabase.DatabaseInputProperty.Description`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-database-databaseinput.html#cfn-glue-database-databaseinput-description
         * @external
         */
        readonly description?: string;
        /**
         * `CfnDatabase.DatabaseInputProperty.LocationUri`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-database-databaseinput.html#cfn-glue-database-databaseinput-locationuri
         * @external
         */
        readonly locationUri?: string;
        /**
         * `CfnDatabase.DatabaseInputProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-database-databaseinput.html#cfn-glue-database-databaseinput-name
         * @external
         */
        readonly name?: string;
        /**
         * `CfnDatabase.DatabaseInputProperty.Parameters`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-database-databaseinput.html#cfn-glue-database-databaseinput-parameters
         * @external
         */
        readonly parameters?: any | cdk.IResolvable;
    }
}
/**
 * Properties for defining a `AWS::Glue::DevEndpoint`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html
 * @external
 */
export interface CfnDevEndpointProps {
    /**
     * `AWS::Glue::DevEndpoint.RoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-rolearn
     * @external
     */
    readonly roleArn: string;
    /**
     * `AWS::Glue::DevEndpoint.Arguments`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-arguments
     * @external
     */
    readonly arguments?: any | cdk.IResolvable;
    /**
     * `AWS::Glue::DevEndpoint.EndpointName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-endpointname
     * @external
     */
    readonly endpointName?: string;
    /**
     * `AWS::Glue::DevEndpoint.ExtraJarsS3Path`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-extrajarss3path
     * @external
     */
    readonly extraJarsS3Path?: string;
    /**
     * `AWS::Glue::DevEndpoint.ExtraPythonLibsS3Path`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-extrapythonlibss3path
     * @external
     */
    readonly extraPythonLibsS3Path?: string;
    /**
     * `AWS::Glue::DevEndpoint.GlueVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-glueversion
     * @external
     */
    readonly glueVersion?: string;
    /**
     * `AWS::Glue::DevEndpoint.NumberOfNodes`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-numberofnodes
     * @external
     */
    readonly numberOfNodes?: number;
    /**
     * `AWS::Glue::DevEndpoint.NumberOfWorkers`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-numberofworkers
     * @external
     */
    readonly numberOfWorkers?: number;
    /**
     * `AWS::Glue::DevEndpoint.PublicKey`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-publickey
     * @external
     */
    readonly publicKey?: string;
    /**
     * `AWS::Glue::DevEndpoint.PublicKeys`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-publickeys
     * @external
     */
    readonly publicKeys?: string[];
    /**
     * `AWS::Glue::DevEndpoint.SecurityConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-securityconfiguration
     * @external
     */
    readonly securityConfiguration?: string;
    /**
     * `AWS::Glue::DevEndpoint.SecurityGroupIds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-securitygroupids
     * @external
     */
    readonly securityGroupIds?: string[];
    /**
     * `AWS::Glue::DevEndpoint.SubnetId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-subnetid
     * @external
     */
    readonly subnetId?: string;
    /**
     * `AWS::Glue::DevEndpoint.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-tags
     * @external
     */
    readonly tags?: any;
    /**
     * `AWS::Glue::DevEndpoint.WorkerType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-workertype
     * @external
     */
    readonly workerType?: string;
}
/**
 * A CloudFormation `AWS::Glue::DevEndpoint`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html
 * @external
 * @cloudformationResource AWS::Glue::DevEndpoint
 */
export declare class CfnDevEndpoint extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Glue::DevEndpoint";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnDevEndpoint;
    /**
     * `AWS::Glue::DevEndpoint.RoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-rolearn
     * @external
     */
    roleArn: string;
    /**
     * `AWS::Glue::DevEndpoint.Arguments`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-arguments
     * @external
     */
    arguments: any | cdk.IResolvable | undefined;
    /**
     * `AWS::Glue::DevEndpoint.EndpointName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-endpointname
     * @external
     */
    endpointName: string | undefined;
    /**
     * `AWS::Glue::DevEndpoint.ExtraJarsS3Path`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-extrajarss3path
     * @external
     */
    extraJarsS3Path: string | undefined;
    /**
     * `AWS::Glue::DevEndpoint.ExtraPythonLibsS3Path`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-extrapythonlibss3path
     * @external
     */
    extraPythonLibsS3Path: string | undefined;
    /**
     * `AWS::Glue::DevEndpoint.GlueVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-glueversion
     * @external
     */
    glueVersion: string | undefined;
    /**
     * `AWS::Glue::DevEndpoint.NumberOfNodes`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-numberofnodes
     * @external
     */
    numberOfNodes: number | undefined;
    /**
     * `AWS::Glue::DevEndpoint.NumberOfWorkers`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-numberofworkers
     * @external
     */
    numberOfWorkers: number | undefined;
    /**
     * `AWS::Glue::DevEndpoint.PublicKey`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-publickey
     * @external
     */
    publicKey: string | undefined;
    /**
     * `AWS::Glue::DevEndpoint.PublicKeys`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-publickeys
     * @external
     */
    publicKeys: string[] | undefined;
    /**
     * `AWS::Glue::DevEndpoint.SecurityConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-securityconfiguration
     * @external
     */
    securityConfiguration: string | undefined;
    /**
     * `AWS::Glue::DevEndpoint.SecurityGroupIds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-securitygroupids
     * @external
     */
    securityGroupIds: string[] | undefined;
    /**
     * `AWS::Glue::DevEndpoint.SubnetId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-subnetid
     * @external
     */
    subnetId: string | undefined;
    /**
     * `AWS::Glue::DevEndpoint.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::Glue::DevEndpoint.WorkerType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-devendpoint.html#cfn-glue-devendpoint-workertype
     * @external
     */
    workerType: string | undefined;
    /**
     * Create a new `AWS::Glue::DevEndpoint`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDevEndpointProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::Glue::Job`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html
 * @external
 */
export interface CfnJobProps {
    /**
     * `AWS::Glue::Job.Command`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-command
     * @external
     */
    readonly command: CfnJob.JobCommandProperty | cdk.IResolvable;
    /**
     * `AWS::Glue::Job.Role`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-role
     * @external
     */
    readonly role: string;
    /**
     * `AWS::Glue::Job.AllocatedCapacity`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-allocatedcapacity
     * @external
     */
    readonly allocatedCapacity?: number;
    /**
     * `AWS::Glue::Job.Connections`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-connections
     * @external
     */
    readonly connections?: CfnJob.ConnectionsListProperty | cdk.IResolvable;
    /**
     * `AWS::Glue::Job.DefaultArguments`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-defaultarguments
     * @external
     */
    readonly defaultArguments?: any | cdk.IResolvable;
    /**
     * `AWS::Glue::Job.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::Glue::Job.ExecutionProperty`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-executionproperty
     * @external
     */
    readonly executionProperty?: CfnJob.ExecutionPropertyProperty | cdk.IResolvable;
    /**
     * `AWS::Glue::Job.GlueVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-glueversion
     * @external
     */
    readonly glueVersion?: string;
    /**
     * `AWS::Glue::Job.LogUri`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-loguri
     * @external
     */
    readonly logUri?: string;
    /**
     * `AWS::Glue::Job.MaxCapacity`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-maxcapacity
     * @external
     */
    readonly maxCapacity?: number;
    /**
     * `AWS::Glue::Job.MaxRetries`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-maxretries
     * @external
     */
    readonly maxRetries?: number;
    /**
     * `AWS::Glue::Job.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-name
     * @external
     */
    readonly name?: string;
    /**
     * `AWS::Glue::Job.NotificationProperty`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-notificationproperty
     * @external
     */
    readonly notificationProperty?: CfnJob.NotificationPropertyProperty | cdk.IResolvable;
    /**
     * `AWS::Glue::Job.NumberOfWorkers`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-numberofworkers
     * @external
     */
    readonly numberOfWorkers?: number;
    /**
     * `AWS::Glue::Job.SecurityConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-securityconfiguration
     * @external
     */
    readonly securityConfiguration?: string;
    /**
     * `AWS::Glue::Job.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-tags
     * @external
     */
    readonly tags?: any;
    /**
     * `AWS::Glue::Job.Timeout`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-timeout
     * @external
     */
    readonly timeout?: number;
    /**
     * `AWS::Glue::Job.WorkerType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-workertype
     * @external
     */
    readonly workerType?: string;
}
/**
 * A CloudFormation `AWS::Glue::Job`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html
 * @external
 * @cloudformationResource AWS::Glue::Job
 */
export declare class CfnJob extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Glue::Job";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnJob;
    /**
     * `AWS::Glue::Job.Command`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-command
     * @external
     */
    command: CfnJob.JobCommandProperty | cdk.IResolvable;
    /**
     * `AWS::Glue::Job.Role`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-role
     * @external
     */
    role: string;
    /**
     * `AWS::Glue::Job.AllocatedCapacity`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-allocatedcapacity
     * @external
     */
    allocatedCapacity: number | undefined;
    /**
     * `AWS::Glue::Job.Connections`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-connections
     * @external
     */
    connections: CfnJob.ConnectionsListProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Glue::Job.DefaultArguments`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-defaultarguments
     * @external
     */
    defaultArguments: any | cdk.IResolvable | undefined;
    /**
     * `AWS::Glue::Job.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::Glue::Job.ExecutionProperty`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-executionproperty
     * @external
     */
    executionProperty: CfnJob.ExecutionPropertyProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Glue::Job.GlueVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-glueversion
     * @external
     */
    glueVersion: string | undefined;
    /**
     * `AWS::Glue::Job.LogUri`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-loguri
     * @external
     */
    logUri: string | undefined;
    /**
     * `AWS::Glue::Job.MaxCapacity`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-maxcapacity
     * @external
     */
    maxCapacity: number | undefined;
    /**
     * `AWS::Glue::Job.MaxRetries`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-maxretries
     * @external
     */
    maxRetries: number | undefined;
    /**
     * `AWS::Glue::Job.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-name
     * @external
     */
    name: string | undefined;
    /**
     * `AWS::Glue::Job.NotificationProperty`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-notificationproperty
     * @external
     */
    notificationProperty: CfnJob.NotificationPropertyProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Glue::Job.NumberOfWorkers`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-numberofworkers
     * @external
     */
    numberOfWorkers: number | undefined;
    /**
     * `AWS::Glue::Job.SecurityConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-securityconfiguration
     * @external
     */
    securityConfiguration: string | undefined;
    /**
     * `AWS::Glue::Job.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::Glue::Job.Timeout`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-timeout
     * @external
     */
    timeout: number | undefined;
    /**
     * `AWS::Glue::Job.WorkerType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-workertype
     * @external
     */
    workerType: string | undefined;
    /**
     * Create a new `AWS::Glue::Job`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnJobProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Glue::Job`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html
 * @external
 * @cloudformationResource AWS::Glue::Job
 */
export declare namespace CfnJob {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-job-connectionslist.html
     * @external
     */
    interface ConnectionsListProperty {
        /**
         * `CfnJob.ConnectionsListProperty.Connections`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-job-connectionslist.html#cfn-glue-job-connectionslist-connections
         * @external
         */
        readonly connections?: string[];
    }
}
/**
 * A CloudFormation `AWS::Glue::Job`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html
 * @external
 * @cloudformationResource AWS::Glue::Job
 */
export declare namespace CfnJob {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-job-executionproperty.html
     * @external
     */
    interface ExecutionPropertyProperty {
        /**
         * `CfnJob.ExecutionPropertyProperty.MaxConcurrentRuns`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-job-executionproperty.html#cfn-glue-job-executionproperty-maxconcurrentruns
         * @external
         */
        readonly maxConcurrentRuns?: number;
    }
}
/**
 * A CloudFormation `AWS::Glue::Job`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html
 * @external
 * @cloudformationResource AWS::Glue::Job
 */
export declare namespace CfnJob {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-job-jobcommand.html
     * @external
     */
    interface JobCommandProperty {
        /**
         * `CfnJob.JobCommandProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-job-jobcommand.html#cfn-glue-job-jobcommand-name
         * @external
         */
        readonly name?: string;
        /**
         * `CfnJob.JobCommandProperty.PythonVersion`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-job-jobcommand.html#cfn-glue-job-jobcommand-pythonversion
         * @external
         */
        readonly pythonVersion?: string;
        /**
         * `CfnJob.JobCommandProperty.ScriptLocation`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-job-jobcommand.html#cfn-glue-job-jobcommand-scriptlocation
         * @external
         */
        readonly scriptLocation?: string;
    }
}
/**
 * A CloudFormation `AWS::Glue::Job`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html
 * @external
 * @cloudformationResource AWS::Glue::Job
 */
export declare namespace CfnJob {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-job-notificationproperty.html
     * @external
     */
    interface NotificationPropertyProperty {
        /**
         * `CfnJob.NotificationPropertyProperty.NotifyDelayAfter`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-job-notificationproperty.html#cfn-glue-job-notificationproperty-notifydelayafter
         * @external
         */
        readonly notifyDelayAfter?: number;
    }
}
/**
 * Properties for defining a `AWS::Glue::MLTransform`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-mltransform.html
 * @external
 */
export interface CfnMLTransformProps {
    /**
     * `AWS::Glue::MLTransform.InputRecordTables`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-mltransform.html#cfn-glue-mltransform-inputrecordtables
     * @external
     */
    readonly inputRecordTables: CfnMLTransform.InputRecordTablesProperty | cdk.IResolvable;
    /**
     * `AWS::Glue::MLTransform.Role`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-mltransform.html#cfn-glue-mltransform-role
     * @external
     */
    readonly role: string;
    /**
     * `AWS::Glue::MLTransform.TransformParameters`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-mltransform.html#cfn-glue-mltransform-transformparameters
     * @external
     */
    readonly transformParameters: CfnMLTransform.TransformParametersProperty | cdk.IResolvable;
    /**
     * `AWS::Glue::MLTransform.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-mltransform.html#cfn-glue-mltransform-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::Glue::MLTransform.GlueVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-mltransform.html#cfn-glue-mltransform-glueversion
     * @external
     */
    readonly glueVersion?: string;
    /**
     * `AWS::Glue::MLTransform.MaxCapacity`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-mltransform.html#cfn-glue-mltransform-maxcapacity
     * @external
     */
    readonly maxCapacity?: number;
    /**
     * `AWS::Glue::MLTransform.MaxRetries`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-mltransform.html#cfn-glue-mltransform-maxretries
     * @external
     */
    readonly maxRetries?: number;
    /**
     * `AWS::Glue::MLTransform.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-mltransform.html#cfn-glue-mltransform-name
     * @external
     */
    readonly name?: string;
    /**
     * `AWS::Glue::MLTransform.NumberOfWorkers`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-mltransform.html#cfn-glue-mltransform-numberofworkers
     * @external
     */
    readonly numberOfWorkers?: number;
    /**
     * `AWS::Glue::MLTransform.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-mltransform.html#cfn-glue-mltransform-tags
     * @external
     */
    readonly tags?: any;
    /**
     * `AWS::Glue::MLTransform.Timeout`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-mltransform.html#cfn-glue-mltransform-timeout
     * @external
     */
    readonly timeout?: number;
    /**
     * `AWS::Glue::MLTransform.WorkerType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-mltransform.html#cfn-glue-mltransform-workertype
     * @external
     */
    readonly workerType?: string;
}
/**
 * A CloudFormation `AWS::Glue::MLTransform`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-mltransform.html
 * @external
 * @cloudformationResource AWS::Glue::MLTransform
 */
export declare class CfnMLTransform extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Glue::MLTransform";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnMLTransform;
    /**
     * `AWS::Glue::MLTransform.InputRecordTables`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-mltransform.html#cfn-glue-mltransform-inputrecordtables
     * @external
     */
    inputRecordTables: CfnMLTransform.InputRecordTablesProperty | cdk.IResolvable;
    /**
     * `AWS::Glue::MLTransform.Role`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-mltransform.html#cfn-glue-mltransform-role
     * @external
     */
    role: string;
    /**
     * `AWS::Glue::MLTransform.TransformParameters`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-mltransform.html#cfn-glue-mltransform-transformparameters
     * @external
     */
    transformParameters: CfnMLTransform.TransformParametersProperty | cdk.IResolvable;
    /**
     * `AWS::Glue::MLTransform.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-mltransform.html#cfn-glue-mltransform-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::Glue::MLTransform.GlueVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-mltransform.html#cfn-glue-mltransform-glueversion
     * @external
     */
    glueVersion: string | undefined;
    /**
     * `AWS::Glue::MLTransform.MaxCapacity`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-mltransform.html#cfn-glue-mltransform-maxcapacity
     * @external
     */
    maxCapacity: number | undefined;
    /**
     * `AWS::Glue::MLTransform.MaxRetries`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-mltransform.html#cfn-glue-mltransform-maxretries
     * @external
     */
    maxRetries: number | undefined;
    /**
     * `AWS::Glue::MLTransform.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-mltransform.html#cfn-glue-mltransform-name
     * @external
     */
    name: string | undefined;
    /**
     * `AWS::Glue::MLTransform.NumberOfWorkers`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-mltransform.html#cfn-glue-mltransform-numberofworkers
     * @external
     */
    numberOfWorkers: number | undefined;
    /**
     * `AWS::Glue::MLTransform.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-mltransform.html#cfn-glue-mltransform-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::Glue::MLTransform.Timeout`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-mltransform.html#cfn-glue-mltransform-timeout
     * @external
     */
    timeout: number | undefined;
    /**
     * `AWS::Glue::MLTransform.WorkerType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-mltransform.html#cfn-glue-mltransform-workertype
     * @external
     */
    workerType: string | undefined;
    /**
     * Create a new `AWS::Glue::MLTransform`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnMLTransformProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Glue::MLTransform`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-mltransform.html
 * @external
 * @cloudformationResource AWS::Glue::MLTransform
 */
export declare namespace CfnMLTransform {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-mltransform-transformparameters-findmatchesparameters.html
     * @external
     */
    interface FindMatchesParametersProperty {
        /**
         * `CfnMLTransform.FindMatchesParametersProperty.AccuracyCostTradeoff`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-mltransform-transformparameters-findmatchesparameters.html#cfn-glue-mltransform-transformparameters-findmatchesparameters-accuracycosttradeoff
         * @external
         */
        readonly accuracyCostTradeoff?: number;
        /**
         * `CfnMLTransform.FindMatchesParametersProperty.EnforceProvidedLabels`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-mltransform-transformparameters-findmatchesparameters.html#cfn-glue-mltransform-transformparameters-findmatchesparameters-enforceprovidedlabels
         * @external
         */
        readonly enforceProvidedLabels?: boolean | cdk.IResolvable;
        /**
         * `CfnMLTransform.FindMatchesParametersProperty.PrecisionRecallTradeoff`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-mltransform-transformparameters-findmatchesparameters.html#cfn-glue-mltransform-transformparameters-findmatchesparameters-precisionrecalltradeoff
         * @external
         */
        readonly precisionRecallTradeoff?: number;
        /**
         * `CfnMLTransform.FindMatchesParametersProperty.PrimaryKeyColumnName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-mltransform-transformparameters-findmatchesparameters.html#cfn-glue-mltransform-transformparameters-findmatchesparameters-primarykeycolumnname
         * @external
         */
        readonly primaryKeyColumnName: string;
    }
}
/**
 * A CloudFormation `AWS::Glue::MLTransform`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-mltransform.html
 * @external
 * @cloudformationResource AWS::Glue::MLTransform
 */
export declare namespace CfnMLTransform {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-mltransform-inputrecordtables-gluetables.html
     * @external
     */
    interface GlueTablesProperty {
        /**
         * `CfnMLTransform.GlueTablesProperty.CatalogId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-mltransform-inputrecordtables-gluetables.html#cfn-glue-mltransform-inputrecordtables-gluetables-catalogid
         * @external
         */
        readonly catalogId?: string;
        /**
         * `CfnMLTransform.GlueTablesProperty.ConnectionName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-mltransform-inputrecordtables-gluetables.html#cfn-glue-mltransform-inputrecordtables-gluetables-connectionname
         * @external
         */
        readonly connectionName?: string;
        /**
         * `CfnMLTransform.GlueTablesProperty.DatabaseName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-mltransform-inputrecordtables-gluetables.html#cfn-glue-mltransform-inputrecordtables-gluetables-databasename
         * @external
         */
        readonly databaseName: string;
        /**
         * `CfnMLTransform.GlueTablesProperty.TableName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-mltransform-inputrecordtables-gluetables.html#cfn-glue-mltransform-inputrecordtables-gluetables-tablename
         * @external
         */
        readonly tableName: string;
    }
}
/**
 * A CloudFormation `AWS::Glue::MLTransform`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-mltransform.html
 * @external
 * @cloudformationResource AWS::Glue::MLTransform
 */
export declare namespace CfnMLTransform {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-mltransform-inputrecordtables.html
     * @external
     */
    interface InputRecordTablesProperty {
        /**
         * `CfnMLTransform.InputRecordTablesProperty.GlueTables`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-mltransform-inputrecordtables.html#cfn-glue-mltransform-inputrecordtables-gluetables
         * @external
         */
        readonly glueTables?: Array<CfnMLTransform.GlueTablesProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Glue::MLTransform`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-mltransform.html
 * @external
 * @cloudformationResource AWS::Glue::MLTransform
 */
export declare namespace CfnMLTransform {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-mltransform-transformparameters.html
     * @external
     */
    interface TransformParametersProperty {
        /**
         * `CfnMLTransform.TransformParametersProperty.FindMatchesParameters`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-mltransform-transformparameters.html#cfn-glue-mltransform-transformparameters-findmatchesparameters
         * @external
         */
        readonly findMatchesParameters?: CfnMLTransform.FindMatchesParametersProperty | cdk.IResolvable;
        /**
         * `CfnMLTransform.TransformParametersProperty.TransformType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-mltransform-transformparameters.html#cfn-glue-mltransform-transformparameters-transformtype
         * @external
         */
        readonly transformType: string;
    }
}
/**
 * Properties for defining a `AWS::Glue::Partition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-partition.html
 * @external
 */
export interface CfnPartitionProps {
    /**
     * `AWS::Glue::Partition.CatalogId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-partition.html#cfn-glue-partition-catalogid
     * @external
     */
    readonly catalogId: string;
    /**
     * `AWS::Glue::Partition.DatabaseName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-partition.html#cfn-glue-partition-databasename
     * @external
     */
    readonly databaseName: string;
    /**
     * `AWS::Glue::Partition.PartitionInput`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-partition.html#cfn-glue-partition-partitioninput
     * @external
     */
    readonly partitionInput: CfnPartition.PartitionInputProperty | cdk.IResolvable;
    /**
     * `AWS::Glue::Partition.TableName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-partition.html#cfn-glue-partition-tablename
     * @external
     */
    readonly tableName: string;
}
/**
 * A CloudFormation `AWS::Glue::Partition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-partition.html
 * @external
 * @cloudformationResource AWS::Glue::Partition
 */
export declare class CfnPartition extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Glue::Partition";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnPartition;
    /**
     * `AWS::Glue::Partition.CatalogId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-partition.html#cfn-glue-partition-catalogid
     * @external
     */
    catalogId: string;
    /**
     * `AWS::Glue::Partition.DatabaseName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-partition.html#cfn-glue-partition-databasename
     * @external
     */
    databaseName: string;
    /**
     * `AWS::Glue::Partition.PartitionInput`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-partition.html#cfn-glue-partition-partitioninput
     * @external
     */
    partitionInput: CfnPartition.PartitionInputProperty | cdk.IResolvable;
    /**
     * `AWS::Glue::Partition.TableName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-partition.html#cfn-glue-partition-tablename
     * @external
     */
    tableName: string;
    /**
     * Create a new `AWS::Glue::Partition`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnPartitionProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Glue::Partition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-partition.html
 * @external
 * @cloudformationResource AWS::Glue::Partition
 */
export declare namespace CfnPartition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-column.html
     * @external
     */
    interface ColumnProperty {
        /**
         * `CfnPartition.ColumnProperty.Comment`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-column.html#cfn-glue-partition-column-comment
         * @external
         */
        readonly comment?: string;
        /**
         * `CfnPartition.ColumnProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-column.html#cfn-glue-partition-column-name
         * @external
         */
        readonly name: string;
        /**
         * `CfnPartition.ColumnProperty.Type`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-column.html#cfn-glue-partition-column-type
         * @external
         */
        readonly type?: string;
    }
}
/**
 * A CloudFormation `AWS::Glue::Partition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-partition.html
 * @external
 * @cloudformationResource AWS::Glue::Partition
 */
export declare namespace CfnPartition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-order.html
     * @external
     */
    interface OrderProperty {
        /**
         * `CfnPartition.OrderProperty.Column`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-order.html#cfn-glue-partition-order-column
         * @external
         */
        readonly column: string;
        /**
         * `CfnPartition.OrderProperty.SortOrder`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-order.html#cfn-glue-partition-order-sortorder
         * @external
         */
        readonly sortOrder?: number;
    }
}
/**
 * A CloudFormation `AWS::Glue::Partition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-partition.html
 * @external
 * @cloudformationResource AWS::Glue::Partition
 */
export declare namespace CfnPartition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-partitioninput.html
     * @external
     */
    interface PartitionInputProperty {
        /**
         * `CfnPartition.PartitionInputProperty.Parameters`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-partitioninput.html#cfn-glue-partition-partitioninput-parameters
         * @external
         */
        readonly parameters?: any | cdk.IResolvable;
        /**
         * `CfnPartition.PartitionInputProperty.StorageDescriptor`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-partitioninput.html#cfn-glue-partition-partitioninput-storagedescriptor
         * @external
         */
        readonly storageDescriptor?: CfnPartition.StorageDescriptorProperty | cdk.IResolvable;
        /**
         * `CfnPartition.PartitionInputProperty.Values`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-partitioninput.html#cfn-glue-partition-partitioninput-values
         * @external
         */
        readonly values: string[];
    }
}
/**
 * A CloudFormation `AWS::Glue::Partition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-partition.html
 * @external
 * @cloudformationResource AWS::Glue::Partition
 */
export declare namespace CfnPartition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-serdeinfo.html
     * @external
     */
    interface SerdeInfoProperty {
        /**
         * `CfnPartition.SerdeInfoProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-serdeinfo.html#cfn-glue-partition-serdeinfo-name
         * @external
         */
        readonly name?: string;
        /**
         * `CfnPartition.SerdeInfoProperty.Parameters`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-serdeinfo.html#cfn-glue-partition-serdeinfo-parameters
         * @external
         */
        readonly parameters?: any | cdk.IResolvable;
        /**
         * `CfnPartition.SerdeInfoProperty.SerializationLibrary`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-serdeinfo.html#cfn-glue-partition-serdeinfo-serializationlibrary
         * @external
         */
        readonly serializationLibrary?: string;
    }
}
/**
 * A CloudFormation `AWS::Glue::Partition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-partition.html
 * @external
 * @cloudformationResource AWS::Glue::Partition
 */
export declare namespace CfnPartition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-skewedinfo.html
     * @external
     */
    interface SkewedInfoProperty {
        /**
         * `CfnPartition.SkewedInfoProperty.SkewedColumnNames`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-skewedinfo.html#cfn-glue-partition-skewedinfo-skewedcolumnnames
         * @external
         */
        readonly skewedColumnNames?: string[];
        /**
         * `CfnPartition.SkewedInfoProperty.SkewedColumnValueLocationMaps`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-skewedinfo.html#cfn-glue-partition-skewedinfo-skewedcolumnvaluelocationmaps
         * @external
         */
        readonly skewedColumnValueLocationMaps?: any | cdk.IResolvable;
        /**
         * `CfnPartition.SkewedInfoProperty.SkewedColumnValues`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-skewedinfo.html#cfn-glue-partition-skewedinfo-skewedcolumnvalues
         * @external
         */
        readonly skewedColumnValues?: string[];
    }
}
/**
 * A CloudFormation `AWS::Glue::Partition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-partition.html
 * @external
 * @cloudformationResource AWS::Glue::Partition
 */
export declare namespace CfnPartition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-storagedescriptor.html
     * @external
     */
    interface StorageDescriptorProperty {
        /**
         * `CfnPartition.StorageDescriptorProperty.BucketColumns`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-storagedescriptor.html#cfn-glue-partition-storagedescriptor-bucketcolumns
         * @external
         */
        readonly bucketColumns?: string[];
        /**
         * `CfnPartition.StorageDescriptorProperty.Columns`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-storagedescriptor.html#cfn-glue-partition-storagedescriptor-columns
         * @external
         */
        readonly columns?: Array<CfnPartition.ColumnProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnPartition.StorageDescriptorProperty.Compressed`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-storagedescriptor.html#cfn-glue-partition-storagedescriptor-compressed
         * @external
         */
        readonly compressed?: boolean | cdk.IResolvable;
        /**
         * `CfnPartition.StorageDescriptorProperty.InputFormat`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-storagedescriptor.html#cfn-glue-partition-storagedescriptor-inputformat
         * @external
         */
        readonly inputFormat?: string;
        /**
         * `CfnPartition.StorageDescriptorProperty.Location`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-storagedescriptor.html#cfn-glue-partition-storagedescriptor-location
         * @external
         */
        readonly location?: string;
        /**
         * `CfnPartition.StorageDescriptorProperty.NumberOfBuckets`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-storagedescriptor.html#cfn-glue-partition-storagedescriptor-numberofbuckets
         * @external
         */
        readonly numberOfBuckets?: number;
        /**
         * `CfnPartition.StorageDescriptorProperty.OutputFormat`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-storagedescriptor.html#cfn-glue-partition-storagedescriptor-outputformat
         * @external
         */
        readonly outputFormat?: string;
        /**
         * `CfnPartition.StorageDescriptorProperty.Parameters`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-storagedescriptor.html#cfn-glue-partition-storagedescriptor-parameters
         * @external
         */
        readonly parameters?: any | cdk.IResolvable;
        /**
         * `CfnPartition.StorageDescriptorProperty.SerdeInfo`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-storagedescriptor.html#cfn-glue-partition-storagedescriptor-serdeinfo
         * @external
         */
        readonly serdeInfo?: CfnPartition.SerdeInfoProperty | cdk.IResolvable;
        /**
         * `CfnPartition.StorageDescriptorProperty.SkewedInfo`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-storagedescriptor.html#cfn-glue-partition-storagedescriptor-skewedinfo
         * @external
         */
        readonly skewedInfo?: CfnPartition.SkewedInfoProperty | cdk.IResolvable;
        /**
         * `CfnPartition.StorageDescriptorProperty.SortColumns`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-storagedescriptor.html#cfn-glue-partition-storagedescriptor-sortcolumns
         * @external
         */
        readonly sortColumns?: Array<CfnPartition.OrderProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnPartition.StorageDescriptorProperty.StoredAsSubDirectories`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-partition-storagedescriptor.html#cfn-glue-partition-storagedescriptor-storedassubdirectories
         * @external
         */
        readonly storedAsSubDirectories?: boolean | cdk.IResolvable;
    }
}
/**
 * Properties for defining a `AWS::Glue::SecurityConfiguration`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-securityconfiguration.html
 * @external
 */
export interface CfnSecurityConfigurationProps {
    /**
     * `AWS::Glue::SecurityConfiguration.EncryptionConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-securityconfiguration.html#cfn-glue-securityconfiguration-encryptionconfiguration
     * @external
     */
    readonly encryptionConfiguration: CfnSecurityConfiguration.EncryptionConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::Glue::SecurityConfiguration.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-securityconfiguration.html#cfn-glue-securityconfiguration-name
     * @external
     */
    readonly name: string;
}
/**
 * A CloudFormation `AWS::Glue::SecurityConfiguration`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-securityconfiguration.html
 * @external
 * @cloudformationResource AWS::Glue::SecurityConfiguration
 */
export declare class CfnSecurityConfiguration extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Glue::SecurityConfiguration";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnSecurityConfiguration;
    /**
     * `AWS::Glue::SecurityConfiguration.EncryptionConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-securityconfiguration.html#cfn-glue-securityconfiguration-encryptionconfiguration
     * @external
     */
    encryptionConfiguration: CfnSecurityConfiguration.EncryptionConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::Glue::SecurityConfiguration.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-securityconfiguration.html#cfn-glue-securityconfiguration-name
     * @external
     */
    name: string;
    /**
     * Create a new `AWS::Glue::SecurityConfiguration`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnSecurityConfigurationProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Glue::SecurityConfiguration`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-securityconfiguration.html
 * @external
 * @cloudformationResource AWS::Glue::SecurityConfiguration
 */
export declare namespace CfnSecurityConfiguration {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-securityconfiguration-cloudwatchencryption.html
     * @external
     */
    interface CloudWatchEncryptionProperty {
        /**
         * `CfnSecurityConfiguration.CloudWatchEncryptionProperty.CloudWatchEncryptionMode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-securityconfiguration-cloudwatchencryption.html#cfn-glue-securityconfiguration-cloudwatchencryption-cloudwatchencryptionmode
         * @external
         */
        readonly cloudWatchEncryptionMode?: string;
        /**
         * `CfnSecurityConfiguration.CloudWatchEncryptionProperty.KmsKeyArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-securityconfiguration-cloudwatchencryption.html#cfn-glue-securityconfiguration-cloudwatchencryption-kmskeyarn
         * @external
         */
        readonly kmsKeyArn?: string;
    }
}
/**
 * A CloudFormation `AWS::Glue::SecurityConfiguration`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-securityconfiguration.html
 * @external
 * @cloudformationResource AWS::Glue::SecurityConfiguration
 */
export declare namespace CfnSecurityConfiguration {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-securityconfiguration-encryptionconfiguration.html
     * @external
     */
    interface EncryptionConfigurationProperty {
        /**
         * `CfnSecurityConfiguration.EncryptionConfigurationProperty.CloudWatchEncryption`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-securityconfiguration-encryptionconfiguration.html#cfn-glue-securityconfiguration-encryptionconfiguration-cloudwatchencryption
         * @external
         */
        readonly cloudWatchEncryption?: CfnSecurityConfiguration.CloudWatchEncryptionProperty | cdk.IResolvable;
        /**
         * `CfnSecurityConfiguration.EncryptionConfigurationProperty.JobBookmarksEncryption`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-securityconfiguration-encryptionconfiguration.html#cfn-glue-securityconfiguration-encryptionconfiguration-jobbookmarksencryption
         * @external
         */
        readonly jobBookmarksEncryption?: CfnSecurityConfiguration.JobBookmarksEncryptionProperty | cdk.IResolvable;
        /**
         * `CfnSecurityConfiguration.EncryptionConfigurationProperty.S3Encryptions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-securityconfiguration-encryptionconfiguration.html#cfn-glue-securityconfiguration-encryptionconfiguration-s3encryptions
         * @external
         */
        readonly s3Encryptions?: Array<CfnSecurityConfiguration.S3EncryptionProperty | cdk.IResolvable> | cdk.IResolvable | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Glue::SecurityConfiguration`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-securityconfiguration.html
 * @external
 * @cloudformationResource AWS::Glue::SecurityConfiguration
 */
export declare namespace CfnSecurityConfiguration {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-securityconfiguration-jobbookmarksencryption.html
     * @external
     */
    interface JobBookmarksEncryptionProperty {
        /**
         * `CfnSecurityConfiguration.JobBookmarksEncryptionProperty.JobBookmarksEncryptionMode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-securityconfiguration-jobbookmarksencryption.html#cfn-glue-securityconfiguration-jobbookmarksencryption-jobbookmarksencryptionmode
         * @external
         */
        readonly jobBookmarksEncryptionMode?: string;
        /**
         * `CfnSecurityConfiguration.JobBookmarksEncryptionProperty.KmsKeyArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-securityconfiguration-jobbookmarksencryption.html#cfn-glue-securityconfiguration-jobbookmarksencryption-kmskeyarn
         * @external
         */
        readonly kmsKeyArn?: string;
    }
}
/**
 * A CloudFormation `AWS::Glue::SecurityConfiguration`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-securityconfiguration.html
 * @external
 * @cloudformationResource AWS::Glue::SecurityConfiguration
 */
export declare namespace CfnSecurityConfiguration {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-securityconfiguration-s3encryption.html
     * @external
     */
    interface S3EncryptionProperty {
        /**
         * `CfnSecurityConfiguration.S3EncryptionProperty.KmsKeyArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-securityconfiguration-s3encryption.html#cfn-glue-securityconfiguration-s3encryption-kmskeyarn
         * @external
         */
        readonly kmsKeyArn?: string;
        /**
         * `CfnSecurityConfiguration.S3EncryptionProperty.S3EncryptionMode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-securityconfiguration-s3encryption.html#cfn-glue-securityconfiguration-s3encryption-s3encryptionmode
         * @external
         */
        readonly s3EncryptionMode?: string;
    }
}
/**
 * Properties for defining a `AWS::Glue::Table`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-table.html
 * @external
 */
export interface CfnTableProps {
    /**
     * `AWS::Glue::Table.CatalogId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-table.html#cfn-glue-table-catalogid
     * @external
     */
    readonly catalogId: string;
    /**
     * `AWS::Glue::Table.DatabaseName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-table.html#cfn-glue-table-databasename
     * @external
     */
    readonly databaseName: string;
    /**
     * `AWS::Glue::Table.TableInput`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-table.html#cfn-glue-table-tableinput
     * @external
     */
    readonly tableInput: CfnTable.TableInputProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Glue::Table`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-table.html
 * @external
 * @cloudformationResource AWS::Glue::Table
 */
export declare class CfnTable extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Glue::Table";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnTable;
    /**
     * `AWS::Glue::Table.CatalogId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-table.html#cfn-glue-table-catalogid
     * @external
     */
    catalogId: string;
    /**
     * `AWS::Glue::Table.DatabaseName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-table.html#cfn-glue-table-databasename
     * @external
     */
    databaseName: string;
    /**
     * `AWS::Glue::Table.TableInput`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-table.html#cfn-glue-table-tableinput
     * @external
     */
    tableInput: CfnTable.TableInputProperty | cdk.IResolvable;
    /**
     * Create a new `AWS::Glue::Table`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnTableProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Glue::Table`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-table.html
 * @external
 * @cloudformationResource AWS::Glue::Table
 */
export declare namespace CfnTable {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-column.html
     * @external
     */
    interface ColumnProperty {
        /**
         * `CfnTable.ColumnProperty.Comment`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-column.html#cfn-glue-table-column-comment
         * @external
         */
        readonly comment?: string;
        /**
         * `CfnTable.ColumnProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-column.html#cfn-glue-table-column-name
         * @external
         */
        readonly name: string;
        /**
         * `CfnTable.ColumnProperty.Type`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-column.html#cfn-glue-table-column-type
         * @external
         */
        readonly type?: string;
    }
}
/**
 * A CloudFormation `AWS::Glue::Table`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-table.html
 * @external
 * @cloudformationResource AWS::Glue::Table
 */
export declare namespace CfnTable {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-order.html
     * @external
     */
    interface OrderProperty {
        /**
         * `CfnTable.OrderProperty.Column`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-order.html#cfn-glue-table-order-column
         * @external
         */
        readonly column: string;
        /**
         * `CfnTable.OrderProperty.SortOrder`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-order.html#cfn-glue-table-order-sortorder
         * @external
         */
        readonly sortOrder: number;
    }
}
/**
 * A CloudFormation `AWS::Glue::Table`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-table.html
 * @external
 * @cloudformationResource AWS::Glue::Table
 */
export declare namespace CfnTable {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-serdeinfo.html
     * @external
     */
    interface SerdeInfoProperty {
        /**
         * `CfnTable.SerdeInfoProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-serdeinfo.html#cfn-glue-table-serdeinfo-name
         * @external
         */
        readonly name?: string;
        /**
         * `CfnTable.SerdeInfoProperty.Parameters`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-serdeinfo.html#cfn-glue-table-serdeinfo-parameters
         * @external
         */
        readonly parameters?: any | cdk.IResolvable;
        /**
         * `CfnTable.SerdeInfoProperty.SerializationLibrary`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-serdeinfo.html#cfn-glue-table-serdeinfo-serializationlibrary
         * @external
         */
        readonly serializationLibrary?: string;
    }
}
/**
 * A CloudFormation `AWS::Glue::Table`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-table.html
 * @external
 * @cloudformationResource AWS::Glue::Table
 */
export declare namespace CfnTable {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-skewedinfo.html
     * @external
     */
    interface SkewedInfoProperty {
        /**
         * `CfnTable.SkewedInfoProperty.SkewedColumnNames`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-skewedinfo.html#cfn-glue-table-skewedinfo-skewedcolumnnames
         * @external
         */
        readonly skewedColumnNames?: string[];
        /**
         * `CfnTable.SkewedInfoProperty.SkewedColumnValueLocationMaps`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-skewedinfo.html#cfn-glue-table-skewedinfo-skewedcolumnvaluelocationmaps
         * @external
         */
        readonly skewedColumnValueLocationMaps?: any | cdk.IResolvable;
        /**
         * `CfnTable.SkewedInfoProperty.SkewedColumnValues`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-skewedinfo.html#cfn-glue-table-skewedinfo-skewedcolumnvalues
         * @external
         */
        readonly skewedColumnValues?: string[];
    }
}
/**
 * A CloudFormation `AWS::Glue::Table`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-table.html
 * @external
 * @cloudformationResource AWS::Glue::Table
 */
export declare namespace CfnTable {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-storagedescriptor.html
     * @external
     */
    interface StorageDescriptorProperty {
        /**
         * `CfnTable.StorageDescriptorProperty.BucketColumns`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-storagedescriptor.html#cfn-glue-table-storagedescriptor-bucketcolumns
         * @external
         */
        readonly bucketColumns?: string[];
        /**
         * `CfnTable.StorageDescriptorProperty.Columns`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-storagedescriptor.html#cfn-glue-table-storagedescriptor-columns
         * @external
         */
        readonly columns?: Array<CfnTable.ColumnProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnTable.StorageDescriptorProperty.Compressed`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-storagedescriptor.html#cfn-glue-table-storagedescriptor-compressed
         * @external
         */
        readonly compressed?: boolean | cdk.IResolvable;
        /**
         * `CfnTable.StorageDescriptorProperty.InputFormat`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-storagedescriptor.html#cfn-glue-table-storagedescriptor-inputformat
         * @external
         */
        readonly inputFormat?: string;
        /**
         * `CfnTable.StorageDescriptorProperty.Location`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-storagedescriptor.html#cfn-glue-table-storagedescriptor-location
         * @external
         */
        readonly location?: string;
        /**
         * `CfnTable.StorageDescriptorProperty.NumberOfBuckets`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-storagedescriptor.html#cfn-glue-table-storagedescriptor-numberofbuckets
         * @external
         */
        readonly numberOfBuckets?: number;
        /**
         * `CfnTable.StorageDescriptorProperty.OutputFormat`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-storagedescriptor.html#cfn-glue-table-storagedescriptor-outputformat
         * @external
         */
        readonly outputFormat?: string;
        /**
         * `CfnTable.StorageDescriptorProperty.Parameters`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-storagedescriptor.html#cfn-glue-table-storagedescriptor-parameters
         * @external
         */
        readonly parameters?: any | cdk.IResolvable;
        /**
         * `CfnTable.StorageDescriptorProperty.SerdeInfo`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-storagedescriptor.html#cfn-glue-table-storagedescriptor-serdeinfo
         * @external
         */
        readonly serdeInfo?: CfnTable.SerdeInfoProperty | cdk.IResolvable;
        /**
         * `CfnTable.StorageDescriptorProperty.SkewedInfo`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-storagedescriptor.html#cfn-glue-table-storagedescriptor-skewedinfo
         * @external
         */
        readonly skewedInfo?: CfnTable.SkewedInfoProperty | cdk.IResolvable;
        /**
         * `CfnTable.StorageDescriptorProperty.SortColumns`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-storagedescriptor.html#cfn-glue-table-storagedescriptor-sortcolumns
         * @external
         */
        readonly sortColumns?: Array<CfnTable.OrderProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnTable.StorageDescriptorProperty.StoredAsSubDirectories`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-storagedescriptor.html#cfn-glue-table-storagedescriptor-storedassubdirectories
         * @external
         */
        readonly storedAsSubDirectories?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Glue::Table`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-table.html
 * @external
 * @cloudformationResource AWS::Glue::Table
 */
export declare namespace CfnTable {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-tableinput.html
     * @external
     */
    interface TableInputProperty {
        /**
         * `CfnTable.TableInputProperty.Description`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-tableinput.html#cfn-glue-table-tableinput-description
         * @external
         */
        readonly description?: string;
        /**
         * `CfnTable.TableInputProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-tableinput.html#cfn-glue-table-tableinput-name
         * @external
         */
        readonly name?: string;
        /**
         * `CfnTable.TableInputProperty.Owner`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-tableinput.html#cfn-glue-table-tableinput-owner
         * @external
         */
        readonly owner?: string;
        /**
         * `CfnTable.TableInputProperty.Parameters`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-tableinput.html#cfn-glue-table-tableinput-parameters
         * @external
         */
        readonly parameters?: any | cdk.IResolvable;
        /**
         * `CfnTable.TableInputProperty.PartitionKeys`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-tableinput.html#cfn-glue-table-tableinput-partitionkeys
         * @external
         */
        readonly partitionKeys?: Array<CfnTable.ColumnProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnTable.TableInputProperty.Retention`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-tableinput.html#cfn-glue-table-tableinput-retention
         * @external
         */
        readonly retention?: number;
        /**
         * `CfnTable.TableInputProperty.StorageDescriptor`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-tableinput.html#cfn-glue-table-tableinput-storagedescriptor
         * @external
         */
        readonly storageDescriptor?: CfnTable.StorageDescriptorProperty | cdk.IResolvable;
        /**
         * `CfnTable.TableInputProperty.TableType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-tableinput.html#cfn-glue-table-tableinput-tabletype
         * @external
         */
        readonly tableType?: string;
        /**
         * `CfnTable.TableInputProperty.ViewExpandedText`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-tableinput.html#cfn-glue-table-tableinput-viewexpandedtext
         * @external
         */
        readonly viewExpandedText?: string;
        /**
         * `CfnTable.TableInputProperty.ViewOriginalText`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-tableinput.html#cfn-glue-table-tableinput-vieworiginaltext
         * @external
         */
        readonly viewOriginalText?: string;
    }
}
/**
 * Properties for defining a `AWS::Glue::Trigger`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-trigger.html
 * @external
 */
export interface CfnTriggerProps {
    /**
     * `AWS::Glue::Trigger.Actions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-trigger.html#cfn-glue-trigger-actions
     * @external
     */
    readonly actions: Array<CfnTrigger.ActionProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::Glue::Trigger.Type`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-trigger.html#cfn-glue-trigger-type
     * @external
     */
    readonly type: string;
    /**
     * `AWS::Glue::Trigger.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-trigger.html#cfn-glue-trigger-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::Glue::Trigger.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-trigger.html#cfn-glue-trigger-name
     * @external
     */
    readonly name?: string;
    /**
     * `AWS::Glue::Trigger.Predicate`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-trigger.html#cfn-glue-trigger-predicate
     * @external
     */
    readonly predicate?: CfnTrigger.PredicateProperty | cdk.IResolvable;
    /**
     * `AWS::Glue::Trigger.Schedule`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-trigger.html#cfn-glue-trigger-schedule
     * @external
     */
    readonly schedule?: string;
    /**
     * `AWS::Glue::Trigger.StartOnCreation`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-trigger.html#cfn-glue-trigger-startoncreation
     * @external
     */
    readonly startOnCreation?: boolean | cdk.IResolvable;
    /**
     * `AWS::Glue::Trigger.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-trigger.html#cfn-glue-trigger-tags
     * @external
     */
    readonly tags?: any;
    /**
     * `AWS::Glue::Trigger.WorkflowName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-trigger.html#cfn-glue-trigger-workflowname
     * @external
     */
    readonly workflowName?: string;
}
/**
 * A CloudFormation `AWS::Glue::Trigger`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-trigger.html
 * @external
 * @cloudformationResource AWS::Glue::Trigger
 */
export declare class CfnTrigger extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Glue::Trigger";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnTrigger;
    /**
     * `AWS::Glue::Trigger.Actions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-trigger.html#cfn-glue-trigger-actions
     * @external
     */
    actions: Array<CfnTrigger.ActionProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::Glue::Trigger.Type`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-trigger.html#cfn-glue-trigger-type
     * @external
     */
    type: string;
    /**
     * `AWS::Glue::Trigger.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-trigger.html#cfn-glue-trigger-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::Glue::Trigger.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-trigger.html#cfn-glue-trigger-name
     * @external
     */
    name: string | undefined;
    /**
     * `AWS::Glue::Trigger.Predicate`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-trigger.html#cfn-glue-trigger-predicate
     * @external
     */
    predicate: CfnTrigger.PredicateProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Glue::Trigger.Schedule`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-trigger.html#cfn-glue-trigger-schedule
     * @external
     */
    schedule: string | undefined;
    /**
     * `AWS::Glue::Trigger.StartOnCreation`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-trigger.html#cfn-glue-trigger-startoncreation
     * @external
     */
    startOnCreation: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::Glue::Trigger.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-trigger.html#cfn-glue-trigger-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::Glue::Trigger.WorkflowName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-trigger.html#cfn-glue-trigger-workflowname
     * @external
     */
    workflowName: string | undefined;
    /**
     * Create a new `AWS::Glue::Trigger`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnTriggerProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Glue::Trigger`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-trigger.html
 * @external
 * @cloudformationResource AWS::Glue::Trigger
 */
export declare namespace CfnTrigger {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-trigger-action.html
     * @external
     */
    interface ActionProperty {
        /**
         * `CfnTrigger.ActionProperty.Arguments`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-trigger-action.html#cfn-glue-trigger-action-arguments
         * @external
         */
        readonly arguments?: any | cdk.IResolvable;
        /**
         * `CfnTrigger.ActionProperty.CrawlerName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-trigger-action.html#cfn-glue-trigger-action-crawlername
         * @external
         */
        readonly crawlerName?: string;
        /**
         * `CfnTrigger.ActionProperty.JobName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-trigger-action.html#cfn-glue-trigger-action-jobname
         * @external
         */
        readonly jobName?: string;
        /**
         * `CfnTrigger.ActionProperty.NotificationProperty`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-trigger-action.html#cfn-glue-trigger-action-notificationproperty
         * @external
         */
        readonly notificationProperty?: CfnTrigger.NotificationPropertyProperty | cdk.IResolvable;
        /**
         * `CfnTrigger.ActionProperty.SecurityConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-trigger-action.html#cfn-glue-trigger-action-securityconfiguration
         * @external
         */
        readonly securityConfiguration?: string;
        /**
         * `CfnTrigger.ActionProperty.Timeout`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-trigger-action.html#cfn-glue-trigger-action-timeout
         * @external
         */
        readonly timeout?: number;
    }
}
/**
 * A CloudFormation `AWS::Glue::Trigger`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-trigger.html
 * @external
 * @cloudformationResource AWS::Glue::Trigger
 */
export declare namespace CfnTrigger {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-trigger-condition.html
     * @external
     */
    interface ConditionProperty {
        /**
         * `CfnTrigger.ConditionProperty.CrawlState`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-trigger-condition.html#cfn-glue-trigger-condition-crawlstate
         * @external
         */
        readonly crawlState?: string;
        /**
         * `CfnTrigger.ConditionProperty.CrawlerName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-trigger-condition.html#cfn-glue-trigger-condition-crawlername
         * @external
         */
        readonly crawlerName?: string;
        /**
         * `CfnTrigger.ConditionProperty.JobName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-trigger-condition.html#cfn-glue-trigger-condition-jobname
         * @external
         */
        readonly jobName?: string;
        /**
         * `CfnTrigger.ConditionProperty.LogicalOperator`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-trigger-condition.html#cfn-glue-trigger-condition-logicaloperator
         * @external
         */
        readonly logicalOperator?: string;
        /**
         * `CfnTrigger.ConditionProperty.State`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-trigger-condition.html#cfn-glue-trigger-condition-state
         * @external
         */
        readonly state?: string;
    }
}
/**
 * A CloudFormation `AWS::Glue::Trigger`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-trigger.html
 * @external
 * @cloudformationResource AWS::Glue::Trigger
 */
export declare namespace CfnTrigger {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-trigger-notificationproperty.html
     * @external
     */
    interface NotificationPropertyProperty {
        /**
         * `CfnTrigger.NotificationPropertyProperty.NotifyDelayAfter`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-trigger-notificationproperty.html#cfn-glue-trigger-notificationproperty-notifydelayafter
         * @external
         */
        readonly notifyDelayAfter?: number;
    }
}
/**
 * A CloudFormation `AWS::Glue::Trigger`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-trigger.html
 * @external
 * @cloudformationResource AWS::Glue::Trigger
 */
export declare namespace CfnTrigger {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-trigger-predicate.html
     * @external
     */
    interface PredicateProperty {
        /**
         * `CfnTrigger.PredicateProperty.Conditions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-trigger-predicate.html#cfn-glue-trigger-predicate-conditions
         * @external
         */
        readonly conditions?: Array<CfnTrigger.ConditionProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnTrigger.PredicateProperty.Logical`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-trigger-predicate.html#cfn-glue-trigger-predicate-logical
         * @external
         */
        readonly logical?: string;
    }
}
/**
 * Properties for defining a `AWS::Glue::Workflow`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-workflow.html
 * @external
 */
export interface CfnWorkflowProps {
    /**
     * `AWS::Glue::Workflow.DefaultRunProperties`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-workflow.html#cfn-glue-workflow-defaultrunproperties
     * @external
     */
    readonly defaultRunProperties?: any | cdk.IResolvable;
    /**
     * `AWS::Glue::Workflow.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-workflow.html#cfn-glue-workflow-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::Glue::Workflow.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-workflow.html#cfn-glue-workflow-name
     * @external
     */
    readonly name?: string;
    /**
     * `AWS::Glue::Workflow.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-workflow.html#cfn-glue-workflow-tags
     * @external
     */
    readonly tags?: any;
}
/**
 * A CloudFormation `AWS::Glue::Workflow`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-workflow.html
 * @external
 * @cloudformationResource AWS::Glue::Workflow
 */
export declare class CfnWorkflow extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Glue::Workflow";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnWorkflow;
    /**
     * `AWS::Glue::Workflow.DefaultRunProperties`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-workflow.html#cfn-glue-workflow-defaultrunproperties
     * @external
     */
    defaultRunProperties: any | cdk.IResolvable | undefined;
    /**
     * `AWS::Glue::Workflow.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-workflow.html#cfn-glue-workflow-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::Glue::Workflow.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-workflow.html#cfn-glue-workflow-name
     * @external
     */
    name: string | undefined;
    /**
     * `AWS::Glue::Workflow.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-workflow.html#cfn-glue-workflow-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::Glue::Workflow`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnWorkflowProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
