"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Listener = exports.ClientAffinity = exports.ConnectionProtocol = void 0;
const cdk = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const ga = require("./globalaccelerator.generated");
/**
 * (experimental) The protocol for the connections from clients to the accelerator.
 *
 * @experimental
 */
var ConnectionProtocol;
(function (ConnectionProtocol) {
    ConnectionProtocol["TCP"] = "TCP";
    ConnectionProtocol["UDP"] = "UDP";
})(ConnectionProtocol = exports.ConnectionProtocol || (exports.ConnectionProtocol = {}));
/**
 * (experimental) Client affinity lets you direct all requests from a user to the same endpoint, if you have stateful applications, regardless of the port and protocol of the client request.
 *
 * Client affinity gives you control over whether to always
 * route each client to the same specific endpoint. If you want a given client to always be routed to the same
 * endpoint, set client affinity to SOURCE_IP.
 *
 * @see https://docs.aws.amazon.com/global-accelerator/latest/dg/about-listeners.html#about-listeners-client-affinity
 * @experimental
 */
var ClientAffinity;
(function (ClientAffinity) {
    ClientAffinity["NONE"] = "NONE";
    ClientAffinity["SOURCE_IP"] = "SOURCE_IP";
})(ClientAffinity = exports.ClientAffinity || (exports.ClientAffinity = {}));
/**
 * (experimental) The construct for the Listener.
 *
 * @experimental
 */
class Listener extends cdk.Resource {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _a, _b, _c;
        super(scope, id);
        const resource = new ga.CfnListener(this, 'Resource', {
            acceleratorArn: props.accelerator.acceleratorArn,
            portRanges: props.portRanges.map(m => ({
                fromPort: m.fromPort,
                toPort: m.toPort,
            })),
            protocol: (_a = props.protocol) !== null && _a !== void 0 ? _a : ConnectionProtocol.TCP,
            clientAffinity: (_b = props.clientAffinity) !== null && _b !== void 0 ? _b : ClientAffinity.NONE,
        });
        this.listenerArn = resource.attrListenerArn;
        this.listenerName = (_c = props.listenerName) !== null && _c !== void 0 ? _c : resource.logicalId;
    }
    /**
     * (experimental) import from ARN.
     *
     * @experimental
     */
    static fromListenerArn(scope, id, listenerArn) {
        class Import extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.listenerArn = listenerArn;
            }
        }
        return new Import(scope, id);
    }
}
exports.Listener = Listener;
//# sourceMappingURL=data:application/json;base64,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