import * as cdk from "../../core";
import { Construct } from 'constructs';
import { IAccelerator } from './accelerator';
/**
 * (experimental) Interface of the Listener.
 *
 * @experimental
 */
export interface IListener extends cdk.IResource {
    /**
     * (experimental) The ARN of the listener.
     *
     * @experimental
     * @attribute true
     */
    readonly listenerArn: string;
}
/**
 * (experimental) construct properties for Listener.
 *
 * @experimental
 */
export interface ListenerProps {
    /**
     * (experimental) Name of the listener.
     *
     * @default - logical ID of the resource
     * @experimental
     */
    readonly listenerName?: string;
    /**
     * (experimental) The accelerator for this listener.
     *
     * @experimental
     */
    readonly accelerator: IAccelerator;
    /**
     * (experimental) The list of port ranges for the connections from clients to the accelerator.
     *
     * @experimental
     */
    readonly portRanges: PortRange[];
    /**
     * (experimental) The protocol for the connections from clients to the accelerator.
     *
     * @default TCP
     * @experimental
     */
    readonly protocol?: ConnectionProtocol;
    /**
     * (experimental) Client affinity to direct all requests from a user to the same endpoint.
     *
     * @default NONE
     * @experimental
     */
    readonly clientAffinity?: ClientAffinity;
}
/**
 * (experimental) The list of port ranges for the connections from clients to the accelerator.
 *
 * @experimental
 */
export interface PortRange {
    /**
     * (experimental) The first port in the range of ports, inclusive.
     *
     * @experimental
     */
    readonly fromPort: number;
    /**
     * (experimental) The last port in the range of ports, inclusive.
     *
     * @experimental
     */
    readonly toPort: number;
}
/**
 * (experimental) The protocol for the connections from clients to the accelerator.
 *
 * @experimental
 */
export declare enum ConnectionProtocol {
    /**
     * (experimental) TCP.
     *
     * @experimental
     */
    TCP = "TCP",
    /**
     * (experimental) UDP.
     *
     * @experimental
     */
    UDP = "UDP"
}
/**
 * (experimental) Client affinity lets you direct all requests from a user to the same endpoint, if you have stateful applications, regardless of the port and protocol of the client request.
 *
 * Client affinity gives you control over whether to always
 * route each client to the same specific endpoint. If you want a given client to always be routed to the same
 * endpoint, set client affinity to SOURCE_IP.
 *
 * @see https://docs.aws.amazon.com/global-accelerator/latest/dg/about-listeners.html#about-listeners-client-affinity
 * @experimental
 */
export declare enum ClientAffinity {
    /**
     * (experimental) default affinity.
     *
     * @experimental
     */
    NONE = "NONE",
    /**
     * (experimental) affinity by source IP.
     *
     * @experimental
     */
    SOURCE_IP = "SOURCE_IP"
}
/**
 * (experimental) The construct for the Listener.
 *
 * @experimental
 */
export declare class Listener extends cdk.Resource implements IListener {
    /**
     * (experimental) import from ARN.
     *
     * @experimental
     */
    static fromListenerArn(scope: Construct, id: string, listenerArn: string): IListener;
    /**
     * (experimental) The ARN of the listener.
     *
     * @experimental
     */
    readonly listenerArn: string;
    /**
     * (experimental) The name of the listener.
     *
     * @experimental
     * @attribute true
     */
    readonly listenerName: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: ListenerProps);
}
