"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LustreMaintenanceTime = exports.Weekday = void 0;
/**
 * (experimental) Enum for representing all the days of the week.
 *
 * @experimental
 */
var Weekday;
(function (Weekday) {
    Weekday["SUNDAY"] = "0";
    Weekday["MONDAY"] = "1";
    Weekday["TUESDAY"] = "2";
    Weekday["WEDNESDAY"] = "3";
    Weekday["THURSDAY"] = "4";
    Weekday["FRIDAY"] = "5";
    Weekday["SATURDAY"] = "6";
})(Weekday = exports.Weekday || (exports.Weekday = {}));
/**
 * (experimental) Class for scheduling a weekly manitenance time.
 *
 * @experimental
 */
class LustreMaintenanceTime {
    /**
     * @experimental
     */
    constructor(props) {
        this.validate(props.hour, props.minute);
        this.day = props.day;
        this.hour = this.getTwoDigitString(props.hour);
        this.minute = this.getTwoDigitString(props.minute);
    }
    /**
     * (experimental) Converts a day, hour, and minute into a timestamp as used by FSx for Lustre's weeklyMaintenanceStartTime field.
     *
     * @experimental
     */
    toTimestamp() {
        return `${this.day.valueOf()}:${this.hour}:${this.minute}`;
    }
    /**
     * Pad an integer so that it always contains at least 2 digits. Assumes the number is a positive integer.
     */
    getTwoDigitString(n) {
        const numberString = n.toString();
        if (numberString.length === 1) {
            return `0${n}`;
        }
        return numberString;
    }
    /**
     * Validation needed for the values of the maintenance time.
     */
    validate(hour, minute) {
        if (!Number.isInteger(hour) || hour < 0 || hour > 24) {
            throw new Error('Maintenance time hour must be an integer between 0 and 24');
        }
        if (!Number.isInteger(minute) || minute < 0 || minute > 59) {
            throw new Error('Maintenance time minute must be an integer between 0 and 59');
        }
    }
}
exports.LustreMaintenanceTime = LustreMaintenanceTime;
//# sourceMappingURL=data:application/json;base64,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