"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.mergeEventPattern = void 0;
/**
 * Merge the `src` event pattern into the `dest` event pattern by adding all
 * values from `src` into the fields in `dest`.
 *
 * See `rule.addEventPattern` for details.
 */
function mergeEventPattern(dest, src) {
    dest = dest || {};
    mergeObject(dest, src);
    return dest;
    function mergeObject(destObj, srcObj) {
        if (typeof (srcObj) !== 'object') {
            throw new Error(`Invalid event pattern '${JSON.stringify(srcObj)}', expecting an object or an array`);
        }
        for (const field of Object.keys(srcObj)) {
            const srcValue = srcObj[field];
            const destValue = destObj[field];
            if (srcValue === undefined) {
                continue;
            }
            if (typeof (srcValue) !== 'object') {
                throw new Error(`Invalid event pattern field { ${field}: ${JSON.stringify(srcValue)} }. All fields must be arrays`);
            }
            // dest doesn't have this field
            if (destObj[field] === undefined) {
                destObj[field] = srcValue;
                continue;
            }
            if (Array.isArray(srcValue) !== Array.isArray(destValue)) {
                throw new Error(`Invalid event pattern field ${field}. ` +
                    `Type mismatch between existing pattern ${JSON.stringify(destValue)} and added pattern ${JSON.stringify(srcValue)}`);
            }
            // if this is an array, concat the values
            if (Array.isArray(srcValue)) {
                destObj[field] = destValue.concat(srcValue);
                continue;
            }
            // otherwise, it's an object, so recurse
            mergeObject(destObj[field], srcValue);
        }
    }
}
exports.mergeEventPattern = mergeEventPattern;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidXRpbC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInV0aWwudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUE7Ozs7O0dBS0c7QUFDSCxTQUFnQixpQkFBaUIsQ0FBQyxJQUFTLEVBQUUsR0FBUTtJQUNqRCxJQUFJLEdBQUcsSUFBSSxJQUFJLEVBQUUsQ0FBQztJQUNsQixXQUFXLENBQUMsSUFBSSxFQUFFLEdBQUcsQ0FBQyxDQUFDO0lBQ3ZCLE9BQU8sSUFBSSxDQUFDO0lBQ1osU0FBUyxXQUFXLENBQUMsT0FBWSxFQUFFLE1BQVc7UUFDMUMsSUFBSSxPQUFPLENBQUMsTUFBTSxDQUFDLEtBQUssUUFBUSxFQUFFO1lBQzlCLE1BQU0sSUFBSSxLQUFLLENBQUMsMEJBQTBCLElBQUksQ0FBQyxTQUFTLENBQUMsTUFBTSxDQUFDLG9DQUFvQyxDQUFDLENBQUM7U0FDekc7UUFDRCxLQUFLLE1BQU0sS0FBSyxJQUFJLE1BQU0sQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLEVBQUU7WUFDckMsTUFBTSxRQUFRLEdBQUcsTUFBTSxDQUFDLEtBQUssQ0FBQyxDQUFDO1lBQy9CLE1BQU0sU0FBUyxHQUFHLE9BQU8sQ0FBQyxLQUFLLENBQUMsQ0FBQztZQUNqQyxJQUFJLFFBQVEsS0FBSyxTQUFTLEVBQUU7Z0JBQ3hCLFNBQVM7YUFDWjtZQUNELElBQUksT0FBTyxDQUFDLFFBQVEsQ0FBQyxLQUFLLFFBQVEsRUFBRTtnQkFDaEMsTUFBTSxJQUFJLEtBQUssQ0FBQyxpQ0FBaUMsS0FBSyxLQUFLLElBQUksQ0FBQyxTQUFTLENBQUMsUUFBUSxDQUFDLCtCQUErQixDQUFDLENBQUM7YUFDdkg7WUFDRCwrQkFBK0I7WUFDL0IsSUFBSSxPQUFPLENBQUMsS0FBSyxDQUFDLEtBQUssU0FBUyxFQUFFO2dCQUM5QixPQUFPLENBQUMsS0FBSyxDQUFDLEdBQUcsUUFBUSxDQUFDO2dCQUMxQixTQUFTO2FBQ1o7WUFDRCxJQUFJLEtBQUssQ0FBQyxPQUFPLENBQUMsUUFBUSxDQUFDLEtBQUssS0FBSyxDQUFDLE9BQU8sQ0FBQyxTQUFTLENBQUMsRUFBRTtnQkFDdEQsTUFBTSxJQUFJLEtBQUssQ0FBQywrQkFBK0IsS0FBSyxJQUFJO29CQUNwRCwwQ0FBMEMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxTQUFTLENBQUMsc0JBQXNCLElBQUksQ0FBQyxTQUFTLENBQUMsUUFBUSxDQUFDLEVBQUUsQ0FBQyxDQUFDO2FBQzVIO1lBQ0QseUNBQXlDO1lBQ3pDLElBQUksS0FBSyxDQUFDLE9BQU8sQ0FBQyxRQUFRLENBQUMsRUFBRTtnQkFDekIsT0FBTyxDQUFDLEtBQUssQ0FBQyxHQUFHLFNBQVMsQ0FBQyxNQUFNLENBQUMsUUFBUSxDQUFDLENBQUM7Z0JBQzVDLFNBQVM7YUFDWjtZQUNELHdDQUF3QztZQUN4QyxXQUFXLENBQUMsT0FBTyxDQUFDLEtBQUssQ0FBQyxFQUFFLFFBQVEsQ0FBQyxDQUFDO1NBQ3pDO0lBQ0wsQ0FBQztBQUNMLENBQUM7QUFuQ0QsOENBbUNDIiwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiBNZXJnZSB0aGUgYHNyY2AgZXZlbnQgcGF0dGVybiBpbnRvIHRoZSBgZGVzdGAgZXZlbnQgcGF0dGVybiBieSBhZGRpbmcgYWxsXG4gKiB2YWx1ZXMgZnJvbSBgc3JjYCBpbnRvIHRoZSBmaWVsZHMgaW4gYGRlc3RgLlxuICpcbiAqIFNlZSBgcnVsZS5hZGRFdmVudFBhdHRlcm5gIGZvciBkZXRhaWxzLlxuICovXG5leHBvcnQgZnVuY3Rpb24gbWVyZ2VFdmVudFBhdHRlcm4oZGVzdDogYW55LCBzcmM6IGFueSkge1xuICAgIGRlc3QgPSBkZXN0IHx8IHt9O1xuICAgIG1lcmdlT2JqZWN0KGRlc3QsIHNyYyk7XG4gICAgcmV0dXJuIGRlc3Q7XG4gICAgZnVuY3Rpb24gbWVyZ2VPYmplY3QoZGVzdE9iajogYW55LCBzcmNPYmo6IGFueSkge1xuICAgICAgICBpZiAodHlwZW9mIChzcmNPYmopICE9PSAnb2JqZWN0Jykge1xuICAgICAgICAgICAgdGhyb3cgbmV3IEVycm9yKGBJbnZhbGlkIGV2ZW50IHBhdHRlcm4gJyR7SlNPTi5zdHJpbmdpZnkoc3JjT2JqKX0nLCBleHBlY3RpbmcgYW4gb2JqZWN0IG9yIGFuIGFycmF5YCk7XG4gICAgICAgIH1cbiAgICAgICAgZm9yIChjb25zdCBmaWVsZCBvZiBPYmplY3Qua2V5cyhzcmNPYmopKSB7XG4gICAgICAgICAgICBjb25zdCBzcmNWYWx1ZSA9IHNyY09ialtmaWVsZF07XG4gICAgICAgICAgICBjb25zdCBkZXN0VmFsdWUgPSBkZXN0T2JqW2ZpZWxkXTtcbiAgICAgICAgICAgIGlmIChzcmNWYWx1ZSA9PT0gdW5kZWZpbmVkKSB7XG4gICAgICAgICAgICAgICAgY29udGludWU7XG4gICAgICAgICAgICB9XG4gICAgICAgICAgICBpZiAodHlwZW9mIChzcmNWYWx1ZSkgIT09ICdvYmplY3QnKSB7XG4gICAgICAgICAgICAgICAgdGhyb3cgbmV3IEVycm9yKGBJbnZhbGlkIGV2ZW50IHBhdHRlcm4gZmllbGQgeyAke2ZpZWxkfTogJHtKU09OLnN0cmluZ2lmeShzcmNWYWx1ZSl9IH0uIEFsbCBmaWVsZHMgbXVzdCBiZSBhcnJheXNgKTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIC8vIGRlc3QgZG9lc24ndCBoYXZlIHRoaXMgZmllbGRcbiAgICAgICAgICAgIGlmIChkZXN0T2JqW2ZpZWxkXSA9PT0gdW5kZWZpbmVkKSB7XG4gICAgICAgICAgICAgICAgZGVzdE9ialtmaWVsZF0gPSBzcmNWYWx1ZTtcbiAgICAgICAgICAgICAgICBjb250aW51ZTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIGlmIChBcnJheS5pc0FycmF5KHNyY1ZhbHVlKSAhPT0gQXJyYXkuaXNBcnJheShkZXN0VmFsdWUpKSB7XG4gICAgICAgICAgICAgICAgdGhyb3cgbmV3IEVycm9yKGBJbnZhbGlkIGV2ZW50IHBhdHRlcm4gZmllbGQgJHtmaWVsZH0uIGAgK1xuICAgICAgICAgICAgICAgICAgICBgVHlwZSBtaXNtYXRjaCBiZXR3ZWVuIGV4aXN0aW5nIHBhdHRlcm4gJHtKU09OLnN0cmluZ2lmeShkZXN0VmFsdWUpfSBhbmQgYWRkZWQgcGF0dGVybiAke0pTT04uc3RyaW5naWZ5KHNyY1ZhbHVlKX1gKTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIC8vIGlmIHRoaXMgaXMgYW4gYXJyYXksIGNvbmNhdCB0aGUgdmFsdWVzXG4gICAgICAgICAgICBpZiAoQXJyYXkuaXNBcnJheShzcmNWYWx1ZSkpIHtcbiAgICAgICAgICAgICAgICBkZXN0T2JqW2ZpZWxkXSA9IGRlc3RWYWx1ZS5jb25jYXQoc3JjVmFsdWUpO1xuICAgICAgICAgICAgICAgIGNvbnRpbnVlO1xuICAgICAgICAgICAgfVxuICAgICAgICAgICAgLy8gb3RoZXJ3aXNlLCBpdCdzIGFuIG9iamVjdCwgc28gcmVjdXJzZVxuICAgICAgICAgICAgbWVyZ2VPYmplY3QoZGVzdE9ialtmaWVsZF0sIHNyY1ZhbHVlKTtcbiAgICAgICAgfVxuICAgIH1cbn1cbiJdfQ==