import * as iam from "../../aws-iam";
import { IConstruct } from "../../core";
import { CfnRule } from './events.generated';
import { RuleTargetInput } from './input';
import { IRule } from './rule-ref';
/**
 * (experimental) An abstract target for EventRules.
 *
 * @experimental
 */
export interface IRuleTarget {
    /**
     * (experimental) Returns the rule target specification.
     *
     * NOTE: Do not use the various `inputXxx` options. They can be set in a call to `addTarget`.
     *
     * @param rule The EventBridge Rule that would trigger this target.
     * @param id The id of the target that will be attached to the rule.
     * @experimental
     */
    bind(rule: IRule, id?: string): RuleTargetConfig;
}
/**
 * (experimental) Properties for an event rule target.
 *
 * @experimental
 */
export interface RuleTargetConfig {
    /**
     * (deprecated) A unique, user-defined identifier for the target.
     *
     * Acceptable values
     * include alphanumeric characters, periods (.), hyphens (-), and
     * underscores (_).
     *
     * @deprecated prefer auto-generated id by specifying an empty string
     */
    readonly id: string;
    /**
     * (experimental) The Amazon Resource Name (ARN) of the target.
     *
     * @experimental
     */
    readonly arn: string;
    /**
     * (experimental) Role to use to invoke this event target.
     *
     * @experimental
     */
    readonly role?: iam.IRole;
    /**
     * (experimental) Parameters used when the rule invokes Amazon AWS Batch Job/Queue.
     *
     * @default no parameters set
     * @experimental
     */
    readonly batchParameters?: CfnRule.BatchParametersProperty;
    /**
     * (experimental) The Amazon ECS task definition and task count to use, if the event target is an Amazon ECS task.
     *
     * @experimental
     */
    readonly ecsParameters?: CfnRule.EcsParametersProperty;
    /**
     * (experimental) Settings that control shard assignment, when the target is a Kinesis stream.
     *
     * If you don't include this parameter, eventId is used as the
     * partition key.
     *
     * @experimental
     */
    readonly kinesisParameters?: CfnRule.KinesisParametersProperty;
    /**
     * (experimental) Parameters used when the rule invokes Amazon EC2 Systems Manager Run Command.
     *
     * @experimental
     */
    readonly runCommandParameters?: CfnRule.RunCommandParametersProperty;
    /**
     * (experimental) Parameters used when the FIFO sqs queue is used an event target by the rule.
     *
     * @experimental
     */
    readonly sqsParameters?: CfnRule.SqsParametersProperty;
    /**
     * (experimental) What input to send to the event target.
     *
     * @default the entire event
     * @experimental
     */
    readonly input?: RuleTargetInput;
    /**
     * (experimental) The resource that is backing this target.
     *
     * This is the resource that will actually have some action performed on it when used as a target
     * (for example, start a build for a CodeBuild project).
     * We need it to determine whether the rule belongs to a different account than the target -
     * if so, we generate a more complex setup,
     * including an additional stack containing the EventBusPolicy.
     *
     * @default the target is not backed by any resource
     * @see https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-cross-account-event-delivery.html
     * @experimental
     */
    readonly targetResource?: IConstruct;
}
