import * as events from "../../aws-events";
import * as iam from "../../aws-iam";
import * as lambda from "../../aws-lambda";
import { IConstruct } from "../../core";
/**
 * Obtain the Role for the EventBridge event
 *
 * If a role already exists, it will be returned. This ensures that if multiple
 * events have the same target, they will share a role.
 */
export declare function singletonEventRole(scope: IConstruct, policyStatements: iam.PolicyStatement[]): iam.IRole;
/**
 * Allows a Lambda function to be called from a rule
 */
export declare function addLambdaPermission(rule: events.IRule, handler: lambda.IFunction): void;
