"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SfnStateMachine = void 0;
const iam = require("../../aws-iam"); // Automatically re-written from '@aws-cdk/aws-iam'
const util_1 = require("./util");
/**
 * (experimental) Use a StepFunctions state machine as a target for Amazon EventBridge rules.
 *
 * @experimental
 */
class SfnStateMachine {
    /**
     * @experimental
     */
    constructor(machine, props = {}) {
        var _a;
        this.machine = machine;
        this.props = props;
        if (props.role) {
            props.role.grant(new iam.ServicePrincipal('events.amazonaws.com'));
        }
        // no statements are passed because we are configuring permissions by using grant* helper below
        this.role = (_a = props.role) !== null && _a !== void 0 ? _a : util_1.singletonEventRole(machine, []);
        machine.grantStartExecution(this.role);
    }
    /**
     * (experimental) Returns a properties that are used in an Rule to trigger this State Machine.
     *
     * @see https://docs.aws.amazon.com/eventbridge/latest/userguide/resource-based-policies-eventbridge.html#sns-permissions
     * @experimental
     */
    bind(_rule, _id) {
        return {
            id: '',
            arn: this.machine.stateMachineArn,
            role: this.role,
            input: this.props.input,
            targetResource: this.machine,
        };
    }
}
exports.SfnStateMachine = SfnStateMachine;
//# sourceMappingURL=data:application/json;base64,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