import * as events from "../../aws-events";
import * as iam from "../../aws-iam";
import * as sfn from "../../aws-stepfunctions";
/**
 * (experimental) Customize the Step Functions State Machine target.
 *
 * @experimental
 */
export interface SfnStateMachineProps {
    /**
     * (experimental) The input to the state machine execution.
     *
     * @default the entire EventBridge event
     * @experimental
     */
    readonly input?: events.RuleTargetInput;
    /**
     * (experimental) The IAM role to be assumed to execute the State Machine.
     *
     * @default - a new role will be created
     * @experimental
     */
    readonly role?: iam.IRole;
}
/**
 * (experimental) Use a StepFunctions state machine as a target for Amazon EventBridge rules.
 *
 * @experimental
 */
export declare class SfnStateMachine implements events.IRuleTarget {
    readonly machine: sfn.IStateMachine;
    private readonly props;
    private readonly role;
    /**
     * @experimental
     */
    constructor(machine: sfn.IStateMachine, props?: SfnStateMachineProps);
    /**
     * (experimental) Returns a properties that are used in an Rule to trigger this State Machine.
     *
     * @see https://docs.aws.amazon.com/eventbridge/latest/userguide/resource-based-policies-eventbridge.html#sns-permissions
     * @experimental
     */
    bind(_rule: events.IRule, _id?: string): events.RuleTargetConfig;
}
