import * as events from "../../aws-events";
import * as sqs from "../../aws-sqs";
/**
 * (experimental) Customize the SQS Queue Event Target.
 *
 * @experimental
 */
export interface SqsQueueProps {
    /**
     * (experimental) Message Group ID for messages sent to this queue.
     *
     * Required for FIFO queues, leave empty for regular queues.
     *
     * @default - no message group ID (regular queue)
     * @experimental
     */
    readonly messageGroupId?: string;
    /**
     * (experimental) The message to send to the queue.
     *
     * Must be a valid JSON text passed to the target queue.
     *
     * @default the entire EventBridge event
     * @experimental
     */
    readonly message?: events.RuleTargetInput;
}
/**
 * (experimental) Use an SQS Queue as a target for Amazon EventBridge rules.
 *
 * @experimental
 * @example
 *
 *    // publish to an SQS queue every time code is committed
 *    // to a CodeCommit repository
 *    repository.onCommit(new targets.SqsQueue(queue));
 */
export declare class SqsQueue implements events.IRuleTarget {
    readonly queue: sqs.IQueue;
    private readonly props;
    /**
     * @experimental
     */
    constructor(queue: sqs.IQueue, props?: SqsQueueProps);
    /**
     * (experimental) Returns a RuleTarget that can be used to trigger this SQS queue as a result from an EventBridge event.
     *
     * @see https://docs.aws.amazon.com/eventbridge/latest/userguide/resource-based-policies-eventbridge.html#sqs-permissions
     * @experimental
     */
    bind(rule: events.IRule, _id?: string): events.RuleTargetConfig;
}
