"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.KinesisFirehoseStream = void 0;
const iam = require("../../aws-iam"); // Automatically re-written from '@aws-cdk/aws-iam'
const util_1 = require("./util");
/**
 * (experimental) Customize the Firehose Stream Event Target.
 *
 * @experimental
 */
class KinesisFirehoseStream {
    /**
     * @experimental
     */
    constructor(stream, props = {}) {
        this.stream = stream;
        this.props = props;
    }
    /**
     * (experimental) Returns a RuleTarget that can be used to trigger this Firehose Stream as a result from a Event Bridge event.
     *
     * @experimental
     */
    bind(_rule, _id) {
        const policyStatements = [new iam.PolicyStatement({
                actions: ['firehose:PutRecord', 'firehose:PutRecordBatch'],
                resources: [this.stream.attrArn],
            })];
        return {
            id: '',
            arn: this.stream.attrArn,
            role: util_1.singletonEventRole(this.stream, policyStatements),
            input: this.props.message,
            targetResource: this.stream,
        };
    }
}
exports.KinesisFirehoseStream = KinesisFirehoseStream;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoia2luZXNpcy1maXJlaG9zZS1zdHJlYW0uanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJraW5lc2lzLWZpcmVob3NlLXN0cmVhbS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFDQSxxQ0FBcUMsQ0FBQyxtREFBbUQ7QUFFekYsaUNBQTRDOzs7Ozs7QUFpQjVDLE1BQWEscUJBQXFCOzs7O0lBQzlCLFlBQTZCLE1BQWtDLEVBQW1CLFFBQW9DLEVBQUU7UUFBM0YsV0FBTSxHQUFOLE1BQU0sQ0FBNEI7UUFBbUIsVUFBSyxHQUFMLEtBQUssQ0FBaUM7SUFDeEgsQ0FBQzs7Ozs7O0lBS00sSUFBSSxDQUFDLEtBQW1CLEVBQUUsR0FBWTtRQUN6QyxNQUFNLGdCQUFnQixHQUFHLENBQUMsSUFBSSxHQUFHLENBQUMsZUFBZSxDQUFDO2dCQUMxQyxPQUFPLEVBQUUsQ0FBQyxvQkFBb0IsRUFBRSx5QkFBeUIsQ0FBQztnQkFDMUQsU0FBUyxFQUFFLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxPQUFPLENBQUM7YUFDbkMsQ0FBQyxDQUFDLENBQUM7UUFDUixPQUFPO1lBQ0gsRUFBRSxFQUFFLEVBQUU7WUFDTixHQUFHLEVBQUUsSUFBSSxDQUFDLE1BQU0sQ0FBQyxPQUFPO1lBQ3hCLElBQUksRUFBRSx5QkFBa0IsQ0FBQyxJQUFJLENBQUMsTUFBTSxFQUFFLGdCQUFnQixDQUFDO1lBQ3ZELEtBQUssRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLE9BQU87WUFDekIsY0FBYyxFQUFFLElBQUksQ0FBQyxNQUFNO1NBQzlCLENBQUM7SUFDTixDQUFDO0NBQ0o7QUFwQkQsc0RBb0JDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgZXZlbnRzIGZyb20gXCIuLi8uLi9hd3MtZXZlbnRzXCI7IC8vIEF1dG9tYXRpY2FsbHkgcmUtd3JpdHRlbiBmcm9tICdAYXdzLWNkay9hd3MtZXZlbnRzJ1xuaW1wb3J0ICogYXMgaWFtIGZyb20gXCIuLi8uLi9hd3MtaWFtXCI7IC8vIEF1dG9tYXRpY2FsbHkgcmUtd3JpdHRlbiBmcm9tICdAYXdzLWNkay9hd3MtaWFtJ1xuaW1wb3J0ICogYXMgZmlyZWhvc2UgZnJvbSBcIi4uLy4uL2F3cy1raW5lc2lzZmlyZWhvc2VcIjsgLy8gQXV0b21hdGljYWxseSByZS13cml0dGVuIGZyb20gJ0Bhd3MtY2RrL2F3cy1raW5lc2lzZmlyZWhvc2UnXG5pbXBvcnQgeyBzaW5nbGV0b25FdmVudFJvbGUgfSBmcm9tICcuL3V0aWwnO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBpbnRlcmZhY2UgS2luZXNpc0ZpcmVob3NlU3RyZWFtUHJvcHMge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHJlYWRvbmx5IG1lc3NhZ2U/OiBldmVudHMuUnVsZVRhcmdldElucHV0O1xufVxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBjbGFzcyBLaW5lc2lzRmlyZWhvc2VTdHJlYW0gaW1wbGVtZW50cyBldmVudHMuSVJ1bGVUYXJnZXQge1xuICAgIGNvbnN0cnVjdG9yKHByaXZhdGUgcmVhZG9ubHkgc3RyZWFtOiBmaXJlaG9zZS5DZm5EZWxpdmVyeVN0cmVhbSwgcHJpdmF0ZSByZWFkb25seSBwcm9wczogS2luZXNpc0ZpcmVob3NlU3RyZWFtUHJvcHMgPSB7fSkge1xuICAgIH1cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyBiaW5kKF9ydWxlOiBldmVudHMuSVJ1bGUsIF9pZD86IHN0cmluZyk6IGV2ZW50cy5SdWxlVGFyZ2V0Q29uZmlnIHtcbiAgICAgICAgY29uc3QgcG9saWN5U3RhdGVtZW50cyA9IFtuZXcgaWFtLlBvbGljeVN0YXRlbWVudCh7XG4gICAgICAgICAgICAgICAgYWN0aW9uczogWydmaXJlaG9zZTpQdXRSZWNvcmQnLCAnZmlyZWhvc2U6UHV0UmVjb3JkQmF0Y2gnXSxcbiAgICAgICAgICAgICAgICByZXNvdXJjZXM6IFt0aGlzLnN0cmVhbS5hdHRyQXJuXSxcbiAgICAgICAgICAgIH0pXTtcbiAgICAgICAgcmV0dXJuIHtcbiAgICAgICAgICAgIGlkOiAnJyxcbiAgICAgICAgICAgIGFybjogdGhpcy5zdHJlYW0uYXR0ckFybixcbiAgICAgICAgICAgIHJvbGU6IHNpbmdsZXRvbkV2ZW50Um9sZSh0aGlzLnN0cmVhbSwgcG9saWN5U3RhdGVtZW50cyksXG4gICAgICAgICAgICBpbnB1dDogdGhpcy5wcm9wcy5tZXNzYWdlLFxuICAgICAgICAgICAgdGFyZ2V0UmVzb3VyY2U6IHRoaXMuc3RyZWFtLFxuICAgICAgICB9O1xuICAgIH1cbn1cbiJdfQ==