import * as events from "../../aws-events";
import * as firehose from "../../aws-kinesisfirehose";
/**
 * (experimental) Customize the Firehose Stream Event Target.
 *
 * @experimental
 */
export interface KinesisFirehoseStreamProps {
    /**
     * (experimental) The message to send to the stream.
     *
     * Must be a valid JSON text passed to the target stream.
     *
     * @default - the entire Event Bridge event
     * @experimental
     */
    readonly message?: events.RuleTargetInput;
}
/**
 * (experimental) Customize the Firehose Stream Event Target.
 *
 * @experimental
 */
export declare class KinesisFirehoseStream implements events.IRuleTarget {
    private readonly stream;
    private readonly props;
    /**
     * @experimental
     */
    constructor(stream: firehose.CfnDeliveryStream, props?: KinesisFirehoseStreamProps);
    /**
     * (experimental) Returns a RuleTarget that can be used to trigger this Firehose Stream as a result from a Event Bridge event.
     *
     * @experimental
     */
    bind(_rule: events.IRule, _id?: string): events.RuleTargetConfig;
}
