/**
 * @experimental
 */
export interface ContainerOverride {
    /**
     * (experimental) Name of the container inside the task definition.
     *
     * @experimental
     */
    readonly containerName: string;
    /**
     * (experimental) Command to run inside the container.
     *
     * @default Default command
     * @experimental
     */
    readonly command?: string[];
    /**
     * (experimental) Variables to set in the container's environment.
     *
     * @experimental
     */
    readonly environment?: TaskEnvironmentVariable[];
    /**
     * (experimental) The number of cpu units reserved for the container.
     *
     * @default The default value from the task definition.
     * @experimental
     */
    readonly cpu?: number;
    /**
     * (experimental) Hard memory limit on the container.
     *
     * @default The default value from the task definition.
     * @experimental
     */
    readonly memoryLimit?: number;
    /**
     * (experimental) Soft memory limit on the container.
     *
     * @default The default value from the task definition.
     * @experimental
     */
    readonly memoryReservation?: number;
}
/**
 * (experimental) An environment variable to be set in the container run as a task.
 *
 * @experimental
 */
export interface TaskEnvironmentVariable {
    /**
     * (experimental) Name for the environment variable.
     *
     * Exactly one of `name` and `namePath` must be specified.
     *
     * @experimental
     */
    readonly name: string;
    /**
     * (experimental) Value of the environment variable.
     *
     * Exactly one of `value` and `valuePath` must be specified.
     *
     * @experimental
     */
    readonly value: string;
}
