"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BatchJob = void 0;
const iam = require("../../aws-iam"); // Automatically re-written from '@aws-cdk/aws-iam'
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const util_1 = require("./util");
/**
 * (experimental) Use an AWS Batch Job / Queue as an event rule target.
 *
 * @experimental
 */
class BatchJob {
    /**
     * @experimental
     */
    constructor(jobQueue, jobDefinition, props = {}) {
        this.jobQueue = jobQueue;
        this.jobDefinition = jobDefinition;
        this.props = props;
    }
    /**
     * (experimental) Returns a RuleTarget that can be used to trigger queue this batch job as a result from an EventBridge event.
     *
     * @experimental
     */
    bind(rule, _id) {
        var _a;
        const batchParameters = {
            jobDefinition: this.jobDefinition.jobDefinitionArn,
            jobName: (_a = this.props.jobName) !== null && _a !== void 0 ? _a : core_1.Names.nodeUniqueId(rule.node),
            arrayProperties: this.props.size ? { size: this.props.size } : undefined,
            retryStrategy: this.props.attempts ? { attempts: this.props.attempts } : undefined,
        };
        return {
            id: '',
            arn: this.jobQueue.jobQueueArn,
            // When scoping resource-level access for job submission, you must provide both job queue and job definition resource types.
            // https://docs.aws.amazon.com/batch/latest/userguide/ExamplePolicies_BATCH.html#iam-example-restrict-job-def
            role: util_1.singletonEventRole(this.jobDefinition, [
                new iam.PolicyStatement({
                    actions: ['batch:SubmitJob'],
                    resources: [
                        this.jobDefinition.jobDefinitionArn,
                        this.jobQueue.jobQueueArn,
                    ],
                }),
            ]),
            input: this.props.event,
            targetResource: this.jobQueue,
            batchParameters,
        };
    }
}
exports.BatchJob = BatchJob;
//# sourceMappingURL=data:application/json;base64,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