import * as batch from "../../aws-batch";
import * as events from "../../aws-events";
/**
 * (experimental) Customize the Batch Job Event Target.
 *
 * @experimental
 */
export interface BatchJobProps {
    /**
     * (experimental) The event to send to the Lambda.
     *
     * This will be the payload sent to the Lambda Function.
     *
     * @default the entire EventBridge event
     * @experimental
     */
    readonly event?: events.RuleTargetInput;
    /**
     * (experimental) The size of the array, if this is an array batch job.
     *
     * Valid values are integers between 2 and 10,000.
     *
     * @default no arrayProperties are set
     * @experimental
     */
    readonly size?: number;
    /**
     * (experimental) The number of times to attempt to retry, if the job fails.
     *
     * Valid values are 1–10.
     *
     * @default no retryStrategy is set
     * @experimental
     */
    readonly attempts?: number;
    /**
     * (experimental) The name of the submitted job.
     *
     * @default - Automatically generated
     * @experimental
     */
    readonly jobName?: string;
}
/**
 * (experimental) Use an AWS Batch Job / Queue as an event rule target.
 *
 * @experimental
 */
export declare class BatchJob implements events.IRuleTarget {
    private readonly jobQueue;
    private readonly jobDefinition;
    private readonly props;
    /**
     * @experimental
     */
    constructor(jobQueue: batch.IJobQueue, jobDefinition: batch.IJobDefinition, props?: BatchJobProps);
    /**
     * (experimental) Returns a RuleTarget that can be used to trigger queue this batch job as a result from an EventBridge event.
     *
     * @experimental
     */
    bind(rule: events.IRule, _id?: string): events.RuleTargetConfig;
}
