"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LogGroupResourcePolicy = void 0;
const iam = require("../../aws-iam"); // Automatically re-written from '@aws-cdk/aws-iam'
const cr = require("../../custom-resources"); // Automatically re-written from '@aws-cdk/custom-resources'
/**
 * Creates LogGroup resource policies.
 */
class LogGroupResourcePolicy extends cr.AwsCustomResource {
    constructor(scope, id, props) {
        const policyDocument = new iam.PolicyDocument({
            statements: props.policyStatements,
        });
        super(scope, id, {
            resourceType: 'Custom::CloudwatchLogResourcePolicy',
            onUpdate: {
                service: 'CloudWatchLogs',
                action: 'putResourcePolicy',
                parameters: {
                    policyName: props.policyName,
                    policyDocument: JSON.stringify(policyDocument),
                },
                physicalResourceId: cr.PhysicalResourceId.of(id),
            },
            onDelete: {
                service: 'CloudWatchLogs',
                action: 'deleteResourcePolicy',
                parameters: {
                    policyName: props.policyName,
                },
                ignoreErrorCodesMatching: '400',
            },
            policy: cr.AwsCustomResourcePolicy.fromSdkCalls({ resources: ['*'] }),
        });
    }
}
exports.LogGroupResourcePolicy = LogGroupResourcePolicy;
//# sourceMappingURL=data:application/json;base64,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