"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ImportedTargetGroupBase = void 0;
const cdk = require("../../../core"); // Automatically re-written from '@aws-cdk/core'
/**
 * Base internal class for existing target groups
 */
class ImportedTargetGroupBase extends cdk.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        /**
         * Return an object to depend on the listeners added to this target group
         */
        this.loadBalancerAttached = new cdk.ConcreteDependable();
        this.targetGroupArn = props.targetGroupArn;
        this.loadBalancerArns = props.loadBalancerArns || cdk.Aws.NO_VALUE;
    }
}
exports.ImportedTargetGroupBase = ImportedTargetGroupBase;
//# sourceMappingURL=data:application/json;base64,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