import * as cloudwatch from "../../../aws-cloudwatch";
import { Construct } from 'constructs';
import { BaseTargetGroupProps, ITargetGroup, LoadBalancerTargetProps, TargetGroupAttributes, TargetGroupBase, TargetGroupImportProps } from '../shared/base-target-group';
import { Protocol } from '../shared/enums';
import { INetworkListener } from './network-listener';
/**
 * (experimental) Properties for a new Network Target Group.
 *
 * @experimental
 */
export interface NetworkTargetGroupProps extends BaseTargetGroupProps {
    /**
     * (experimental) The port on which the listener listens for requests.
     *
     * @experimental
     */
    readonly port: number;
    /**
     * (experimental) Protocol for target group, expects TCP, TLS, UDP, or TCP_UDP.
     *
     * @default - TCP
     * @experimental
     */
    readonly protocol?: Protocol;
    /**
     * (experimental) Indicates whether Proxy Protocol version 2 is enabled.
     *
     * @default false
     * @experimental
     */
    readonly proxyProtocolV2?: boolean;
    /**
     * (experimental) The targets to add to this target group.
     *
     * Can be `Instance`, `IPAddress`, or any self-registering load balancing
     * target. If you use either `Instance` or `IPAddress` as targets, all
     * target must be of the same type.
     *
     * @default - No targets.
     * @experimental
     */
    readonly targets?: INetworkLoadBalancerTarget[];
}
/**
 * (experimental) Define a Network Target Group.
 *
 * @experimental
 */
export declare class NetworkTargetGroup extends TargetGroupBase implements INetworkTargetGroup {
    /**
     * (experimental) Import an existing target group.
     *
     * @experimental
     */
    static fromTargetGroupAttributes(scope: Construct, id: string, attrs: TargetGroupAttributes): INetworkTargetGroup;
    /**
     * (deprecated) Import an existing listener.
     *
     * @deprecated Use `fromTargetGroupAttributes` instead
     */
    static import(scope: Construct, id: string, props: TargetGroupImportProps): INetworkTargetGroup;
    private readonly listeners;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: NetworkTargetGroupProps);
    /**
     * (experimental) Add a load balancing target to this target group.
     *
     * @experimental
     */
    addTarget(...targets: INetworkLoadBalancerTarget[]): void;
    /**
     * (experimental) Register a listener that is load balancing to this target group.
     *
     * Don't call this directly. It will be called by listeners.
     *
     * @experimental
     */
    registerListener(listener: INetworkListener): void;
    /**
     * (experimental) The number of targets that are considered healthy.
     *
     * @default Average over 5 minutes
     * @experimental
     */
    metricHealthyHostCount(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) The number of targets that are considered unhealthy.
     *
     * @default Average over 5 minutes
     * @experimental
     */
    metricUnHealthyHostCount(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) Full name of first load balancer.
     *
     * @experimental
     */
    get firstLoadBalancerFullName(): string;
    /**
     * (experimental) Validate the current construct.
     *
     * This method can be implemented by derived constructs in order to perform
     * validation logic. It is called on all constructs before synthesis.
     *
     * @experimental
     */
    protected validate(): string[];
    private metric;
}
/**
 * (experimental) A network target group.
 *
 * @experimental
 */
export interface INetworkTargetGroup extends ITargetGroup {
    /**
     * (experimental) Register a listener that is load balancing to this target group.
     *
     * Don't call this directly. It will be called by listeners.
     *
     * @experimental
     */
    registerListener(listener: INetworkListener): void;
    /**
     * (experimental) Add a load balancing target to this target group.
     *
     * @experimental
     */
    addTarget(...targets: INetworkLoadBalancerTarget[]): void;
}
/**
 * (experimental) Interface for constructs that can be targets of an network load balancer.
 *
 * @experimental
 */
export interface INetworkLoadBalancerTarget {
    /**
     * (experimental) Attach load-balanced target to a TargetGroup.
     *
     * May return JSON to directly add to the [Targets] list, or return undefined
     * if the target will register itself with the load balancer.
     *
     * @experimental
     */
    attachToNetworkTargetGroup(targetGroup: INetworkTargetGroup): LoadBalancerTargetProps;
}
