import * as ec2 from "../../../aws-ec2";
import { Duration, IResource } from "../../../core";
import { Construct } from 'constructs';
import { BaseListener } from '../shared/base-listener';
import { HealthCheck } from '../shared/base-target-group';
import { ApplicationProtocol, SslPolicy } from '../shared/enums';
import { IListenerCertificate } from '../shared/listener-certificate';
import { ListenerAction } from './application-listener-action';
import { FixedResponse, RedirectResponse } from './application-listener-rule';
import { IApplicationLoadBalancer } from './application-load-balancer';
import { ApplicationTargetGroup, IApplicationLoadBalancerTarget, IApplicationTargetGroup } from './application-target-group';
import { ListenerCondition } from './conditions';
/**
 * (experimental) Basic properties for an ApplicationListener.
 *
 * @experimental
 */
export interface BaseApplicationListenerProps {
    /**
     * (experimental) The protocol to use.
     *
     * @default - Determined from port if known.
     * @experimental
     */
    readonly protocol?: ApplicationProtocol;
    /**
     * (experimental) The port on which the listener listens for requests.
     *
     * @default - Determined from protocol if known.
     * @experimental
     */
    readonly port?: number;
    /**
     * (deprecated) The certificates to use on this listener.
     *
     * @default - No certificates.
     * @deprecated Use the `certificates` property instead
     */
    readonly certificateArns?: string[];
    /**
     * (experimental) Certificate list of ACM cert ARNs.
     *
     * @default - No certificates.
     * @experimental
     */
    readonly certificates?: IListenerCertificate[];
    /**
     * (experimental) The security policy that defines which ciphers and protocols are supported.
     *
     * @default - The current predefined security policy.
     * @experimental
     */
    readonly sslPolicy?: SslPolicy;
    /**
     * (experimental) Default target groups to load balance to.
     *
     * All target groups will be load balanced to with equal weight and without
     * stickiness. For a more complex configuration than that, use
     * either `defaultAction` or `addAction()`.
     *
     * Cannot be specified together with `defaultAction`.
     *
     * @default - None.
     * @experimental
     */
    readonly defaultTargetGroups?: IApplicationTargetGroup[];
    /**
     * (experimental) Default action to take for requests to this listener.
     *
     * This allows full control of the default action of the load balancer,
     * including Action chaining, fixed responses and redirect responses.
     *
     * See the `ListenerAction` class for all options.
     *
     * Cannot be specified together with `defaultTargetGroups`.
     *
     * @default - None.
     * @experimental
     */
    readonly defaultAction?: ListenerAction;
    /**
     * (experimental) Allow anyone to connect to this listener.
     *
     * If this is specified, the listener will be opened up to anyone who can reach it.
     * For internal load balancers this is anyone in the same VPC. For public load
     * balancers, this is anyone on the internet.
     *
     * If you want to be more selective about who can access this load
     * balancer, set this to `false` and use the listener's `connections`
     * object to selectively grant access to the listener.
     *
     * @default true
     * @experimental
     */
    readonly open?: boolean;
}
/**
 * (experimental) Properties for defining a standalone ApplicationListener.
 *
 * @experimental
 */
export interface ApplicationListenerProps extends BaseApplicationListenerProps {
    /**
     * (experimental) The load balancer to attach this listener to.
     *
     * @experimental
     */
    readonly loadBalancer: IApplicationLoadBalancer;
}
/**
 * (experimental) Define an ApplicationListener.
 *
 * @experimental
 * @resource AWS::ElasticLoadBalancingV2::Listener
 */
export declare class ApplicationListener extends BaseListener implements IApplicationListener {
    /**
     * (experimental) Import an existing listener.
     *
     * @experimental
     */
    static fromApplicationListenerAttributes(scope: Construct, id: string, attrs: ApplicationListenerAttributes): IApplicationListener;
    /**
     * (experimental) Manage connections to this ApplicationListener.
     *
     * @experimental
     */
    readonly connections: ec2.Connections;
    /**
     * (experimental) Load balancer this listener is associated with.
     *
     * @experimental
     */
    readonly loadBalancer: IApplicationLoadBalancer;
    /**
     * ARNs of certificates added to this listener
     */
    private readonly certificateArns;
    /**
     * Listener protocol for this listener.
     */
    private readonly protocol;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: ApplicationListenerProps);
    /**
     * (deprecated) Add one or more certificates to this listener.
     *
     * After the first certificate, this creates ApplicationListenerCertificates
     * resources since cloudformation requires the certificates array on the
     * listener resource to have a length of 1.
     *
     * @deprecated Use `addCertificates` instead.
     */
    addCertificateArns(id: string, arns: string[]): void;
    /**
     * (experimental) Add one or more certificates to this listener.
     *
     * After the first certificate, this creates ApplicationListenerCertificates
     * resources since cloudformation requires the certificates array on the
     * listener resource to have a length of 1.
     *
     * @experimental
     */
    addCertificates(id: string, certificates: IListenerCertificate[]): void;
    /**
     * (experimental) Perform the given default action on incoming requests.
     *
     * This allows full control of the default action of the load balancer,
     * including Action chaining, fixed responses and redirect responses. See
     * the `ListenerAction` class for all options.
     *
     * It's possible to add routing conditions to the Action added in this way.
     * At least one Action must be added without conditions (which becomes the
     * default Action).
     *
     * @experimental
     */
    addAction(id: string, props: AddApplicationActionProps): void;
    /**
     * (experimental) Load balance incoming requests to the given target groups.
     *
     * All target groups will be load balanced to with equal weight and without
     * stickiness. For a more complex configuration than that, use `addAction()`.
     *
     * It's possible to add routing conditions to the TargetGroups added in this
     * way. At least one TargetGroup must be added without conditions (which will
     * become the default Action for this listener).
     *
     * @experimental
     */
    addTargetGroups(id: string, props: AddApplicationTargetGroupsProps): void;
    /**
     * (experimental) Load balance incoming requests to the given load balancing targets.
     *
     * This method implicitly creates an ApplicationTargetGroup for the targets
     * involved, and a 'forward' action to route traffic to the given TargetGroup.
     *
     * If you want more control over the precise setup, create the TargetGroup
     * and use `addAction` yourself.
     *
     * It's possible to add conditions to the targets added in this way. At least
     * one set of targets must be added without conditions.
     *
     * @returns The newly created target group
     * @experimental
     */
    addTargets(id: string, props: AddApplicationTargetsProps): ApplicationTargetGroup;
    /**
     * (deprecated) Add a fixed response.
     *
     * @deprecated Use `addAction()` instead
     */
    addFixedResponse(id: string, props: AddFixedResponseProps): void;
    /**
     * (deprecated) Add a redirect response.
     *
     * @deprecated Use `addAction()` instead
     */
    addRedirectResponse(id: string, props: AddRedirectResponseProps): void;
    /**
     * (experimental) Register that a connectable that has been added to this load balancer.
     *
     * Don't call this directly. It is called by ApplicationTargetGroup.
     *
     * @experimental
     */
    registerConnectable(connectable: ec2.IConnectable, portRange: ec2.Port): void;
    /**
     * (experimental) Validate this listener.
     *
     * @experimental
     */
    protected validate(): string[];
    /**
     * Wrapper for _setDefaultAction which does a type-safe bind
     */
    private setDefaultAction;
}
/**
 * (experimental) Properties to reference an existing listener.
 *
 * @experimental
 */
export interface IApplicationListener extends IResource, ec2.IConnectable {
    /**
     * (experimental) ARN of the listener.
     *
     * @experimental
     * @attribute true
     */
    readonly listenerArn: string;
    /**
     * (experimental) Add one or more certificates to this listener.
     *
     * @experimental
     */
    addCertificateArns(id: string, arns: string[]): void;
    /**
     * (experimental) Load balance incoming requests to the given target groups.
     *
     * It's possible to add conditions to the TargetGroups added in this way.
     * At least one TargetGroup must be added without conditions.
     *
     * @experimental
     */
    addTargetGroups(id: string, props: AddApplicationTargetGroupsProps): void;
    /**
     * (experimental) Load balance incoming requests to the given load balancing targets.
     *
     * This method implicitly creates an ApplicationTargetGroup for the targets
     * involved.
     *
     * It's possible to add conditions to the targets added in this way. At least
     * one set of targets must be added without conditions.
     *
     * @returns The newly created target group
     * @experimental
     */
    addTargets(id: string, props: AddApplicationTargetsProps): ApplicationTargetGroup;
    /**
     * (experimental) Register that a connectable that has been added to this load balancer.
     *
     * Don't call this directly. It is called by ApplicationTargetGroup.
     *
     * @experimental
     */
    registerConnectable(connectable: ec2.IConnectable, portRange: ec2.Port): void;
}
/**
 * (experimental) Properties to reference an existing listener.
 *
 * @experimental
 */
export interface ApplicationListenerAttributes {
    /**
     * (experimental) ARN of the listener.
     *
     * @experimental
     */
    readonly listenerArn: string;
    /**
     * (deprecated) Security group ID of the load balancer this listener is associated with.
     *
     * @deprecated use `securityGroup` instead
     */
    readonly securityGroupId?: string;
    /**
     * (experimental) Security group of the load balancer this listener is associated with.
     *
     * @experimental
     */
    readonly securityGroup?: ec2.ISecurityGroup;
    /**
     * (experimental) The default port on which this listener is listening.
     *
     * @experimental
     */
    readonly defaultPort?: number;
    /**
     * (deprecated) Whether the imported security group allows all outbound traffic or not when imported using `securityGroupId`.
     *
     * Unless set to `false`, no egress rules will be added to the security group.
     *
     * @default true
     * @deprecated use `securityGroup` instead
     */
    readonly securityGroupAllowsAllOutbound?: boolean;
}
/**
 * (experimental) Properties for adding a conditional load balancing rule.
 *
 * @experimental
 */
export interface AddRuleProps {
    /**
     * (experimental) Priority of this target group.
     *
     * The rule with the lowest priority will be used for every request.
     * If priority is not given, these target groups will be added as
     * defaults, and must not have conditions.
     *
     * Priorities must be unique.
     *
     * @default Target groups are used as defaults
     * @experimental
     */
    readonly priority?: number;
    /**
     * (experimental) Rule applies if matches the conditions.
     *
     * @default - No conditions.
     * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html
     * @experimental
     */
    readonly conditions?: ListenerCondition[];
    /**
     * (deprecated) Rule applies if the requested host matches the indicated host.
     *
     * May contain up to three '*' wildcards.
     *
     * Requires that priority is set.
     *
     * @default No host condition
     * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#host-conditions
     * @deprecated Use `conditions` instead.
     */
    readonly hostHeader?: string;
    /**
     * (deprecated) Rule applies if the requested path matches the given path pattern.
     *
     * May contain up to three '*' wildcards.
     *
     * Requires that priority is set.
     *
     * @default No path condition
     * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#path-conditions
     * @deprecated Use `conditions` instead.
     */
    readonly pathPattern?: string;
    /**
     * (deprecated) Rule applies if the requested path matches any of the given patterns.
     *
     * May contain up to three '*' wildcards.
     *
     * Requires that priority is set.
     *
     * @default - No path condition.
     * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#path-conditions
     * @deprecated Use `conditions` instead.
     */
    readonly pathPatterns?: string[];
}
/**
 * (experimental) Properties for adding a new target group to a listener.
 *
 * @experimental
 */
export interface AddApplicationTargetGroupsProps extends AddRuleProps {
    /**
     * (experimental) Target groups to forward requests to.
     *
     * @experimental
     */
    readonly targetGroups: IApplicationTargetGroup[];
}
/**
 * (experimental) Properties for adding a new action to a listener.
 *
 * @experimental
 */
export interface AddApplicationActionProps extends AddRuleProps {
    /**
     * (experimental) Action to perform.
     *
     * @experimental
     */
    readonly action: ListenerAction;
}
/**
 * (experimental) Properties for adding new targets to a listener.
 *
 * @experimental
 */
export interface AddApplicationTargetsProps extends AddRuleProps {
    /**
     * (experimental) The protocol to use.
     *
     * @default Determined from port if known
     * @experimental
     */
    readonly protocol?: ApplicationProtocol;
    /**
     * (experimental) The port on which the listener listens for requests.
     *
     * @default Determined from protocol if known
     * @experimental
     */
    readonly port?: number;
    /**
     * (experimental) The time period during which the load balancer sends a newly registered target a linearly increasing share of the traffic to the target group.
     *
     * The range is 30-900 seconds (15 minutes).
     *
     * @default 0
     * @experimental
     */
    readonly slowStart?: Duration;
    /**
     * (experimental) The stickiness cookie expiration period.
     *
     * Setting this value enables load balancer stickiness.
     *
     * After this period, the cookie is considered stale. The minimum value is
     * 1 second and the maximum value is 7 days (604800 seconds).
     *
     * @default Stickiness disabled
     * @experimental
     */
    readonly stickinessCookieDuration?: Duration;
    /**
     * (experimental) The targets to add to this target group.
     *
     * Can be `Instance`, `IPAddress`, or any self-registering load balancing
     * target. All target must be of the same type.
     *
     * @experimental
     */
    readonly targets?: IApplicationLoadBalancerTarget[];
    /**
     * (experimental) The name of the target group.
     *
     * This name must be unique per region per account, can have a maximum of
     * 32 characters, must contain only alphanumeric characters or hyphens, and
     * must not begin or end with a hyphen.
     *
     * @default Automatically generated
     * @experimental
     */
    readonly targetGroupName?: string;
    /**
     * (experimental) The amount of time for Elastic Load Balancing to wait before deregistering a target.
     *
     * The range is 0-3600 seconds.
     *
     * @default Duration.minutes(5)
     * @experimental
     */
    readonly deregistrationDelay?: Duration;
    /**
     * (experimental) Health check configuration.
     *
     * @default No health check
     * @experimental
     */
    readonly healthCheck?: HealthCheck;
}
/**
 * (deprecated) Properties for adding a fixed response to a listener.
 *
 * @deprecated Use `ApplicationListener.addAction` instead.
 */
export interface AddFixedResponseProps extends AddRuleProps, FixedResponse {
}
/**
 * (deprecated) Properties for adding a redirect response to a listener.
 *
 * @deprecated Use `ApplicationListener.addAction` instead.
 */
export interface AddRedirectResponseProps extends AddRuleProps, RedirectResponse {
}
