import { Construct, Duration, IConstruct, SecretValue } from "../../../core";
import { CfnListener } from '../elasticloadbalancingv2.generated';
import { IListenerAction } from '../shared/listener-action';
import { IApplicationListener } from './application-listener';
import { IApplicationTargetGroup } from './application-target-group';
/**
 * (experimental) What to do when a client makes a request to a listener.
 *
 * Some actions can be combined with other ones (specifically,
 * you can perform authentication before serving the request).
 *
 * Multiple actions form a linked chain; the chain must always terminate in a
 * *(weighted)forward*, *fixedResponse* or *redirect* action.
 *
 * If an action supports chaining, the next action can be indicated
 * by passing it in the `next` property.
 *
 * (Called `ListenerAction` instead of the more strictly correct
 * `ListenerAction` because this is the class most users interact
 * with, and we want to make it not too visually overwhelming).
 *
 * @experimental
 */
export declare class ListenerAction implements IListenerAction {
    private readonly actionJson;
    protected readonly next?: ListenerAction | undefined;
    /**
     * (experimental) Authenticate using an identity provider (IdP) that is compliant with OpenID Connect (OIDC).
     *
     * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/listener-authenticate-users.html#oidc-requirements
     * @experimental
     */
    static authenticateOidc(options: AuthenticateOidcOptions): ListenerAction;
    /**
     * (experimental) Forward to one or more Target Groups.
     *
     * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#forward-actions
     * @experimental
     */
    static forward(targetGroups: IApplicationTargetGroup[], options?: ForwardOptions): ListenerAction;
    /**
     * (experimental) Forward to one or more Target Groups which are weighted differently.
     *
     * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#forward-actions
     * @experimental
     */
    static weightedForward(targetGroups: WeightedTargetGroup[], options?: ForwardOptions): ListenerAction;
    /**
     * (experimental) Return a fixed response.
     *
     * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#fixed-response-actions
     * @experimental
     */
    static fixedResponse(statusCode: number, options?: FixedResponseOptions): ListenerAction;
    /**
     * (experimental) Redirect to a different URI.
     *
     * A URI consists of the following components:
     * protocol://hostname:port/path?query. You must modify at least one of the
     * following components to avoid a redirect loop: protocol, hostname, port, or
     * path. Any components that you do not modify retain their original values.
     *
     * You can reuse URI components using the following reserved keywords:
     *
     * - `#{protocol}`
     * - `#{host}`
     * - `#{port}`
     * - `#{path}` (the leading "/" is removed)
     * - `#{query}`
     *
     * For example, you can change the path to "/new/#{path}", the hostname to
     * "example.#{host}", or the query to "#{query}&value=xyz".
     *
     * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#redirect-actions
     * @experimental
     */
    static redirect(options: RedirectOptions): ListenerAction;
    /**
     * (experimental) Create an instance of ListenerAction.
     *
     * The default class should be good enough for most cases and
     * should be created by using one of the static factory functions,
     * but allow overriding to make sure we allow flexibility for the future.
     *
     * @experimental
     */
    protected constructor(actionJson: CfnListener.ActionProperty, next?: ListenerAction | undefined);
    /**
     * (experimental) Render the actions in this chain.
     *
     * @experimental
     */
    renderActions(): CfnListener.ActionProperty[];
    /**
     * (experimental) Called when the action is being used in a listener.
     *
     * @experimental
     */
    bind(scope: Construct, listener: IApplicationListener, associatingConstruct?: IConstruct): void;
    /**
     * (experimental) Renumber the "order" fields in the actions array.
     *
     * We don't number for 0 or 1 elements, but otherwise number them 1...#actions
     * so ELB knows about the right order.
     *
     * Do this in `ListenerAction` instead of in `Listener` so that we give
     * users the opportunity to override by subclassing and overriding `renderActions`.
     *
     * @experimental
     */
    protected renumber(actions: CfnListener.ActionProperty[]): CfnListener.ActionProperty[];
}
/**
 * (experimental) Options for `ListenerAction.forward()`.
 *
 * @experimental
 */
export interface ForwardOptions {
    /**
     * (experimental) For how long clients should be directed to the same target group.
     *
     * Range between 1 second and 7 days.
     *
     * @default - No stickiness
     * @experimental
     */
    readonly stickinessDuration?: Duration;
}
/**
 * (experimental) A Target Group and weight combination.
 *
 * @experimental
 */
export interface WeightedTargetGroup {
    /**
     * (experimental) The target group.
     *
     * @experimental
     */
    readonly targetGroup: IApplicationTargetGroup;
    /**
     * (experimental) The target group's weight.
     *
     * Range is [0..1000).
     *
     * @default 1
     * @experimental
     */
    readonly weight?: number;
}
/**
 * (experimental) Options for `ListenerAction.fixedResponse()`.
 *
 * @experimental
 */
export interface FixedResponseOptions {
    /**
     * (experimental) Content Type of the response.
     *
     * Valid Values: text/plain | text/css | text/html | application/javascript | application/json
     *
     * @default - Automatically determined
     * @experimental
     */
    readonly contentType?: string;
    /**
     * (experimental) The response body.
     *
     * @default - No body
     * @experimental
     */
    readonly messageBody?: string;
}
/**
 * (experimental) Options for `ListenerAction.redirect()`.
 *
 * A URI consists of the following components:
 * protocol://hostname:port/path?query. You must modify at least one of the
 * following components to avoid a redirect loop: protocol, hostname, port, or
 * path. Any components that you do not modify retain their original values.
 *
 * You can reuse URI components using the following reserved keywords:
 *
 * - `#{protocol}`
 * - `#{host}`
 * - `#{port}`
 * - `#{path}` (the leading "/" is removed)
 * - `#{query}`
 *
 * For example, you can change the path to "/new/#{path}", the hostname to
 * "example.#{host}", or the query to "#{query}&value=xyz".
 *
 * @experimental
 */
export interface RedirectOptions {
    /**
     * (experimental) The hostname.
     *
     * This component is not percent-encoded. The hostname can contain #{host}.
     *
     * @default - No change
     * @experimental
     */
    readonly host?: string;
    /**
     * (experimental) The absolute path, starting with the leading "/".
     *
     * This component is not percent-encoded. The path can contain #{host}, #{path}, and #{port}.
     *
     * @default - No change
     * @experimental
     */
    readonly path?: string;
    /**
     * (experimental) The port.
     *
     * You can specify a value from 1 to 65535 or #{port}.
     *
     * @default - No change
     * @experimental
     */
    readonly port?: string;
    /**
     * (experimental) The protocol.
     *
     * You can specify HTTP, HTTPS, or #{protocol}. You can redirect HTTP to HTTP, HTTP to HTTPS, and HTTPS to HTTPS. You cannot redirect HTTPS to HTTP.
     *
     * @default - No change
     * @experimental
     */
    readonly protocol?: string;
    /**
     * (experimental) The query parameters, URL-encoded when necessary, but not percent-encoded.
     *
     * Do not include the leading "?", as it is automatically added. You can specify any of the reserved keywords.
     *
     * @default - No change
     * @experimental
     */
    readonly query?: string;
    /**
     * (experimental) The HTTP redirect code.
     *
     * The redirect is either permanent (HTTP 301) or temporary (HTTP 302).
     *
     * @default false
     * @experimental
     */
    readonly permanent?: boolean;
}
/**
 * (experimental) Options for `ListenerAction.authenciateOidc()`.
 *
 * @experimental
 */
export interface AuthenticateOidcOptions {
    /**
     * (experimental) What action to execute next.
     *
     * @experimental
     */
    readonly next: ListenerAction;
    /**
     * (experimental) The query parameters (up to 10) to include in the redirect request to the authorization endpoint.
     *
     * @default - No extra parameters
     * @experimental
     */
    readonly authenticationRequestExtraParams?: Record<string, string>;
    /**
     * (experimental) The authorization endpoint of the IdP.
     *
     * This must be a full URL, including the HTTPS protocol, the domain, and the path.
     *
     * @experimental
     */
    readonly authorizationEndpoint: string;
    /**
     * (experimental) The OAuth 2.0 client identifier.
     *
     * @experimental
     */
    readonly clientId: string;
    /**
     * (experimental) The OAuth 2.0 client secret.
     *
     * @experimental
     */
    readonly clientSecret: SecretValue;
    /**
     * (experimental) The OIDC issuer identifier of the IdP.
     *
     * This must be a full URL, including the HTTPS protocol, the domain, and the path.
     *
     * @experimental
     */
    readonly issuer: string;
    /**
     * (experimental) The behavior if the user is not authenticated.
     *
     * @default UnauthenticatedAction.AUTHENTICATE
     * @experimental
     */
    readonly onUnauthenticatedRequest?: UnauthenticatedAction;
    /**
     * (experimental) The set of user claims to be requested from the IdP.
     *
     * To verify which scope values your IdP supports and how to separate multiple values, see the documentation for your IdP.
     *
     * @default "openid"
     * @experimental
     */
    readonly scope?: string;
    /**
     * (experimental) The name of the cookie used to maintain session information.
     *
     * @default "AWSELBAuthSessionCookie"
     * @experimental
     */
    readonly sessionCookieName?: string;
    /**
     * (experimental) The maximum duration of the authentication session.
     *
     * @default Duration.days(7)
     * @experimental
     */
    readonly sessionTimeout?: Duration;
    /**
     * (experimental) The token endpoint of the IdP.
     *
     * This must be a full URL, including the HTTPS protocol, the domain, and the path.
     *
     * @experimental
     */
    readonly tokenEndpoint: string;
    /**
     * (experimental) The user info endpoint of the IdP.
     *
     * This must be a full URL, including the HTTPS protocol, the domain, and the path.
     *
     * @experimental
     */
    readonly userInfoEndpoint: string;
}
/**
 * (experimental) What to do with unauthenticated requests.
 *
 * @experimental
 */
export declare enum UnauthenticatedAction {
    /**
     * (experimental) Return an HTTP 401 Unauthorized error.
     *
     * @experimental
     */
    DENY = "deny",
    /**
     * (experimental) Allow the request to be forwarded to the target.
     *
     * @experimental
     */
    ALLOW = "allow",
    /**
     * (experimental) Redirect the request to the IdP authorization endpoint.
     *
     * @experimental
     */
    AUTHENTICATE = "authenticate"
}
