import * as cognito from "../../aws-cognito";
import * as elbv2 from "../../aws-elasticloadbalancingv2";
import { Duration } from "../../core";
/**
 * (experimental) Properties for AuthenticateCognitoAction.
 *
 * @experimental
 */
export interface AuthenticateCognitoActionProps {
    /**
     * (experimental) What action to execute next.
     *
     * Multiple actions form a linked chain; the chain must always terminate in a
     * (weighted)forward, fixedResponse or redirect action.
     *
     * @experimental
     */
    readonly next: elbv2.ListenerAction;
    /**
     * (experimental) The Amazon Cognito user pool.
     *
     * @experimental
     */
    readonly userPool: cognito.IUserPool;
    /**
     * (experimental) The Amazon Cognito user pool client.
     *
     * @experimental
     */
    readonly userPoolClient: cognito.IUserPoolClient;
    /**
     * (experimental) The domain prefix or fully-qualified domain name of the Amazon Cognito user pool.
     *
     * @experimental
     */
    readonly userPoolDomain: cognito.IUserPoolDomain;
    /**
     * (experimental) The query parameters (up to 10) to include in the redirect request to the authorization endpoint.
     *
     * @default - No extra parameters
     * @experimental
     */
    readonly authenticationRequestExtraParams?: Record<string, string>;
    /**
     * (experimental) The behavior if the user is not authenticated.
     *
     * @default UnauthenticatedAction.AUTHENTICATE
     * @experimental
     */
    readonly onUnauthenticatedRequest?: elbv2.UnauthenticatedAction;
    /**
     * (experimental) The set of user claims to be requested from the IdP.
     *
     * To verify which scope values your IdP supports and how to separate multiple values, see the documentation for your IdP.
     *
     * @default "openid"
     * @experimental
     */
    readonly scope?: string;
    /**
     * (experimental) The name of the cookie used to maintain session information.
     *
     * @default "AWSELBAuthSessionCookie"
     * @experimental
     */
    readonly sessionCookieName?: string;
    /**
     * (experimental) The maximum duration of the authentication session.
     *
     * @default Duration.days(7)
     * @experimental
     */
    readonly sessionTimeout?: Duration;
}
/**
 * (experimental) A Listener Action to authenticate with Cognito.
 *
 * @experimental
 */
export declare class AuthenticateCognitoAction extends elbv2.ListenerAction {
    /**
     * (experimental) Authenticate using an identity provide (IdP) that is compliant with OpenID Connect (OIDC).
     *
     * @experimental
     */
    constructor(options: AuthenticateCognitoActionProps);
}
