import { Connections, IConnectable, ISecurityGroup, IVpc, Port, SubnetSelection } from "../../aws-ec2";
import { Duration, Resource } from "../../core";
import { Construct } from 'constructs';
/**
 * (experimental) Construction properties for a LoadBalancer.
 *
 * @experimental
 */
export interface LoadBalancerProps {
    /**
     * (experimental) VPC network of the fleet instances.
     *
     * @experimental
     */
    readonly vpc: IVpc;
    /**
     * (experimental) Whether this is an internet-facing Load Balancer.
     *
     * This controls whether the LB has a public IP address assigned. It does
     * not open up the Load Balancer's security groups to public internet access.
     *
     * @default false
     * @experimental
     */
    readonly internetFacing?: boolean;
    /**
     * (experimental) What listeners to set up for the load balancer.
     *
     * Can also be added by .addListener()
     *
     * @default -
     * @experimental
     */
    readonly listeners?: LoadBalancerListener[];
    /**
     * (experimental) What targets to load balance to.
     *
     * Can also be added by .addTarget()
     *
     * @default - None.
     * @experimental
     */
    readonly targets?: ILoadBalancerTarget[];
    /**
     * (experimental) Health check settings for the load balancing targets.
     *
     * Not required but recommended.
     *
     * @default - None.
     * @experimental
     */
    readonly healthCheck?: HealthCheck;
    /**
     * (experimental) Whether cross zone load balancing is enabled.
     *
     * This controls whether the load balancer evenly distributes requests
     * across each availability zone
     *
     * @default true
     * @experimental
     */
    readonly crossZone?: boolean;
    /**
     * (experimental) Which subnets to deploy the load balancer.
     *
     * Can be used to define a specific set of subnets to deploy the load balancer to.
     * Useful multiple public or private subnets are covering the same availability zone.
     *
     * @default - Public subnets if internetFacing, Private subnets otherwise
     * @experimental
     */
    readonly subnetSelection?: SubnetSelection;
}
/**
 * (experimental) Describe the health check to a load balancer.
 *
 * @experimental
 */
export interface HealthCheck {
    /**
     * (experimental) What port number to health check on.
     *
     * @experimental
     */
    readonly port: number;
    /**
     * (experimental) What protocol to use for health checking.
     *
     * The protocol is automatically determined from the port if it's not supplied.
     *
     * @default Automatic
     * @experimental
     */
    readonly protocol?: LoadBalancingProtocol;
    /**
     * (experimental) What path to use for HTTP or HTTPS health check (must return 200).
     *
     * For SSL and TCP health checks, accepting connections is enough to be considered
     * healthy.
     *
     * @default "/"
     * @experimental
     */
    readonly path?: string;
    /**
     * (experimental) After how many successful checks is an instance considered healthy.
     *
     * @default 2
     * @experimental
     */
    readonly healthyThreshold?: number;
    /**
     * (experimental) After how many unsuccessful checks is an instance considered unhealthy.
     *
     * @default 5
     * @experimental
     */
    readonly unhealthyThreshold?: number;
    /**
     * (experimental) Number of seconds between health checks.
     *
     * @default Duration.seconds(30)
     * @experimental
     */
    readonly interval?: Duration;
    /**
     * (experimental) Health check timeout.
     *
     * @default Duration.seconds(5)
     * @experimental
     */
    readonly timeout?: Duration;
}
/**
 * (experimental) Interface that is going to be implemented by constructs that you can load balance to.
 *
 * @experimental
 */
export interface ILoadBalancerTarget extends IConnectable {
    /**
     * (experimental) Attach load-balanced target to a classic ELB.
     *
     * @param loadBalancer [disable-awslint:ref-via-interface] The load balancer to attach the target to.
     * @experimental
     */
    attachToClassicLB(loadBalancer: LoadBalancer): void;
}
/**
 * (experimental) Add a backend to the load balancer.
 *
 * @experimental
 */
export interface LoadBalancerListener {
    /**
     * (experimental) External listening port.
     *
     * @experimental
     */
    readonly externalPort: number;
    /**
     * (experimental) What public protocol to use for load balancing.
     *
     * Either 'tcp', 'ssl', 'http' or 'https'.
     *
     * May be omitted if the external port is either 80 or 443.
     *
     * @experimental
     */
    readonly externalProtocol?: LoadBalancingProtocol;
    /**
     * (experimental) Instance listening port.
     *
     * Same as the externalPort if not specified.
     *
     * @default externalPort
     * @experimental
     */
    readonly internalPort?: number;
    /**
     * (experimental) What public protocol to use for load balancing.
     *
     * Either 'tcp', 'ssl', 'http' or 'https'.
     *
     * May be omitted if the internal port is either 80 or 443.
     *
     * The instance protocol is 'tcp' if the front-end protocol
     * is 'tcp' or 'ssl', the instance protocol is 'http' if the
     * front-end protocol is 'https'.
     *
     * @experimental
     */
    readonly internalProtocol?: LoadBalancingProtocol;
    /**
     * (experimental) SSL policy names.
     *
     * @experimental
     */
    readonly policyNames?: string[];
    /**
     * (experimental) ID of SSL certificate.
     *
     * @experimental
     */
    readonly sslCertificateId?: string;
    /**
     * (experimental) Allow connections to the load balancer from the given set of connection peers.
     *
     * By default, connections will be allowed from anywhere. Set this to an empty list
     * to deny connections, or supply a custom list of peers to allow connections from
     * (IP ranges or security groups).
     *
     * @default Anywhere
     * @experimental
     */
    readonly allowConnectionsFrom?: IConnectable[];
}
/**
 * @experimental
 */
export declare enum LoadBalancingProtocol {
    /**
     * @experimental
     */
    TCP = "tcp",
    /**
     * @experimental
     */
    SSL = "ssl",
    /**
     * @experimental
     */
    HTTP = "http",
    /**
     * @experimental
     */
    HTTPS = "https"
}
/**
 * (experimental) A load balancer with a single listener.
 *
 * Routes to a fleet of of instances in a VPC.
 *
 * @experimental
 */
export declare class LoadBalancer extends Resource implements IConnectable {
    /**
     * (experimental) Control all connections from and to this load balancer.
     *
     * @experimental
     */
    readonly connections: Connections;
    /**
     * (experimental) An object controlling specifically the connections for each listener added to this load balancer.
     *
     * @experimental
     */
    readonly listenerPorts: ListenerPort[];
    private readonly elb;
    private readonly securityGroup;
    private readonly listeners;
    private readonly instancePorts;
    private readonly targets;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: LoadBalancerProps);
    /**
     * (experimental) Add a backend to the load balancer.
     *
     * @returns A ListenerPort object that controls connections to the listener port
     * @experimental
     */
    addListener(listener: LoadBalancerListener): ListenerPort;
    /**
     * @experimental
     */
    addTarget(target: ILoadBalancerTarget): void;
    /**
     * @experimental
     * @attribute true
     */
    get loadBalancerName(): string;
    /**
     * @experimental
     * @attribute true
     */
    get loadBalancerCanonicalHostedZoneNameId(): string;
    /**
     * @experimental
     * @attribute true
     */
    get loadBalancerCanonicalHostedZoneName(): string;
    /**
     * @experimental
     * @attribute true
     */
    get loadBalancerDnsName(): string;
    /**
     * @experimental
     * @attribute true
     */
    get loadBalancerSourceSecurityGroupGroupName(): string;
    /**
     * @experimental
     * @attribute true
     */
    get loadBalancerSourceSecurityGroupOwnerAlias(): string;
    /**
     * Allow connections to all existing targets on new instance port
     */
    private newInstancePort;
    /**
     * Allow connections to target on all existing instance ports
     */
    private newTarget;
    /**
     * Allow connections for a single (port, target) pair
     */
    private allowTargetConnection;
}
/**
 * (experimental) Reference to a listener's port just created.
 *
 * This implements IConnectable with a default port (the port that an ELB
 * listener was just created on) for a given security group so that it can be
 * conveniently used just like any Connectable. E.g:
 *
 *     const listener = elb.addListener(...);
 *
 *     listener.connections.allowDefaultPortFromAnyIPv4();
 *     // or
 *     instance.connections.allowToDefaultPort(listener);
 *
 * @experimental
 */
export declare class ListenerPort implements IConnectable {
    /**
     * @experimental
     */
    readonly connections: Connections;
    /**
     * @experimental
     */
    constructor(securityGroup: ISecurityGroup, defaultPort: Port);
}
