import * as cdk from "../../core";
import * as cfn_parse from "../../core/lib/cfn-parse";
/**
 * Properties for defining a `AWS::ElasticLoadBalancing::LoadBalancer`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html
 * @external
 */
export interface CfnLoadBalancerProps {
    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.Listeners`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-listeners
     * @external
     */
    readonly listeners: Array<CfnLoadBalancer.ListenersProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.AccessLoggingPolicy`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-accessloggingpolicy
     * @external
     */
    readonly accessLoggingPolicy?: CfnLoadBalancer.AccessLoggingPolicyProperty | cdk.IResolvable;
    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.AppCookieStickinessPolicy`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-appcookiestickinesspolicy
     * @external
     */
    readonly appCookieStickinessPolicy?: Array<CfnLoadBalancer.AppCookieStickinessPolicyProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.AvailabilityZones`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-availabilityzones
     * @external
     */
    readonly availabilityZones?: string[];
    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.ConnectionDrainingPolicy`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-connectiondrainingpolicy
     * @external
     */
    readonly connectionDrainingPolicy?: CfnLoadBalancer.ConnectionDrainingPolicyProperty | cdk.IResolvable;
    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.ConnectionSettings`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-connectionsettings
     * @external
     */
    readonly connectionSettings?: CfnLoadBalancer.ConnectionSettingsProperty | cdk.IResolvable;
    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.CrossZone`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-crosszone
     * @external
     */
    readonly crossZone?: boolean | cdk.IResolvable;
    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.HealthCheck`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-healthcheck
     * @external
     */
    readonly healthCheck?: CfnLoadBalancer.HealthCheckProperty | cdk.IResolvable;
    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.Instances`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-instances
     * @external
     */
    readonly instances?: string[];
    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.LBCookieStickinessPolicy`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-lbcookiestickinesspolicy
     * @external
     */
    readonly lbCookieStickinessPolicy?: Array<CfnLoadBalancer.LBCookieStickinessPolicyProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.LoadBalancerName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-elbname
     * @external
     */
    readonly loadBalancerName?: string;
    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.Policies`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-policies
     * @external
     */
    readonly policies?: Array<CfnLoadBalancer.PoliciesProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.Scheme`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-scheme
     * @external
     */
    readonly scheme?: string;
    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.SecurityGroups`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-securitygroups
     * @external
     */
    readonly securityGroups?: string[];
    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.Subnets`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-subnets
     * @external
     */
    readonly subnets?: string[];
    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-elasticloadbalancing-loadbalancer-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::ElasticLoadBalancing::LoadBalancer`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html
 * @external
 * @cloudformationResource AWS::ElasticLoadBalancing::LoadBalancer
 */
export declare class CfnLoadBalancer extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ElasticLoadBalancing::LoadBalancer";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnLoadBalancer;
    /**
     * @external
     * @cloudformationAttribute CanonicalHostedZoneName
     */
    readonly attrCanonicalHostedZoneName: string;
    /**
     * @external
     * @cloudformationAttribute CanonicalHostedZoneNameID
     */
    readonly attrCanonicalHostedZoneNameId: string;
    /**
     * @external
     * @cloudformationAttribute DNSName
     */
    readonly attrDnsName: string;
    /**
     * @external
     * @cloudformationAttribute SourceSecurityGroup.GroupName
     */
    readonly attrSourceSecurityGroupGroupName: string;
    /**
     * @external
     * @cloudformationAttribute SourceSecurityGroup.OwnerAlias
     */
    readonly attrSourceSecurityGroupOwnerAlias: string;
    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.Listeners`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-listeners
     * @external
     */
    listeners: Array<CfnLoadBalancer.ListenersProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.AccessLoggingPolicy`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-accessloggingpolicy
     * @external
     */
    accessLoggingPolicy: CfnLoadBalancer.AccessLoggingPolicyProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.AppCookieStickinessPolicy`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-appcookiestickinesspolicy
     * @external
     */
    appCookieStickinessPolicy: Array<CfnLoadBalancer.AppCookieStickinessPolicyProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.AvailabilityZones`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-availabilityzones
     * @external
     */
    availabilityZones: string[] | undefined;
    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.ConnectionDrainingPolicy`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-connectiondrainingpolicy
     * @external
     */
    connectionDrainingPolicy: CfnLoadBalancer.ConnectionDrainingPolicyProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.ConnectionSettings`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-connectionsettings
     * @external
     */
    connectionSettings: CfnLoadBalancer.ConnectionSettingsProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.CrossZone`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-crosszone
     * @external
     */
    crossZone: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.HealthCheck`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-healthcheck
     * @external
     */
    healthCheck: CfnLoadBalancer.HealthCheckProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.Instances`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-instances
     * @external
     */
    instances: string[] | undefined;
    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.LBCookieStickinessPolicy`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-lbcookiestickinesspolicy
     * @external
     */
    lbCookieStickinessPolicy: Array<CfnLoadBalancer.LBCookieStickinessPolicyProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.LoadBalancerName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-elbname
     * @external
     */
    loadBalancerName: string | undefined;
    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.Policies`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-policies
     * @external
     */
    policies: Array<CfnLoadBalancer.PoliciesProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.Scheme`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-scheme
     * @external
     */
    scheme: string | undefined;
    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.SecurityGroups`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-securitygroups
     * @external
     */
    securityGroups: string[] | undefined;
    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.Subnets`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-subnets
     * @external
     */
    subnets: string[] | undefined;
    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-elasticloadbalancing-loadbalancer-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::ElasticLoadBalancing::LoadBalancer`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnLoadBalancerProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::ElasticLoadBalancing::LoadBalancer`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html
 * @external
 * @cloudformationResource AWS::ElasticLoadBalancing::LoadBalancer
 */
export declare namespace CfnLoadBalancer {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-accessloggingpolicy.html
     * @external
     */
    interface AccessLoggingPolicyProperty {
        /**
         * `CfnLoadBalancer.AccessLoggingPolicyProperty.EmitInterval`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-accessloggingpolicy.html#cfn-elb-accessloggingpolicy-emitinterval
         * @external
         */
        readonly emitInterval?: number;
        /**
         * `CfnLoadBalancer.AccessLoggingPolicyProperty.Enabled`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-accessloggingpolicy.html#cfn-elb-accessloggingpolicy-enabled
         * @external
         */
        readonly enabled: boolean | cdk.IResolvable;
        /**
         * `CfnLoadBalancer.AccessLoggingPolicyProperty.S3BucketName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-accessloggingpolicy.html#cfn-elb-accessloggingpolicy-s3bucketname
         * @external
         */
        readonly s3BucketName: string;
        /**
         * `CfnLoadBalancer.AccessLoggingPolicyProperty.S3BucketPrefix`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-accessloggingpolicy.html#cfn-elb-accessloggingpolicy-s3bucketprefix
         * @external
         */
        readonly s3BucketPrefix?: string;
    }
}
/**
 * A CloudFormation `AWS::ElasticLoadBalancing::LoadBalancer`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html
 * @external
 * @cloudformationResource AWS::ElasticLoadBalancing::LoadBalancer
 */
export declare namespace CfnLoadBalancer {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-AppCookieStickinessPolicy.html
     * @external
     */
    interface AppCookieStickinessPolicyProperty {
        /**
         * `CfnLoadBalancer.AppCookieStickinessPolicyProperty.CookieName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-AppCookieStickinessPolicy.html#cfn-elb-appcookiestickinesspolicy-cookiename
         * @external
         */
        readonly cookieName: string;
        /**
         * `CfnLoadBalancer.AppCookieStickinessPolicyProperty.PolicyName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-AppCookieStickinessPolicy.html#cfn-elb-appcookiestickinesspolicy-policyname
         * @external
         */
        readonly policyName: string;
    }
}
/**
 * A CloudFormation `AWS::ElasticLoadBalancing::LoadBalancer`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html
 * @external
 * @cloudformationResource AWS::ElasticLoadBalancing::LoadBalancer
 */
export declare namespace CfnLoadBalancer {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-connectiondrainingpolicy.html
     * @external
     */
    interface ConnectionDrainingPolicyProperty {
        /**
         * `CfnLoadBalancer.ConnectionDrainingPolicyProperty.Enabled`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-connectiondrainingpolicy.html#cfn-elb-connectiondrainingpolicy-enabled
         * @external
         */
        readonly enabled: boolean | cdk.IResolvable;
        /**
         * `CfnLoadBalancer.ConnectionDrainingPolicyProperty.Timeout`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-connectiondrainingpolicy.html#cfn-elb-connectiondrainingpolicy-timeout
         * @external
         */
        readonly timeout?: number;
    }
}
/**
 * A CloudFormation `AWS::ElasticLoadBalancing::LoadBalancer`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html
 * @external
 * @cloudformationResource AWS::ElasticLoadBalancing::LoadBalancer
 */
export declare namespace CfnLoadBalancer {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-connectionsettings.html
     * @external
     */
    interface ConnectionSettingsProperty {
        /**
         * `CfnLoadBalancer.ConnectionSettingsProperty.IdleTimeout`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-connectionsettings.html#cfn-elb-connectionsettings-idletimeout
         * @external
         */
        readonly idleTimeout: number;
    }
}
/**
 * A CloudFormation `AWS::ElasticLoadBalancing::LoadBalancer`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html
 * @external
 * @cloudformationResource AWS::ElasticLoadBalancing::LoadBalancer
 */
export declare namespace CfnLoadBalancer {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-health-check.html
     * @external
     */
    interface HealthCheckProperty {
        /**
         * `CfnLoadBalancer.HealthCheckProperty.HealthyThreshold`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-health-check.html#cfn-elb-healthcheck-healthythreshold
         * @external
         */
        readonly healthyThreshold: string;
        /**
         * `CfnLoadBalancer.HealthCheckProperty.Interval`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-health-check.html#cfn-elb-healthcheck-interval
         * @external
         */
        readonly interval: string;
        /**
         * `CfnLoadBalancer.HealthCheckProperty.Target`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-health-check.html#cfn-elb-healthcheck-target
         * @external
         */
        readonly target: string;
        /**
         * `CfnLoadBalancer.HealthCheckProperty.Timeout`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-health-check.html#cfn-elb-healthcheck-timeout
         * @external
         */
        readonly timeout: string;
        /**
         * `CfnLoadBalancer.HealthCheckProperty.UnhealthyThreshold`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-health-check.html#cfn-elb-healthcheck-unhealthythreshold
         * @external
         */
        readonly unhealthyThreshold: string;
    }
}
/**
 * A CloudFormation `AWS::ElasticLoadBalancing::LoadBalancer`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html
 * @external
 * @cloudformationResource AWS::ElasticLoadBalancing::LoadBalancer
 */
export declare namespace CfnLoadBalancer {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-LBCookieStickinessPolicy.html
     * @external
     */
    interface LBCookieStickinessPolicyProperty {
        /**
         * `CfnLoadBalancer.LBCookieStickinessPolicyProperty.CookieExpirationPeriod`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-LBCookieStickinessPolicy.html#cfn-elb-lbcookiestickinesspolicy-cookieexpirationperiod
         * @external
         */
        readonly cookieExpirationPeriod?: string;
        /**
         * `CfnLoadBalancer.LBCookieStickinessPolicyProperty.PolicyName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-LBCookieStickinessPolicy.html#cfn-elb-lbcookiestickinesspolicy-policyname
         * @external
         */
        readonly policyName?: string;
    }
}
/**
 * A CloudFormation `AWS::ElasticLoadBalancing::LoadBalancer`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html
 * @external
 * @cloudformationResource AWS::ElasticLoadBalancing::LoadBalancer
 */
export declare namespace CfnLoadBalancer {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-listener.html
     * @external
     */
    interface ListenersProperty {
        /**
         * `CfnLoadBalancer.ListenersProperty.InstancePort`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-listener.html#cfn-ec2-elb-listener-instanceport
         * @external
         */
        readonly instancePort: string;
        /**
         * `CfnLoadBalancer.ListenersProperty.InstanceProtocol`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-listener.html#cfn-ec2-elb-listener-instanceprotocol
         * @external
         */
        readonly instanceProtocol?: string;
        /**
         * `CfnLoadBalancer.ListenersProperty.LoadBalancerPort`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-listener.html#cfn-ec2-elb-listener-loadbalancerport
         * @external
         */
        readonly loadBalancerPort: string;
        /**
         * `CfnLoadBalancer.ListenersProperty.PolicyNames`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-listener.html#cfn-ec2-elb-listener-policynames
         * @external
         */
        readonly policyNames?: string[];
        /**
         * `CfnLoadBalancer.ListenersProperty.Protocol`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-listener.html#cfn-ec2-elb-listener-protocol
         * @external
         */
        readonly protocol: string;
        /**
         * `CfnLoadBalancer.ListenersProperty.SSLCertificateId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-listener.html#cfn-ec2-elb-listener-sslcertificateid
         * @external
         */
        readonly sslCertificateId?: string;
    }
}
/**
 * A CloudFormation `AWS::ElasticLoadBalancing::LoadBalancer`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html
 * @external
 * @cloudformationResource AWS::ElasticLoadBalancing::LoadBalancer
 */
export declare namespace CfnLoadBalancer {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-policy.html
     * @external
     */
    interface PoliciesProperty {
        /**
         * `CfnLoadBalancer.PoliciesProperty.Attributes`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-policy.html#cfn-ec2-elb-policy-attributes
         * @external
         */
        readonly attributes: Array<any | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnLoadBalancer.PoliciesProperty.InstancePorts`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-policy.html#cfn-ec2-elb-policy-instanceports
         * @external
         */
        readonly instancePorts?: string[];
        /**
         * `CfnLoadBalancer.PoliciesProperty.LoadBalancerPorts`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-policy.html#cfn-ec2-elb-policy-loadbalancerports
         * @external
         */
        readonly loadBalancerPorts?: string[];
        /**
         * `CfnLoadBalancer.PoliciesProperty.PolicyName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-policy.html#cfn-ec2-elb-policy-policyname
         * @external
         */
        readonly policyName: string;
        /**
         * `CfnLoadBalancer.PoliciesProperty.PolicyType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-policy.html#cfn-ec2-elb-policy-policytype
         * @external
         */
        readonly policyType: string;
    }
}
