import * as cdk from "../../core";
import * as cfn_parse from "../../core/lib/cfn-parse";
/**
 * Properties for defining a `AWS::ElastiCache::CacheCluster`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-cache-cluster.html
 * @external
 */
export interface CfnCacheClusterProps {
    /**
     * `AWS::ElastiCache::CacheCluster.CacheNodeType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-cache-cluster.html#cfn-elasticache-cachecluster-cachenodetype
     * @external
     */
    readonly cacheNodeType: string;
    /**
     * `AWS::ElastiCache::CacheCluster.Engine`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-cache-cluster.html#cfn-elasticache-cachecluster-engine
     * @external
     */
    readonly engine: string;
    /**
     * `AWS::ElastiCache::CacheCluster.NumCacheNodes`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-cache-cluster.html#cfn-elasticache-cachecluster-numcachenodes
     * @external
     */
    readonly numCacheNodes: number;
    /**
     * `AWS::ElastiCache::CacheCluster.AutoMinorVersionUpgrade`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-cache-cluster.html#cfn-elasticache-cachecluster-autominorversionupgrade
     * @external
     */
    readonly autoMinorVersionUpgrade?: boolean | cdk.IResolvable;
    /**
     * `AWS::ElastiCache::CacheCluster.AZMode`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-cache-cluster.html#cfn-elasticache-cachecluster-azmode
     * @external
     */
    readonly azMode?: string;
    /**
     * `AWS::ElastiCache::CacheCluster.CacheParameterGroupName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-cache-cluster.html#cfn-elasticache-cachecluster-cacheparametergroupname
     * @external
     */
    readonly cacheParameterGroupName?: string;
    /**
     * `AWS::ElastiCache::CacheCluster.CacheSecurityGroupNames`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-cache-cluster.html#cfn-elasticache-cachecluster-cachesecuritygroupnames
     * @external
     */
    readonly cacheSecurityGroupNames?: string[];
    /**
     * `AWS::ElastiCache::CacheCluster.CacheSubnetGroupName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-cache-cluster.html#cfn-elasticache-cachecluster-cachesubnetgroupname
     * @external
     */
    readonly cacheSubnetGroupName?: string;
    /**
     * `AWS::ElastiCache::CacheCluster.ClusterName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-cache-cluster.html#cfn-elasticache-cachecluster-clustername
     * @external
     */
    readonly clusterName?: string;
    /**
     * `AWS::ElastiCache::CacheCluster.EngineVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-cache-cluster.html#cfn-elasticache-cachecluster-engineversion
     * @external
     */
    readonly engineVersion?: string;
    /**
     * `AWS::ElastiCache::CacheCluster.NotificationTopicArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-cache-cluster.html#cfn-elasticache-cachecluster-notificationtopicarn
     * @external
     */
    readonly notificationTopicArn?: string;
    /**
     * `AWS::ElastiCache::CacheCluster.Port`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-cache-cluster.html#cfn-elasticache-cachecluster-port
     * @external
     */
    readonly port?: number;
    /**
     * `AWS::ElastiCache::CacheCluster.PreferredAvailabilityZone`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-cache-cluster.html#cfn-elasticache-cachecluster-preferredavailabilityzone
     * @external
     */
    readonly preferredAvailabilityZone?: string;
    /**
     * `AWS::ElastiCache::CacheCluster.PreferredAvailabilityZones`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-cache-cluster.html#cfn-elasticache-cachecluster-preferredavailabilityzones
     * @external
     */
    readonly preferredAvailabilityZones?: string[];
    /**
     * `AWS::ElastiCache::CacheCluster.PreferredMaintenanceWindow`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-cache-cluster.html#cfn-elasticache-cachecluster-preferredmaintenancewindow
     * @external
     */
    readonly preferredMaintenanceWindow?: string;
    /**
     * `AWS::ElastiCache::CacheCluster.SnapshotArns`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-cache-cluster.html#cfn-elasticache-cachecluster-snapshotarns
     * @external
     */
    readonly snapshotArns?: string[];
    /**
     * `AWS::ElastiCache::CacheCluster.SnapshotName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-cache-cluster.html#cfn-elasticache-cachecluster-snapshotname
     * @external
     */
    readonly snapshotName?: string;
    /**
     * `AWS::ElastiCache::CacheCluster.SnapshotRetentionLimit`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-cache-cluster.html#cfn-elasticache-cachecluster-snapshotretentionlimit
     * @external
     */
    readonly snapshotRetentionLimit?: number;
    /**
     * `AWS::ElastiCache::CacheCluster.SnapshotWindow`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-cache-cluster.html#cfn-elasticache-cachecluster-snapshotwindow
     * @external
     */
    readonly snapshotWindow?: string;
    /**
     * `AWS::ElastiCache::CacheCluster.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-cache-cluster.html#cfn-elasticache-cachecluster-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::ElastiCache::CacheCluster.VpcSecurityGroupIds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-cache-cluster.html#cfn-elasticache-cachecluster-vpcsecuritygroupids
     * @external
     */
    readonly vpcSecurityGroupIds?: string[];
}
/**
 * A CloudFormation `AWS::ElastiCache::CacheCluster`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-cache-cluster.html
 * @external
 * @cloudformationResource AWS::ElastiCache::CacheCluster
 */
export declare class CfnCacheCluster extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ElastiCache::CacheCluster";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnCacheCluster;
    /**
     * @external
     * @cloudformationAttribute ConfigurationEndpoint.Address
     */
    readonly attrConfigurationEndpointAddress: string;
    /**
     * @external
     * @cloudformationAttribute ConfigurationEndpoint.Port
     */
    readonly attrConfigurationEndpointPort: string;
    /**
     * @external
     * @cloudformationAttribute RedisEndpoint.Address
     */
    readonly attrRedisEndpointAddress: string;
    /**
     * @external
     * @cloudformationAttribute RedisEndpoint.Port
     */
    readonly attrRedisEndpointPort: string;
    /**
     * `AWS::ElastiCache::CacheCluster.CacheNodeType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-cache-cluster.html#cfn-elasticache-cachecluster-cachenodetype
     * @external
     */
    cacheNodeType: string;
    /**
     * `AWS::ElastiCache::CacheCluster.Engine`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-cache-cluster.html#cfn-elasticache-cachecluster-engine
     * @external
     */
    engine: string;
    /**
     * `AWS::ElastiCache::CacheCluster.NumCacheNodes`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-cache-cluster.html#cfn-elasticache-cachecluster-numcachenodes
     * @external
     */
    numCacheNodes: number;
    /**
     * `AWS::ElastiCache::CacheCluster.AutoMinorVersionUpgrade`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-cache-cluster.html#cfn-elasticache-cachecluster-autominorversionupgrade
     * @external
     */
    autoMinorVersionUpgrade: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::ElastiCache::CacheCluster.AZMode`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-cache-cluster.html#cfn-elasticache-cachecluster-azmode
     * @external
     */
    azMode: string | undefined;
    /**
     * `AWS::ElastiCache::CacheCluster.CacheParameterGroupName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-cache-cluster.html#cfn-elasticache-cachecluster-cacheparametergroupname
     * @external
     */
    cacheParameterGroupName: string | undefined;
    /**
     * `AWS::ElastiCache::CacheCluster.CacheSecurityGroupNames`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-cache-cluster.html#cfn-elasticache-cachecluster-cachesecuritygroupnames
     * @external
     */
    cacheSecurityGroupNames: string[] | undefined;
    /**
     * `AWS::ElastiCache::CacheCluster.CacheSubnetGroupName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-cache-cluster.html#cfn-elasticache-cachecluster-cachesubnetgroupname
     * @external
     */
    cacheSubnetGroupName: string | undefined;
    /**
     * `AWS::ElastiCache::CacheCluster.ClusterName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-cache-cluster.html#cfn-elasticache-cachecluster-clustername
     * @external
     */
    clusterName: string | undefined;
    /**
     * `AWS::ElastiCache::CacheCluster.EngineVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-cache-cluster.html#cfn-elasticache-cachecluster-engineversion
     * @external
     */
    engineVersion: string | undefined;
    /**
     * `AWS::ElastiCache::CacheCluster.NotificationTopicArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-cache-cluster.html#cfn-elasticache-cachecluster-notificationtopicarn
     * @external
     */
    notificationTopicArn: string | undefined;
    /**
     * `AWS::ElastiCache::CacheCluster.Port`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-cache-cluster.html#cfn-elasticache-cachecluster-port
     * @external
     */
    port: number | undefined;
    /**
     * `AWS::ElastiCache::CacheCluster.PreferredAvailabilityZone`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-cache-cluster.html#cfn-elasticache-cachecluster-preferredavailabilityzone
     * @external
     */
    preferredAvailabilityZone: string | undefined;
    /**
     * `AWS::ElastiCache::CacheCluster.PreferredAvailabilityZones`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-cache-cluster.html#cfn-elasticache-cachecluster-preferredavailabilityzones
     * @external
     */
    preferredAvailabilityZones: string[] | undefined;
    /**
     * `AWS::ElastiCache::CacheCluster.PreferredMaintenanceWindow`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-cache-cluster.html#cfn-elasticache-cachecluster-preferredmaintenancewindow
     * @external
     */
    preferredMaintenanceWindow: string | undefined;
    /**
     * `AWS::ElastiCache::CacheCluster.SnapshotArns`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-cache-cluster.html#cfn-elasticache-cachecluster-snapshotarns
     * @external
     */
    snapshotArns: string[] | undefined;
    /**
     * `AWS::ElastiCache::CacheCluster.SnapshotName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-cache-cluster.html#cfn-elasticache-cachecluster-snapshotname
     * @external
     */
    snapshotName: string | undefined;
    /**
     * `AWS::ElastiCache::CacheCluster.SnapshotRetentionLimit`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-cache-cluster.html#cfn-elasticache-cachecluster-snapshotretentionlimit
     * @external
     */
    snapshotRetentionLimit: number | undefined;
    /**
     * `AWS::ElastiCache::CacheCluster.SnapshotWindow`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-cache-cluster.html#cfn-elasticache-cachecluster-snapshotwindow
     * @external
     */
    snapshotWindow: string | undefined;
    /**
     * `AWS::ElastiCache::CacheCluster.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-cache-cluster.html#cfn-elasticache-cachecluster-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::ElastiCache::CacheCluster.VpcSecurityGroupIds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-cache-cluster.html#cfn-elasticache-cachecluster-vpcsecuritygroupids
     * @external
     */
    vpcSecurityGroupIds: string[] | undefined;
    /**
     * Create a new `AWS::ElastiCache::CacheCluster`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnCacheClusterProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::ElastiCache::ParameterGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-parameter-group.html
 * @external
 */
export interface CfnParameterGroupProps {
    /**
     * `AWS::ElastiCache::ParameterGroup.CacheParameterGroupFamily`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-parameter-group.html#cfn-elasticache-parametergroup-cacheparametergroupfamily
     * @external
     */
    readonly cacheParameterGroupFamily: string;
    /**
     * `AWS::ElastiCache::ParameterGroup.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-parameter-group.html#cfn-elasticache-parametergroup-description
     * @external
     */
    readonly description: string;
    /**
     * `AWS::ElastiCache::ParameterGroup.Properties`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-parameter-group.html#cfn-elasticache-parametergroup-properties
     * @external
     */
    readonly properties?: {
        [key: string]: (string);
    } | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::ElastiCache::ParameterGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-parameter-group.html
 * @external
 * @cloudformationResource AWS::ElastiCache::ParameterGroup
 */
export declare class CfnParameterGroup extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ElastiCache::ParameterGroup";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnParameterGroup;
    /**
     * `AWS::ElastiCache::ParameterGroup.CacheParameterGroupFamily`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-parameter-group.html#cfn-elasticache-parametergroup-cacheparametergroupfamily
     * @external
     */
    cacheParameterGroupFamily: string;
    /**
     * `AWS::ElastiCache::ParameterGroup.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-parameter-group.html#cfn-elasticache-parametergroup-description
     * @external
     */
    description: string;
    /**
     * `AWS::ElastiCache::ParameterGroup.Properties`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-parameter-group.html#cfn-elasticache-parametergroup-properties
     * @external
     */
    properties: {
        [key: string]: (string);
    } | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::ElastiCache::ParameterGroup`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnParameterGroupProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::ElastiCache::ReplicationGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-replicationgroup.html
 * @external
 */
export interface CfnReplicationGroupProps {
    /**
     * `AWS::ElastiCache::ReplicationGroup.ReplicationGroupDescription`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-replicationgroup.html#cfn-elasticache-replicationgroup-replicationgroupdescription
     * @external
     */
    readonly replicationGroupDescription: string;
    /**
     * `AWS::ElastiCache::ReplicationGroup.AtRestEncryptionEnabled`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-replicationgroup.html#cfn-elasticache-replicationgroup-atrestencryptionenabled
     * @external
     */
    readonly atRestEncryptionEnabled?: boolean | cdk.IResolvable;
    /**
     * `AWS::ElastiCache::ReplicationGroup.AuthToken`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-replicationgroup.html#cfn-elasticache-replicationgroup-authtoken
     * @external
     */
    readonly authToken?: string;
    /**
     * `AWS::ElastiCache::ReplicationGroup.AutomaticFailoverEnabled`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-replicationgroup.html#cfn-elasticache-replicationgroup-automaticfailoverenabled
     * @external
     */
    readonly automaticFailoverEnabled?: boolean | cdk.IResolvable;
    /**
     * `AWS::ElastiCache::ReplicationGroup.AutoMinorVersionUpgrade`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-replicationgroup.html#cfn-elasticache-replicationgroup-autominorversionupgrade
     * @external
     */
    readonly autoMinorVersionUpgrade?: boolean | cdk.IResolvable;
    /**
     * `AWS::ElastiCache::ReplicationGroup.CacheNodeType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-replicationgroup.html#cfn-elasticache-replicationgroup-cachenodetype
     * @external
     */
    readonly cacheNodeType?: string;
    /**
     * `AWS::ElastiCache::ReplicationGroup.CacheParameterGroupName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-replicationgroup.html#cfn-elasticache-replicationgroup-cacheparametergroupname
     * @external
     */
    readonly cacheParameterGroupName?: string;
    /**
     * `AWS::ElastiCache::ReplicationGroup.CacheSecurityGroupNames`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-replicationgroup.html#cfn-elasticache-replicationgroup-cachesecuritygroupnames
     * @external
     */
    readonly cacheSecurityGroupNames?: string[];
    /**
     * `AWS::ElastiCache::ReplicationGroup.CacheSubnetGroupName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-replicationgroup.html#cfn-elasticache-replicationgroup-cachesubnetgroupname
     * @external
     */
    readonly cacheSubnetGroupName?: string;
    /**
     * `AWS::ElastiCache::ReplicationGroup.Engine`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-replicationgroup.html#cfn-elasticache-replicationgroup-engine
     * @external
     */
    readonly engine?: string;
    /**
     * `AWS::ElastiCache::ReplicationGroup.EngineVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-replicationgroup.html#cfn-elasticache-replicationgroup-engineversion
     * @external
     */
    readonly engineVersion?: string;
    /**
     * `AWS::ElastiCache::ReplicationGroup.KmsKeyId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-replicationgroup.html#cfn-elasticache-replicationgroup-kmskeyid
     * @external
     */
    readonly kmsKeyId?: string;
    /**
     * `AWS::ElastiCache::ReplicationGroup.MultiAZEnabled`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-replicationgroup.html#cfn-elasticache-replicationgroup-multiazenabled
     * @external
     */
    readonly multiAzEnabled?: boolean | cdk.IResolvable;
    /**
     * `AWS::ElastiCache::ReplicationGroup.NodeGroupConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-replicationgroup.html#cfn-elasticache-replicationgroup-nodegroupconfiguration
     * @external
     */
    readonly nodeGroupConfiguration?: Array<CfnReplicationGroup.NodeGroupConfigurationProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::ElastiCache::ReplicationGroup.NotificationTopicArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-replicationgroup.html#cfn-elasticache-replicationgroup-notificationtopicarn
     * @external
     */
    readonly notificationTopicArn?: string;
    /**
     * `AWS::ElastiCache::ReplicationGroup.NumCacheClusters`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-replicationgroup.html#cfn-elasticache-replicationgroup-numcacheclusters
     * @external
     */
    readonly numCacheClusters?: number;
    /**
     * `AWS::ElastiCache::ReplicationGroup.NumNodeGroups`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-replicationgroup.html#cfn-elasticache-replicationgroup-numnodegroups
     * @external
     */
    readonly numNodeGroups?: number;
    /**
     * `AWS::ElastiCache::ReplicationGroup.Port`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-replicationgroup.html#cfn-elasticache-replicationgroup-port
     * @external
     */
    readonly port?: number;
    /**
     * `AWS::ElastiCache::ReplicationGroup.PreferredCacheClusterAZs`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-replicationgroup.html#cfn-elasticache-replicationgroup-preferredcacheclusterazs
     * @external
     */
    readonly preferredCacheClusterAZs?: string[];
    /**
     * `AWS::ElastiCache::ReplicationGroup.PreferredMaintenanceWindow`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-replicationgroup.html#cfn-elasticache-replicationgroup-preferredmaintenancewindow
     * @external
     */
    readonly preferredMaintenanceWindow?: string;
    /**
     * `AWS::ElastiCache::ReplicationGroup.PrimaryClusterId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-replicationgroup.html#cfn-elasticache-replicationgroup-primaryclusterid
     * @external
     */
    readonly primaryClusterId?: string;
    /**
     * `AWS::ElastiCache::ReplicationGroup.ReplicasPerNodeGroup`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-replicationgroup.html#cfn-elasticache-replicationgroup-replicaspernodegroup
     * @external
     */
    readonly replicasPerNodeGroup?: number;
    /**
     * `AWS::ElastiCache::ReplicationGroup.ReplicationGroupId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-replicationgroup.html#cfn-elasticache-replicationgroup-replicationgroupid
     * @external
     */
    readonly replicationGroupId?: string;
    /**
     * `AWS::ElastiCache::ReplicationGroup.SecurityGroupIds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-replicationgroup.html#cfn-elasticache-replicationgroup-securitygroupids
     * @external
     */
    readonly securityGroupIds?: string[];
    /**
     * `AWS::ElastiCache::ReplicationGroup.SnapshotArns`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-replicationgroup.html#cfn-elasticache-replicationgroup-snapshotarns
     * @external
     */
    readonly snapshotArns?: string[];
    /**
     * `AWS::ElastiCache::ReplicationGroup.SnapshotName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-replicationgroup.html#cfn-elasticache-replicationgroup-snapshotname
     * @external
     */
    readonly snapshotName?: string;
    /**
     * `AWS::ElastiCache::ReplicationGroup.SnapshotRetentionLimit`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-replicationgroup.html#cfn-elasticache-replicationgroup-snapshotretentionlimit
     * @external
     */
    readonly snapshotRetentionLimit?: number;
    /**
     * `AWS::ElastiCache::ReplicationGroup.SnapshottingClusterId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-replicationgroup.html#cfn-elasticache-replicationgroup-snapshottingclusterid
     * @external
     */
    readonly snapshottingClusterId?: string;
    /**
     * `AWS::ElastiCache::ReplicationGroup.SnapshotWindow`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-replicationgroup.html#cfn-elasticache-replicationgroup-snapshotwindow
     * @external
     */
    readonly snapshotWindow?: string;
    /**
     * `AWS::ElastiCache::ReplicationGroup.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-replicationgroup.html#cfn-elasticache-replicationgroup-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::ElastiCache::ReplicationGroup.TransitEncryptionEnabled`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-replicationgroup.html#cfn-elasticache-replicationgroup-transitencryptionenabled
     * @external
     */
    readonly transitEncryptionEnabled?: boolean | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::ElastiCache::ReplicationGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-replicationgroup.html
 * @external
 * @cloudformationResource AWS::ElastiCache::ReplicationGroup
 */
export declare class CfnReplicationGroup extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ElastiCache::ReplicationGroup";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnReplicationGroup;
    /**
     * @external
     * @cloudformationAttribute ConfigurationEndPoint.Address
     */
    readonly attrConfigurationEndPointAddress: string;
    /**
     * @external
     * @cloudformationAttribute ConfigurationEndPoint.Port
     */
    readonly attrConfigurationEndPointPort: string;
    /**
     * @external
     * @cloudformationAttribute PrimaryEndPoint.Address
     */
    readonly attrPrimaryEndPointAddress: string;
    /**
     * @external
     * @cloudformationAttribute PrimaryEndPoint.Port
     */
    readonly attrPrimaryEndPointPort: string;
    /**
     * @external
     * @cloudformationAttribute ReadEndPoint.Addresses
     */
    readonly attrReadEndPointAddresses: string;
    /**
     * @external
     * @cloudformationAttribute ReadEndPoint.Addresses.List
     */
    readonly attrReadEndPointAddressesList: string[];
    /**
     * @external
     * @cloudformationAttribute ReadEndPoint.Ports
     */
    readonly attrReadEndPointPorts: string;
    /**
     * @external
     * @cloudformationAttribute ReadEndPoint.Ports.List
     */
    readonly attrReadEndPointPortsList: string[];
    /**
     * @external
     * @cloudformationAttribute ReaderEndPoint.Address
     */
    readonly attrReaderEndPointAddress: string;
    /**
     * @external
     * @cloudformationAttribute ReaderEndPoint.Port
     */
    readonly attrReaderEndPointPort: string;
    /**
     * `AWS::ElastiCache::ReplicationGroup.ReplicationGroupDescription`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-replicationgroup.html#cfn-elasticache-replicationgroup-replicationgroupdescription
     * @external
     */
    replicationGroupDescription: string;
    /**
     * `AWS::ElastiCache::ReplicationGroup.AtRestEncryptionEnabled`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-replicationgroup.html#cfn-elasticache-replicationgroup-atrestencryptionenabled
     * @external
     */
    atRestEncryptionEnabled: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::ElastiCache::ReplicationGroup.AuthToken`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-replicationgroup.html#cfn-elasticache-replicationgroup-authtoken
     * @external
     */
    authToken: string | undefined;
    /**
     * `AWS::ElastiCache::ReplicationGroup.AutomaticFailoverEnabled`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-replicationgroup.html#cfn-elasticache-replicationgroup-automaticfailoverenabled
     * @external
     */
    automaticFailoverEnabled: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::ElastiCache::ReplicationGroup.AutoMinorVersionUpgrade`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-replicationgroup.html#cfn-elasticache-replicationgroup-autominorversionupgrade
     * @external
     */
    autoMinorVersionUpgrade: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::ElastiCache::ReplicationGroup.CacheNodeType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-replicationgroup.html#cfn-elasticache-replicationgroup-cachenodetype
     * @external
     */
    cacheNodeType: string | undefined;
    /**
     * `AWS::ElastiCache::ReplicationGroup.CacheParameterGroupName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-replicationgroup.html#cfn-elasticache-replicationgroup-cacheparametergroupname
     * @external
     */
    cacheParameterGroupName: string | undefined;
    /**
     * `AWS::ElastiCache::ReplicationGroup.CacheSecurityGroupNames`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-replicationgroup.html#cfn-elasticache-replicationgroup-cachesecuritygroupnames
     * @external
     */
    cacheSecurityGroupNames: string[] | undefined;
    /**
     * `AWS::ElastiCache::ReplicationGroup.CacheSubnetGroupName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-replicationgroup.html#cfn-elasticache-replicationgroup-cachesubnetgroupname
     * @external
     */
    cacheSubnetGroupName: string | undefined;
    /**
     * `AWS::ElastiCache::ReplicationGroup.Engine`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-replicationgroup.html#cfn-elasticache-replicationgroup-engine
     * @external
     */
    engine: string | undefined;
    /**
     * `AWS::ElastiCache::ReplicationGroup.EngineVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-replicationgroup.html#cfn-elasticache-replicationgroup-engineversion
     * @external
     */
    engineVersion: string | undefined;
    /**
     * `AWS::ElastiCache::ReplicationGroup.KmsKeyId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-replicationgroup.html#cfn-elasticache-replicationgroup-kmskeyid
     * @external
     */
    kmsKeyId: string | undefined;
    /**
     * `AWS::ElastiCache::ReplicationGroup.MultiAZEnabled`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-replicationgroup.html#cfn-elasticache-replicationgroup-multiazenabled
     * @external
     */
    multiAzEnabled: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::ElastiCache::ReplicationGroup.NodeGroupConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-replicationgroup.html#cfn-elasticache-replicationgroup-nodegroupconfiguration
     * @external
     */
    nodeGroupConfiguration: Array<CfnReplicationGroup.NodeGroupConfigurationProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::ElastiCache::ReplicationGroup.NotificationTopicArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-replicationgroup.html#cfn-elasticache-replicationgroup-notificationtopicarn
     * @external
     */
    notificationTopicArn: string | undefined;
    /**
     * `AWS::ElastiCache::ReplicationGroup.NumCacheClusters`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-replicationgroup.html#cfn-elasticache-replicationgroup-numcacheclusters
     * @external
     */
    numCacheClusters: number | undefined;
    /**
     * `AWS::ElastiCache::ReplicationGroup.NumNodeGroups`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-replicationgroup.html#cfn-elasticache-replicationgroup-numnodegroups
     * @external
     */
    numNodeGroups: number | undefined;
    /**
     * `AWS::ElastiCache::ReplicationGroup.Port`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-replicationgroup.html#cfn-elasticache-replicationgroup-port
     * @external
     */
    port: number | undefined;
    /**
     * `AWS::ElastiCache::ReplicationGroup.PreferredCacheClusterAZs`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-replicationgroup.html#cfn-elasticache-replicationgroup-preferredcacheclusterazs
     * @external
     */
    preferredCacheClusterAZs: string[] | undefined;
    /**
     * `AWS::ElastiCache::ReplicationGroup.PreferredMaintenanceWindow`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-replicationgroup.html#cfn-elasticache-replicationgroup-preferredmaintenancewindow
     * @external
     */
    preferredMaintenanceWindow: string | undefined;
    /**
     * `AWS::ElastiCache::ReplicationGroup.PrimaryClusterId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-replicationgroup.html#cfn-elasticache-replicationgroup-primaryclusterid
     * @external
     */
    primaryClusterId: string | undefined;
    /**
     * `AWS::ElastiCache::ReplicationGroup.ReplicasPerNodeGroup`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-replicationgroup.html#cfn-elasticache-replicationgroup-replicaspernodegroup
     * @external
     */
    replicasPerNodeGroup: number | undefined;
    /**
     * `AWS::ElastiCache::ReplicationGroup.ReplicationGroupId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-replicationgroup.html#cfn-elasticache-replicationgroup-replicationgroupid
     * @external
     */
    replicationGroupId: string | undefined;
    /**
     * `AWS::ElastiCache::ReplicationGroup.SecurityGroupIds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-replicationgroup.html#cfn-elasticache-replicationgroup-securitygroupids
     * @external
     */
    securityGroupIds: string[] | undefined;
    /**
     * `AWS::ElastiCache::ReplicationGroup.SnapshotArns`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-replicationgroup.html#cfn-elasticache-replicationgroup-snapshotarns
     * @external
     */
    snapshotArns: string[] | undefined;
    /**
     * `AWS::ElastiCache::ReplicationGroup.SnapshotName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-replicationgroup.html#cfn-elasticache-replicationgroup-snapshotname
     * @external
     */
    snapshotName: string | undefined;
    /**
     * `AWS::ElastiCache::ReplicationGroup.SnapshotRetentionLimit`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-replicationgroup.html#cfn-elasticache-replicationgroup-snapshotretentionlimit
     * @external
     */
    snapshotRetentionLimit: number | undefined;
    /**
     * `AWS::ElastiCache::ReplicationGroup.SnapshottingClusterId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-replicationgroup.html#cfn-elasticache-replicationgroup-snapshottingclusterid
     * @external
     */
    snapshottingClusterId: string | undefined;
    /**
     * `AWS::ElastiCache::ReplicationGroup.SnapshotWindow`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-replicationgroup.html#cfn-elasticache-replicationgroup-snapshotwindow
     * @external
     */
    snapshotWindow: string | undefined;
    /**
     * `AWS::ElastiCache::ReplicationGroup.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-replicationgroup.html#cfn-elasticache-replicationgroup-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::ElastiCache::ReplicationGroup.TransitEncryptionEnabled`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-replicationgroup.html#cfn-elasticache-replicationgroup-transitencryptionenabled
     * @external
     */
    transitEncryptionEnabled: boolean | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::ElastiCache::ReplicationGroup`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnReplicationGroupProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::ElastiCache::ReplicationGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-replicationgroup.html
 * @external
 * @cloudformationResource AWS::ElastiCache::ReplicationGroup
 */
export declare namespace CfnReplicationGroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-replicationgroup-nodegroupconfiguration.html
     * @external
     */
    interface NodeGroupConfigurationProperty {
        /**
         * `CfnReplicationGroup.NodeGroupConfigurationProperty.NodeGroupId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-replicationgroup-nodegroupconfiguration.html#cfn-elasticache-replicationgroup-nodegroupconfiguration-nodegroupid
         * @external
         */
        readonly nodeGroupId?: string;
        /**
         * `CfnReplicationGroup.NodeGroupConfigurationProperty.PrimaryAvailabilityZone`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-replicationgroup-nodegroupconfiguration.html#cfn-elasticache-replicationgroup-nodegroupconfiguration-primaryavailabilityzone
         * @external
         */
        readonly primaryAvailabilityZone?: string;
        /**
         * `CfnReplicationGroup.NodeGroupConfigurationProperty.ReplicaAvailabilityZones`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-replicationgroup-nodegroupconfiguration.html#cfn-elasticache-replicationgroup-nodegroupconfiguration-replicaavailabilityzones
         * @external
         */
        readonly replicaAvailabilityZones?: string[];
        /**
         * `CfnReplicationGroup.NodeGroupConfigurationProperty.ReplicaCount`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-replicationgroup-nodegroupconfiguration.html#cfn-elasticache-replicationgroup-nodegroupconfiguration-replicacount
         * @external
         */
        readonly replicaCount?: number;
        /**
         * `CfnReplicationGroup.NodeGroupConfigurationProperty.Slots`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-replicationgroup-nodegroupconfiguration.html#cfn-elasticache-replicationgroup-nodegroupconfiguration-slots
         * @external
         */
        readonly slots?: string;
    }
}
/**
 * Properties for defining a `AWS::ElastiCache::SecurityGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-security-group.html
 * @external
 */
export interface CfnSecurityGroupProps {
    /**
     * `AWS::ElastiCache::SecurityGroup.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-security-group.html#cfn-elasticache-securitygroup-description
     * @external
     */
    readonly description: string;
}
/**
 * A CloudFormation `AWS::ElastiCache::SecurityGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-security-group.html
 * @external
 * @cloudformationResource AWS::ElastiCache::SecurityGroup
 */
export declare class CfnSecurityGroup extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ElastiCache::SecurityGroup";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnSecurityGroup;
    /**
     * `AWS::ElastiCache::SecurityGroup.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-security-group.html#cfn-elasticache-securitygroup-description
     * @external
     */
    description: string;
    /**
     * Create a new `AWS::ElastiCache::SecurityGroup`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnSecurityGroupProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::ElastiCache::SecurityGroupIngress`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-security-group-ingress.html
 * @external
 */
export interface CfnSecurityGroupIngressProps {
    /**
     * `AWS::ElastiCache::SecurityGroupIngress.CacheSecurityGroupName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-security-group-ingress.html#cfn-elasticache-securitygroupingress-cachesecuritygroupname
     * @external
     */
    readonly cacheSecurityGroupName: string;
    /**
     * `AWS::ElastiCache::SecurityGroupIngress.EC2SecurityGroupName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-security-group-ingress.html#cfn-elasticache-securitygroupingress-ec2securitygroupname
     * @external
     */
    readonly ec2SecurityGroupName: string;
    /**
     * `AWS::ElastiCache::SecurityGroupIngress.EC2SecurityGroupOwnerId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-security-group-ingress.html#cfn-elasticache-securitygroupingress-ec2securitygroupownerid
     * @external
     */
    readonly ec2SecurityGroupOwnerId?: string;
}
/**
 * A CloudFormation `AWS::ElastiCache::SecurityGroupIngress`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-security-group-ingress.html
 * @external
 * @cloudformationResource AWS::ElastiCache::SecurityGroupIngress
 */
export declare class CfnSecurityGroupIngress extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ElastiCache::SecurityGroupIngress";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnSecurityGroupIngress;
    /**
     * `AWS::ElastiCache::SecurityGroupIngress.CacheSecurityGroupName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-security-group-ingress.html#cfn-elasticache-securitygroupingress-cachesecuritygroupname
     * @external
     */
    cacheSecurityGroupName: string;
    /**
     * `AWS::ElastiCache::SecurityGroupIngress.EC2SecurityGroupName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-security-group-ingress.html#cfn-elasticache-securitygroupingress-ec2securitygroupname
     * @external
     */
    ec2SecurityGroupName: string;
    /**
     * `AWS::ElastiCache::SecurityGroupIngress.EC2SecurityGroupOwnerId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-security-group-ingress.html#cfn-elasticache-securitygroupingress-ec2securitygroupownerid
     * @external
     */
    ec2SecurityGroupOwnerId: string | undefined;
    /**
     * Create a new `AWS::ElastiCache::SecurityGroupIngress`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnSecurityGroupIngressProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::ElastiCache::SubnetGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-subnetgroup.html
 * @external
 */
export interface CfnSubnetGroupProps {
    /**
     * `AWS::ElastiCache::SubnetGroup.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-subnetgroup.html#cfn-elasticache-subnetgroup-description
     * @external
     */
    readonly description: string;
    /**
     * `AWS::ElastiCache::SubnetGroup.SubnetIds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-subnetgroup.html#cfn-elasticache-subnetgroup-subnetids
     * @external
     */
    readonly subnetIds: string[];
    /**
     * `AWS::ElastiCache::SubnetGroup.CacheSubnetGroupName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-subnetgroup.html#cfn-elasticache-subnetgroup-cachesubnetgroupname
     * @external
     */
    readonly cacheSubnetGroupName?: string;
}
/**
 * A CloudFormation `AWS::ElastiCache::SubnetGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-subnetgroup.html
 * @external
 * @cloudformationResource AWS::ElastiCache::SubnetGroup
 */
export declare class CfnSubnetGroup extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ElastiCache::SubnetGroup";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnSubnetGroup;
    /**
     * `AWS::ElastiCache::SubnetGroup.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-subnetgroup.html#cfn-elasticache-subnetgroup-description
     * @external
     */
    description: string;
    /**
     * `AWS::ElastiCache::SubnetGroup.SubnetIds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-subnetgroup.html#cfn-elasticache-subnetgroup-subnetids
     * @external
     */
    subnetIds: string[];
    /**
     * `AWS::ElastiCache::SubnetGroup.CacheSubnetGroupName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-subnetgroup.html#cfn-elasticache-subnetgroup-cachesubnetgroupname
     * @external
     */
    cacheSubnetGroupName: string | undefined;
    /**
     * Create a new `AWS::ElastiCache::SubnetGroup`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnSubnetGroupProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
